/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core.meta;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.Set;
import org.beetl.sql.clazz.ColDesc;
import org.beetl.sql.clazz.TableDesc;
import org.beetl.sql.clazz.kit.BeetlSQLException;
import org.beetl.sql.clazz.kit.ThreadSafeCaseInsensitiveHashMap;
import org.beetl.sql.core.ConnectionSource;
import org.beetl.sql.core.db.DBStyle;
import org.beetl.sql.core.meta.MetadataManager;

public class SchemaMetadataManager
implements MetadataManager {
    protected ConnectionSource ds = null;
    protected ThreadSafeCaseInsensitiveHashMap tableInfoMap = null;
    protected TableDesc NOT_EXIST = new TableDesc("$$$NOT_EXIST", "");
    protected DBStyle style;
    protected String defaultSchema;
    protected String defaultCatalog;
    protected String dbName = null;
    boolean checkAuto = true;
    ThreadSafeCaseInsensitiveHashMap tableVirtual = new ThreadSafeCaseInsensitiveHashMap();

    public SchemaMetadataManager(ConnectionSource ds, DBStyle style) {
        this.ds = ds;
        this.style = style;
        this.dbName = style.getName();
        this.initDefaultSchema();
    }

    public SchemaMetadataManager(ConnectionSource ds, String defaultSchema, String defaultCatalog, DBStyle style) {
        this.ds = ds;
        this.dbName = style.getName();
        this.defaultSchema = defaultSchema;
        this.defaultCatalog = defaultCatalog;
    }

    @Override
    public boolean existTable(String tableName) {
        TableDesc t = this.getTable(tableName);
        return t != null;
    }

    @Override
    public TableDesc getTable(String name) {
        TableDesc table = this.getTableFromMap(name);
        if (table == null) {
            throw new BeetlSQLException(8, "table \"" + name + "\" not exist");
        }
        if (table.getCols().size() == 0) {
            table = this.initTable(table);
        }
        return table;
    }

    @Override
    public Set<String> allTable() {
        if (this.tableInfoMap == null) {
            this.initMetadata();
        }
        return this.tableInfoMap.keySet();
    }

    public void refresh() {
        this.tableInfoMap = null;
        this.initMetadata();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TableDesc getTableFromMap(String tableName) {
        TableDesc desc = null;
        if (this.tableInfoMap == null) {
            SchemaMetadataManager schemaMetadataManager = this;
            synchronized (schemaMetadataManager) {
                if (this.tableInfoMap != null) {
                    desc = (TableDesc)this.tableInfoMap.get((Object)tableName);
                } else {
                    this.initMetadata();
                    desc = (TableDesc)this.tableInfoMap.get((Object)tableName);
                }
            }
        } else {
            desc = (TableDesc)this.tableInfoMap.get((Object)tableName);
        }
        if (desc == this.NOT_EXIST) {
            return null;
        }
        if (desc == null) {
            int index = tableName.indexOf(".");
            if (index != -1) {
                String schema = tableName.substring(0, index);
                String table = tableName.substring(index + 1);
                return this.initOtherSchemaTable(schema, table);
            }
            return null;
        }
        return desc;
    }

    private TableDesc initTable(TableDesc desc) {
        TableDesc tableDesc = desc;
        synchronized (tableDesc) {
            TableDesc tableDesc2;
            if (!desc.getCols().isEmpty()) {
                return desc;
            }
            TableDesc temp = new TableDesc(desc.getName(), desc.getRemark());
            temp.setRealTableName(desc.getRealTableName());
            temp.setCatalog(desc.getCatalog());
            temp.setSchema(desc.getSchema());
            Connection conn = null;
            ResultSet rs = null;
            String tableName = desc.getRealTableName() != null ? desc.getRealTableName() : desc.getName();
            try {
                String catalog = temp.getCatalog();
                String schema = temp.getSchema();
                schema = this.getDbSchema(schema);
                conn = this.ds.getMetaData();
                DatabaseMetaData dbmd = conn.getMetaData();
                rs = dbmd.getPrimaryKeys(catalog, schema, tableName);
                while (rs.next()) {
                    String idName = rs.getString("COLUMN_NAME");
                    temp.addIdName(idName);
                }
                rs.close();
                rs = dbmd.getColumns(catalog, schema, tableName, "%");
                while (rs.next()) {
                    String colName = rs.getString("COLUMN_NAME");
                    Integer sqlType = rs.getInt("DATA_TYPE");
                    Integer size = rs.getInt("COLUMN_SIZE");
                    Object o = rs.getObject("DECIMAL_DIGITS");
                    String isNullable = (String)rs.getObject("IS_NULLABLE");
                    Integer digit = null;
                    if (o != null) {
                        digit = ((Number)o).intValue();
                    }
                    String remark = rs.getString("REMARKS");
                    ColDesc col = new ColDesc(colName, sqlType, size, digit, remark, isNullable);
                    try {
                        String auto;
                        if (this.checkAuto && (auto = rs.getString("IS_AUTOINCREMENT")) != null && auto.equals("YES")) {
                            col.setAuto(true);
                        }
                    }
                    catch (SQLException ex) {
                        this.checkAuto = false;
                    }
                    temp.addCols(col);
                }
                rs.close();
                this.moreInfo(temp);
                this.tableInfoMap.put(temp.getName(), (Object)temp);
                tableDesc2 = temp;
                this.close(conn);
            }
            catch (SQLException e) {
                try {
                    throw new BeetlSQLException(1, (Throwable)e);
                }
                catch (Throwable throwable) {
                    this.close(conn);
                    throw throwable;
                }
            }
            return tableDesc2;
        }
    }

    private synchronized void initMetadata() {
        ThreadSafeCaseInsensitiveHashMap tempMap = new ThreadSafeCaseInsensitiveHashMap();
        Connection conn = null;
        try {
            conn = this.ds.getMetaData();
            DatabaseMetaData dbmd = conn.getMetaData();
            String catalog = this.defaultCatalog;
            String schema = this.defaultSchema;
            String namePattern = this.getTableNamePattern(dbmd);
            ResultSet rs = dbmd.getTables(catalog, schema, namePattern, this.getScope(catalog, schema));
            while (rs.next()) {
                String name = rs.getString("TABLE_NAME");
                String remarks = rs.getString("REMARKS");
                TableDesc desc = new TableDesc(name, remarks);
                desc.setSchema(this.defaultSchema);
                desc.setCatalog(catalog);
                tempMap.put(desc.getName(), (Object)desc);
                if (this.tableVirtual.isEmpty() || !this.tableVirtual.containsKey((Object)name)) continue;
                TableDesc newDesc = this.copyVirtualTable((String)this.tableVirtual.get((Object)name), desc);
                tempMap.put(newDesc.getName(), (Object)newDesc);
            }
            rs.close();
            this.tableInfoMap = tempMap;
        }
        catch (SQLException e) {
            throw new BeetlSQLException(1, (Throwable)e);
        }
        finally {
            this.close(conn);
        }
    }

    protected TableDesc copyVirtualTable(String virtualName, TableDesc desc) {
        TableDesc newDesc = new TableDesc(virtualName, desc.getRemark());
        newDesc.setRealTableName(desc.getName());
        newDesc.setCatalog(desc.getCatalog());
        newDesc.setSchema(desc.getSchema());
        return newDesc;
    }

    protected TableDesc initOtherSchemaTable(String tablePrefix, String table) {
        Connection conn = null;
        try {
            TableDesc tableDesc;
            conn = this.ds.getMetaData();
            DatabaseMetaData dbmd = conn.getMetaData();
            String catalog = this.getDbCatalog(tablePrefix);
            String schema = this.getDbSchema(tablePrefix);
            ResultSet rs = null;
            rs = dbmd.getTables(catalog, schema, this.getDbTableName(table), this.getScope(catalog, schema));
            TableDesc desc = null;
            while (rs.next()) {
                String name = rs.getString("TABLE_NAME");
                String remarks = rs.getString("REMARKS");
                desc = new TableDesc(name, remarks);
                desc.setSchema(tablePrefix);
                desc.setCatalog(catalog);
                this.tableInfoMap.put(tablePrefix + "." + table, (Object)desc);
            }
            rs.close();
            if (desc != null) {
                tableDesc = desc;
                return tableDesc;
            }
            this.tableInfoMap.put(schema + "." + table, (Object)this.NOT_EXIST);
            tableDesc = null;
            return tableDesc;
        }
        catch (SQLException e) {
            throw new BeetlSQLException(1, (Throwable)e);
        }
        finally {
            this.close(conn);
        }
    }

    protected void close(Connection conn) {
        try {
            if (!this.ds.isTransaction() && conn != null) {
                conn.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void initDefaultSchema() {
        if (this.defaultSchema == null) {
            Connection conn = this.ds.getMetaData();
            try {
                this.setSchemaAndCatalogByConnection(conn);
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
            finally {
                this.close(conn);
            }
        }
    }

    protected void setSchemaAndCatalogByConnection(Connection conn) throws SQLException {
        try {
            this.defaultCatalog = conn.getCatalog();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.defaultSchema = conn.getSchema();
        }
        catch (Throwable e) {
            this.setDBDefaultSchema(conn);
        }
    }

    protected void setDBDefaultSchema(Connection conn) throws SQLException {
        this.defaultSchema = this.dbName.equals("oracle") ? conn.getMetaData().getUserName() : this.style.getDefaultSchema();
    }

    protected String[] getScope(String catalog, String schema) {
        return new String[]{"TABLE", "VIEW"};
    }

    protected String getDbSchema(DatabaseMetaData dbmd, String namespace) {
        if (this.dbName.equals("mysql")) {
            return null;
        }
        if (this.dbName.equals("oracle")) {
            return namespace.toUpperCase();
        }
        return namespace;
    }

    protected void moreInfo(TableDesc tableDesc) {
    }

    protected String getTableNamePattern(DatabaseMetaData meta) throws SQLException {
        int c;
        String p = meta.getDatabaseProductName();
        if (p.equalsIgnoreCase("mysql") && (c = meta.getDriverMajorVersion()) == 6) {
            return "%";
        }
        return null;
    }

    protected String getDbSchema(String namespace) {
        if (this.dbName.equals("mysql")) {
            return null;
        }
        if (this.dbName.equals("oracle")) {
            return namespace.toUpperCase();
        }
        return namespace;
    }

    private String getDbCatalog(String schema) {
        if (this.dbName.equals("mysql")) {
            return schema;
        }
        return null;
    }

    private String getDbTableName(String name) {
        if (this.dbName.equals("oracle")) {
            return name.toUpperCase();
        }
        return name;
    }

    public Map<String, String> getTableVirtual() {
        return this.tableVirtual;
    }

    @Override
    public void addTableVirtual(String realTable, String virtual) {
        this.tableVirtual.put(realTable, (Object)virtual);
        if (this.tableInfoMap == null) {
            return;
        }
        if (this.tableInfoMap.containsKey((Object)realTable)) {
            return;
        }
        TableDesc desc = (TableDesc)this.tableInfoMap.get((Object)realTable);
        TableDesc virutalTableDesc = new TableDesc(virtual, desc.getRemark());
        virutalTableDesc.setRealTableName(realTable);
    }
}

