/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.beetl.sql.clazz.ClassDesc;
import org.beetl.sql.clazz.NameConversion;
import org.beetl.sql.clazz.TableDesc;
import org.beetl.sql.clazz.kit.AutoSQLEnum;
import org.beetl.sql.clazz.kit.ClassLoaderKit;
import org.beetl.sql.core.ConnectionSource;
import org.beetl.sql.core.IDAutoGen;
import org.beetl.sql.core.Interceptor;
import org.beetl.sql.core.MapperBuilder;
import org.beetl.sql.core.OnConnection;
import org.beetl.sql.core.SQLBatchReady;
import org.beetl.sql.core.SQLExecutor;
import org.beetl.sql.core.SQLManager;
import org.beetl.sql.core.SQLReady;
import org.beetl.sql.core.SQLResult;
import org.beetl.sql.core.SQLSource;
import org.beetl.sql.core.SqlId;
import org.beetl.sql.core.SqlIdFactory;
import org.beetl.sql.core.db.DBStyle;
import org.beetl.sql.core.engine.template.SQLErrorInfo;
import org.beetl.sql.core.engine.template.SQLTemplateEngine;
import org.beetl.sql.core.engine.template.TemplateContext;
import org.beetl.sql.core.loader.SQLLoader;
import org.beetl.sql.core.mapping.BeanProcessor;
import org.beetl.sql.core.meta.MetadataManager;
import org.beetl.sql.core.meta.SchemaMetadataManager;
import org.beetl.sql.core.page.PageRequest;
import org.beetl.sql.core.page.PageResult;
import org.beetl.sql.core.query.LambdaQuery;
import org.beetl.sql.core.query.Query;

public class ThreadLocalSQLManager
extends SQLManager {
    public static ThreadLocal<String> locals = ThreadLocal.withInitial(() -> null);
    Map<String, SQLManager> sqlManagerMap = new HashMap<String, SQLManager>();
    SQLManager defaultSqlManager;

    public ThreadLocalSQLManager(SQLManager defaultSqlManager, Map<String, SQLManager> sqlManagerMap, MapperBuilder mapperBuilder, ClassLoaderKit classLoaderKit) {
        this.defaultSqlManager = defaultSqlManager;
        this.sqlManagerMap = sqlManagerMap;
        this.setMapperBuilder(mapperBuilder);
        this.setClassLoaderKit(classLoaderKit);
    }

    protected SQLManager decide() {
        String current = locals.get();
        SQLManager sqlManager = this.sqlManagerMap.get(current);
        if (sqlManager == null) {
            return this.defaultSqlManager;
        }
        return sqlManager;
    }

    @Override
    public <T> Query<T> query(Class<T> clazz) {
        SQLManager sqlManager = this.decide();
        return new Query<T>(sqlManager, clazz);
    }

    @Override
    public <T> LambdaQuery<T> lambdaQuery(Class<T> clazz) {
        return super.lambdaQuery(clazz);
    }

    @Override
    public boolean isOffsetStartZero() {
        return this.decide().isOffsetStartZero();
    }

    @Override
    public boolean isProductMode() {
        return this.decide().isProductMode();
    }

    @Override
    public SQLResult getSQLResult(SqlId id, Object paras) {
        return this.decide().getSQLResult(id, paras);
    }

    @Override
    public SQLResult getSQLResult(SQLSource source, Object inputParas) {
        return this.decide().getSQLResult(source, inputParas);
    }

    @Override
    public SQLResult getSQLResult(SqlId id, Object paras, TemplateContext ctx) {
        return this.decide().getSQLResult(id, paras, ctx);
    }

    @Override
    public SQLExecutor getScript(SqlId sqlId) {
        return this.decide().getScript(sqlId);
    }

    @Override
    public boolean containSqlId(SqlId sqlId) {
        return this.decide().containSqlId(sqlId);
    }

    @Override
    public SQLErrorInfo validateSqlId(SqlId id) {
        return this.decide().validateSqlId(id);
    }

    @Override
    public SQLManager viewType(Class view) {
        return this.decide().viewType(view);
    }

    @Override
    public SQLManager resultSetMapper(Class resultSetMapperClass) {
        return this.decide().resultSetMapper(resultSetMapperClass);
    }

    @Override
    public SQLManager rowMapper(Class rowMapperClass) {
        return this.decide().rowMapper(rowMapperClass);
    }

    @Override
    public SQLExecutor getScript(Class<?> cls, AutoSQLEnum autoSQLEnum) {
        SQLManager sqlManager = this.decide();
        return sqlManager.getScript(cls, autoSQLEnum);
    }

    @Override
    public <T> List<T> select(SqlId sqlId, Class<T> clazz, Object paras) {
        SQLManager sqlManager = this.decide();
        return sqlManager.select(sqlId, clazz, paras);
    }

    @Override
    public <T> List<T> select(SqlId sqlId, Class<T> clazz) {
        SQLManager sqlManager = this.decide();
        return sqlManager.select(sqlId, clazz, null);
    }

    @Override
    public <T> PageResult<T> pageQuery(SqlId sqlId, Class<T> clazz, Object paras, PageRequest request) {
        SQLManager sqlManager = this.decide();
        return sqlManager.pageQuery(sqlId, clazz, paras, request);
    }

    @Override
    public <T> T unique(Class<T> clazz, Object pk) {
        SQLManager sqlManager = this.decide();
        return sqlManager.unique(clazz, pk);
    }

    @Override
    public <T> T single(Class<T> clazz, Object pk) {
        SQLManager sqlManager = this.decide();
        return sqlManager.single(clazz, pk);
    }

    @Override
    public <T> T lock(Class<T> clazz, Object pk) {
        SQLManager sqlManager = this.decide();
        return sqlManager.lock(clazz, pk);
    }

    @Override
    public <T> List<T> all(Class<T> clazz) {
        SQLManager sqlManager = this.decide();
        return sqlManager.all(clazz);
    }

    @Override
    public <T> List<T> all(Class<T> clazz, Object start, Long pageSize) {
        SQLManager sqlManager = this.decide();
        return sqlManager.all(clazz, start, pageSize);
    }

    @Override
    public long allCount(Class<?> clazz) {
        SQLManager sqlManager = this.decide();
        return sqlManager.allCount(clazz);
    }

    @Override
    public <T> T templateOne(T t) {
        SQLManager sqlManager = this.decide();
        return sqlManager.templateOne(t);
    }

    @Override
    public <T> List<T> template(T t) {
        SQLManager sqlManager = this.decide();
        return sqlManager.template(t);
    }

    @Override
    public <T> long templateCount(T t) {
        return this.templateCount(t.getClass(), t);
    }

    @Override
    public <T> long templateCount(Class<T> target, Object paras) {
        SQLManager sqlManager = this.decide();
        return sqlManager.templateCount(target, paras);
    }

    @Override
    public Long longValue(SqlId id, Object paras) {
        return this.decide().longValue(id, paras);
    }

    @Override
    public Integer intValue(SqlId id, Object paras) {
        return this.decide().selectSingle(id, paras, Integer.class);
    }

    @Override
    public BigDecimal bigDecimalValue(SqlId id, Object paras) {
        return this.decide().selectSingle(id, paras, BigDecimal.class);
    }

    @Override
    public <T> T selectSingle(SqlId sqlId, Object paras, Class<T> target) {
        SQLManager sqlManager = this.decide();
        return sqlManager.selectSingle(sqlId, paras, target);
    }

    @Override
    public <T> T selectUnique(SqlId id, Object paras, Class<T> target) {
        SQLManager sqlManager = this.decide();
        return sqlManager.selectUnique(id, paras, target);
    }

    public <T> List<T> select(SqlId sqlId, Object paras, Class<T> clazz, long start, long size) {
        SQLManager sqlManager = this.decide();
        return sqlManager.select(sqlId, paras, clazz, start, size);
    }

    @Override
    public int deleteById(Class<?> clazz, Object pkValue) {
        SQLManager sqlManager = this.decide();
        return sqlManager.deleteById(clazz, pkValue);
    }

    @Override
    public int deleteObject(Object obj) {
        SQLManager sqlManager = this.decide();
        return sqlManager.deleteObject(obj);
    }

    @Override
    public int insert(Object paras) {
        return this.insert(paras.getClass(), paras);
    }

    @Override
    public int insertTemplate(Object paras) {
        return this.insertTemplate(paras.getClass(), paras);
    }

    @Override
    public int insert(Class clazz, Object paras) {
        return this.generalInsert(clazz, paras, false);
    }

    @Override
    public int insertTemplate(Class clazz, Object paras) {
        return this.generalInsert(clazz, paras, true);
    }

    @Override
    public boolean exist(Class<?> clazz, Object pk) {
        SQLManager sqlManager = this.decide();
        return sqlManager.exist(clazz, pk);
    }

    @Override
    protected int generalInsert(Class clazz, Object paras, boolean template) {
        SQLManager sqlManager = this.decide();
        return sqlManager.generalInsert(clazz, paras, template);
    }

    @Override
    public int[] insertBatch(Class clazz, List<?> list) {
        SQLManager sqlManager = this.decide();
        return sqlManager.insertBatch(clazz, list);
    }

    @Override
    public int insert(SqlId sqlId, Object paras) {
        SQLManager sqlManager = this.decide();
        return sqlManager.insert(sqlId, paras);
    }

    @Override
    public List<Object[]> insert(SqlId sqlId, Object paras, String[] cols) {
        return this.decide().insert(sqlId, paras, cols);
    }

    @Override
    public boolean upsert(Object obj) {
        return this.upsert(obj, false);
    }

    @Override
    public boolean upsertByTemplate(Object obj) {
        return this.upsert(obj, true);
    }

    @Override
    protected boolean upsert(Object obj, boolean template) {
        SQLManager sqlManager = this.decide();
        return sqlManager.upsert(obj, template);
    }

    @Override
    public int updateById(Object obj) {
        SQLManager sqlManager = this.decide();
        return sqlManager.updateById(obj);
    }

    @Override
    public int updateTemplateById(Object obj) {
        SQLManager sqlManager = this.decide();
        return sqlManager.updateTemplateById(obj);
    }

    @Override
    public int updateTemplateById(Class c, Map paras) {
        SQLManager sqlManager = this.decide();
        return sqlManager.updateTemplateById(c, paras);
    }

    @Override
    public int updateTemplateById(Class c, Object obj) {
        SQLManager sqlManager = this.decide();
        return sqlManager.updateTemplateById(c, obj);
    }

    @Override
    public int[] updateByIdBatch(List<?> list) {
        if (list.isEmpty()) {
            return new int[0];
        }
        Object obj = list.get(0);
        SQLManager sqlManager = this.decide();
        return sqlManager.updateByIdBatch(list);
    }

    @Override
    public int update(SqlId sqlId, Object obj) {
        return this.decide().update(sqlId, obj);
    }

    @Override
    public int update(SqlId sqlId) {
        return this.decide().update(sqlId);
    }

    @Override
    public int update(SqlId sqlId, Map<String, Object> paras) {
        return this.decide().update(sqlId, paras);
    }

    @Override
    public int[] updateBatch(SqlId sqlId, List<?> list) {
        return this.decide().updateBatch(sqlId, list);
    }

    @Override
    public int[] updateBatchTemplateById(Class clz, List<?> list) {
        SQLManager sqlManager = this.decide();
        return sqlManager.updateBatchTemplateById(clz, list);
    }

    @Override
    public int updateAll(Class<?> clazz, Object param) {
        SQLManager sqlManager = this.decide();
        return sqlManager.updateAll(clazz, param);
    }

    @Override
    public <T> List<T> execute(String sqlTemplate, Class<T> clazz, Object paras) {
        SQLManager sqlManager = this.decide();
        return sqlManager.execute(sqlTemplate, clazz, paras);
    }

    @Override
    public TableDesc getTableDesc(String table) {
        throw new UnsupportedOperationException(table);
    }

    @Override
    public ClassDesc getClassDesc(Class target) {
        SQLManager sqlManager = this.decide();
        return sqlManager.getClassDesc(target);
    }

    public <T> List<T> execute(String sqlTemplate, Class<T> clazz, Object paras, long start, long size) {
        SQLManager sqlManager = this.decide();
        return sqlManager.execute(sqlTemplate, clazz, paras, start, size);
    }

    @Override
    public <T> PageResult<T> executePageQuery(String sqlTemplate, Class<T> clazz, Object paras, PageRequest<T> request) {
        SQLManager sqlManager = this.decide();
        return sqlManager.executePageQuery(sqlTemplate, clazz, paras, request);
    }

    @Override
    public int executeUpdate(String sqlTemplate, Object paras) {
        return this.decide().executeUpdate(sqlTemplate, paras);
    }

    @Override
    public <T> List<T> execute(SQLReady p, Class<T> clazz) {
        SQLManager sqlManager = this.decide();
        return sqlManager.execute(p, clazz);
    }

    @Override
    public <T> T executeQueryOne(SQLReady p, Class<T> clazz) {
        SQLManager sqlManager = this.decide();
        return sqlManager.executeQueryOne(p, clazz);
    }

    @Override
    public <T> PageResult<T> execute(SQLReady p, Class<T> clazz, PageRequest<T> pageRequest) {
        SQLManager sqlManager = this.decide();
        return sqlManager.execute(p, clazz, pageRequest);
    }

    @Override
    public int executeUpdate(SQLReady p) {
        return this.decide().executeUpdate(p);
    }

    @Override
    public int[] executeBatchUpdate(SQLBatchReady batch) {
        return this.decide().executeBatchUpdate(batch);
    }

    @Override
    public <T> T executeOnConnection(OnConnection<T> onConnection) {
        return this.decide().executeOnConnection(onConnection);
    }

    @Override
    public SQLLoader getSqlLoader() {
        return this.decide().getSqlLoader();
    }

    @Override
    public void setSqlLoader(SQLLoader sqlLoader) {
        this.decide().setSqlLoader(sqlLoader);
    }

    @Override
    public ConnectionSource getDs() {
        return this.decide().getDs();
    }

    @Override
    public void setDs(ConnectionSource ds) {
        this.decide().setDs(ds);
    }

    @Override
    public NameConversion getNc() {
        return this.decide().getNc();
    }

    @Override
    public void setNc(NameConversion nc) {
        this.decide().setNc(nc);
    }

    @Override
    public DBStyle getDbStyle() {
        return this.decide().getDbStyle();
    }

    @Override
    public SQLTemplateEngine getSqlTemplateEngine() {
        return this.decide().getSqlTemplateEngine();
    }

    @Override
    public MetadataManager getMetaDataManager() {
        return this.decide().getMetaDataManager();
    }

    @Override
    public Interceptor[] getInters() {
        return this.decide().getInters();
    }

    @Override
    public void setInters(Interceptor[] inters) {
        this.decide().setInters(inters);
    }

    @Override
    public void addIdAutoGen(String name, IDAutoGen alorithm) {
        this.decide().addIdAutoGen(name, alorithm);
    }

    @Override
    protected Object getAssignIdByIdAutoGen(String name, String param, String table) {
        return this.decide().getAssignIdByIdAutoGen(name, param, table);
    }

    @Override
    public Map<String, BeanProcessor> getProcessors() {
        return this.decide().getProcessors();
    }

    @Override
    public void setProcessors(Map<String, BeanProcessor> processors) {
        this.decide().setProcessors(processors);
    }

    @Override
    public BeanProcessor getDefaultBeanProcessors() {
        return this.decide().getDefaultBeanProcessors();
    }

    @Override
    public void setDefaultBeanProcessors(BeanProcessor defaultBeanProcessors) {
        this.decide().setDefaultBeanProcessors(defaultBeanProcessors);
    }

    @Override
    public <T> T getMapper(Class<T> mapperInterface) {
        return super.getMapper(mapperInterface);
    }

    @Override
    public ClassLoaderKit getClassLoaderKit() {
        return super.getClassLoaderKit();
    }

    @Override
    public void setClassLoaderKit(ClassLoaderKit classLoaderKit) {
        super.setClassLoaderKit(classLoaderKit);
    }

    @Override
    public void addVirtualTable(String realTable, String virtualTable) {
        this.decide().addVirtualTable(realTable, virtualTable);
    }

    @Override
    public void setDbStyle(DBStyle dbStyle) {
        this.decide().setDbStyle(dbStyle);
    }

    public void setMetaDataManager(SchemaMetadataManager metaDataManager) {
        this.decide().setMetaDataManager(metaDataManager);
    }

    @Override
    public SqlIdFactory getSqlIdFactory() {
        return this.decide().getSqlIdFactory();
    }

    @Override
    public void setSqlIdFactory(SqlIdFactory sqlIdFactory) {
        this.decide().setSqlIdFactory(sqlIdFactory);
    }

    @Override
    public String getCharset() {
        return this.decide().getCharset();
    }

    @Override
    public void setCharset(String charset) {
        this.decide().setCharset(charset);
    }

    @Override
    public boolean isProduct() {
        return this.decide().isProduct();
    }

    @Override
    public void setProduct(boolean product) {
        this.decide().setProduct(product);
    }

    @Override
    public void setSQLTemplateEngine(SQLTemplateEngine sqlTemplateEngine) {
        this.decide().setSQLTemplateEngine(sqlTemplateEngine);
    }
}

