/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core.concat;

import java.util.ArrayList;
import java.util.List;
import org.beetl.sql.core.concat.ConcatBuilder;
import org.beetl.sql.core.concat.ConcatContext;
import org.beetl.sql.core.concat.Express;
import org.beetl.sql.core.concat.LoopExpress;
import org.beetl.sql.core.concat.NotEmptyExpress;
import org.beetl.sql.core.concat.Output;
import org.beetl.sql.core.concat.WhereConditionExpress;
import org.beetl.sql.core.concat.WhereConstConditionExpress;
import org.beetl.sql.core.concat.WhereInExpress;

public class WhereNode
implements Output {
    ConcatContext ctx;
    List<Express> whereList = new ArrayList<Express>();

    public WhereNode(ConcatContext ctx) {
        this.ctx = ctx;
    }

    public WhereNode andEq(String name, String varName) {
        WhereConditionExpress node = new WhereConditionExpress();
        node.init("=", "and", name);
        node.tplValue(varName);
        this.whereList.add(node);
        return this;
    }

    public WhereNode andConstNotEq(String name, String value) {
        WhereConstConditionExpress node = new WhereConstConditionExpress();
        node.init("!=", "and", name);
        node.constValue(value);
        this.whereList.add(node);
        return this;
    }

    public WhereNode andIn(String name, String varName) {
        WhereInExpress node = new WhereInExpress(this);
        node.init("and", name);
        node.tplValue(varName);
        this.whereList.add(node);
        return this;
    }

    public WhereNode andIfNotEmpty(String name, String varName) {
        WhereConditionExpress node = new WhereConditionExpress();
        node.init("=", "and", name);
        node.tplValue(varName);
        NotEmptyExpress notEmptyExpress = new NotEmptyExpress(varName, node);
        this.whereList.add(notEmptyExpress);
        return this;
    }

    public LoopExpress loop(String collection, String varName) {
        LoopExpress loopExpress = new LoopExpress(collection, varName);
        this.whereList.add(loopExpress);
        return loopExpress;
    }

    @Override
    public void toSql(ConcatBuilder sb) {
        if (this.whereList.isEmpty()) {
            return;
        }
        sb.append("where 1=1");
        for (Express express : this.whereList) {
            express.toSql(sb);
        }
    }
}

