/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.beetl.sql.clazz.TableDesc;
import org.beetl.sql.clazz.kit.BeetlSQLException;
import org.beetl.sql.clazz.kit.KeyWordHandler;
import org.beetl.sql.core.SQLManager;
import org.beetl.sql.core.db.AbstractDBStyle;
import org.beetl.sql.core.query.GroupBy;
import org.beetl.sql.core.query.OrderBy;
import org.beetl.sql.core.query.Query;
import org.beetl.sql.core.query.interfacer.QueryConditionI;
import org.beetl.sql.core.query.interfacer.StrongValue;

public class QueryCondition<T>
implements QueryConditionI<T> {
    public static final String AND = "AND";
    public static final String OR = "OR";
    public static final String WHERE = "WHERE";
    public static final String IN = "IN";
    public static final String NOT_IN = "NOT IN";
    public static final String BETWEEN = "BETWEEN";
    public static final String NOT_BETWEEN = "NOT BETWEEN";
    public SQLManager sqlManager;
    protected StringBuilder sql = null;
    protected List<Object> params = new ArrayList<Object>();
    protected Object startRow = null;
    long pageSize = -1L;
    protected OrderBy orderBy = null;
    protected GroupBy groupBy = null;
    protected boolean distinct = false;
    protected String tableName;
    boolean asVirtual = false;

    protected QueryCondition() {
    }

    protected void clear() {
        this.sql = null;
        this.params = new ArrayList<Object>();
        this.startRow = null;
        this.pageSize = -1L;
        this.orderBy = null;
        this.groupBy = null;
    }

    protected String getCol(String colName) {
        return " " + this.getColTrunk(colName) + " ";
    }

    protected String getColTrunk(String colName) {
        KeyWordHandler keyWordHandler = this.sqlManager.getDbStyle().getKeyWordHandler();
        return keyWordHandler != null ? keyWordHandler.getCol(colName) : colName;
    }

    public String getTableName(Class<?> c) {
        if (this.tableName != null) {
            return this.tableName;
        }
        String tname = this.sqlManager.getNc().getTableName(c);
        if (this.asVirtual) {
            tname = this.sqlManager.getSqlTemplateEngine().runTemplate(tname, null);
        }
        TableDesc desc = this.sqlManager.getMetaDataManager().getTable(tname);
        String tableName2 = desc.getName();
        AbstractDBStyle style = (AbstractDBStyle)this.sqlManager.getDbStyle();
        tableName2 = style.getSQLTemplateEngine().wrapString(tableName2);
        if (desc.getSchema() != null) {
            return style.getKeyWordHandler().getTable(desc.getSchema()) + "." + style.getKeyWordHandler().getTable(tableName2);
        }
        return style.getKeyWordHandler().getTable(tableName2);
    }

    public Query<T> appendSql(String sqlPart) {
        if (this.sql == null) {
            this.sql = new StringBuilder();
        }
        this.sql.append(sqlPart);
        return (Query)this;
    }

    public Query<T> addParam(Collection<?> objects) {
        this.params.addAll(objects);
        return (Query)this;
    }

    public void addPreParam(List<Object> objects) {
        objects.addAll(this.params);
    }

    public Query<T> addParam(Object object) {
        this.params.add(object);
        return (Query)this;
    }

    protected void appendAndSql(String column, Object value, String opt) {
        this.appendSqlBase(column, value, opt, AND);
    }

    protected void appendOrSql(String column, Object value, String opt) {
        this.appendSqlBase(column, value, opt, OR);
    }

    protected void appendSqlBase(String column, Object value, String opt, String link) {
        if (value instanceof StrongValue) {
            if (!((StrongValue)value).isEffective()) {
                return;
            }
            value = ((StrongValue)value).getValue();
        } else if (value instanceof Optional) {
            if (!((Optional)value).isPresent()) {
                return;
            }
            value = ((Optional)value).get();
        }
        if (this.getSql().indexOf(WHERE) < 0) {
            link = WHERE;
        }
        this.appendSql(link).appendSql(this.getCol(column)).appendSql(opt);
        if (value != null) {
            this.appendSql(" ? ");
            this.addParam(value);
        }
    }

    protected boolean isValidateValue(Object value) {
        if (value instanceof StrongValue) {
            return !((StrongValue)value).isEffective();
        }
        if (value instanceof Optional) {
            return !((Optional)value).isPresent();
        }
        return true;
    }

    protected void appendInSql(String column, Object value, String opt, String link) {
        if (value instanceof StrongValue) {
            if (!((StrongValue)value).isEffective()) {
                return;
            }
            value = ((StrongValue)value).getValue();
        } else if (value instanceof Optional) {
            if (!((Optional)value).isPresent()) {
                return;
            }
            value = ((Optional)value).get();
        }
        if (!(value instanceof Collection)) {
            throw new IllegalArgumentException("\u671f\u671b\u53c2\u6570\u662fCollection\u5b50\u7c7b");
        }
        if (this.getSql().indexOf(WHERE) < 0) {
            link = WHERE;
        }
        this.appendSql(link).appendSql(this.getCol(column)).appendSql(opt).appendSql(" ( ");
        for (Object o : (Collection)value) {
            this.appendSql(" ? ,");
            this.addParam(o);
        }
        this.getSql().deleteCharAt(this.getSql().length() - 1);
        this.appendSql(" ) ");
    }

    protected void appendBetweenSql(String column, String opt, String link, Object ... value) {
        if (this.isValidateValue(value[0]) || this.isValidateValue(value[1])) {
            return;
        }
        if (this.getSql().indexOf(WHERE) < 0) {
            link = WHERE;
        }
        this.appendSql(link).appendSql(this.getCol(column)).appendSql(opt).appendSql(" ? AND ? ");
        this.addParam(value[0]);
        this.addParam(value[1]);
    }

    @Override
    public Query<T> andEq(String column, Object value) {
        this.appendAndSql(column, value, "=");
        return (Query)this;
    }

    @Override
    public Query<T> andNotEq(String column, Object value) {
        this.appendAndSql(column, value, "<>");
        return (Query)this;
    }

    @Override
    public Query<T> andGreat(String column, Object value) {
        this.appendAndSql(column, value, ">");
        return (Query)this;
    }

    @Override
    public Query<T> andGreatEq(String column, Object value) {
        this.appendAndSql(column, value, ">=");
        return (Query)this;
    }

    @Override
    public Query<T> andLess(String column, Object value) {
        this.appendAndSql(column, value, "<");
        return (Query)this;
    }

    @Override
    public Query<T> andLessEq(String column, Object value) {
        this.appendAndSql(column, value, "<=");
        return (Query)this;
    }

    @Override
    public Query<T> andLike(String column, Object value) {
        this.appendAndSql(column, value, "LIKE ");
        return (Query)this;
    }

    @Override
    public Query<T> andNotLike(String column, Object value) {
        this.appendAndSql(column, value, "NOT LIKE ");
        return (Query)this;
    }

    @Override
    public Query<T> andIsNull(String column) {
        this.appendAndSql(column, null, "IS NULL ");
        return (Query)this;
    }

    @Override
    public Query<T> andIsNotNull(String column) {
        this.appendAndSql(column, null, "IS NOT NULL ");
        return (Query)this;
    }

    @Override
    public Query<T> andIn(String column, Collection<?> value) {
        this.appendInSql(column, value, IN, AND);
        return (Query)this;
    }

    @Override
    public Query<T> andIn(String column, StrongValue value) {
        this.appendInSql(column, value, IN, AND);
        return (Query)this;
    }

    @Override
    public Query<T> andIn(String column, Optional value) {
        this.appendInSql(column, value, IN, AND);
        return (Query)this;
    }

    @Override
    public Query<T> andNotIn(String column, Collection<?> value) {
        this.appendInSql(column, value, NOT_IN, AND);
        return (Query)this;
    }

    @Override
    public Query<T> andNotIn(String column, StrongValue value) {
        this.appendInSql(column, value, NOT_IN, AND);
        return (Query)this;
    }

    @Override
    public Query<T> andNotIn(String column, Optional value) {
        this.appendInSql(column, value, NOT_IN, AND);
        return (Query)this;
    }

    @Override
    public Query<T> andBetween(String column, Object value1, Object value2) {
        this.appendBetweenSql(column, BETWEEN, AND, value1, value2);
        return (Query)this;
    }

    @Override
    public Query<T> andNotBetween(String column, Object value1, Object value2) {
        this.appendBetweenSql(column, NOT_BETWEEN, AND, value1, value2);
        return (Query)this;
    }

    @Override
    public Query<T> orEq(String column, Object value) {
        this.appendOrSql(column, value, "=");
        return (Query)this;
    }

    @Override
    public Query<T> orNotEq(String column, Object value) {
        this.appendOrSql(column, value, "<>");
        return (Query)this;
    }

    @Override
    public Query<T> orGreat(String column, Object value) {
        this.appendOrSql(column, value, ">");
        return (Query)this;
    }

    @Override
    public Query<T> orGreatEq(String column, Object value) {
        this.appendOrSql(column, value, ">=");
        return (Query)this;
    }

    @Override
    public Query<T> orLess(String column, Object value) {
        this.appendOrSql(column, value, "<");
        return (Query)this;
    }

    @Override
    public Query<T> orLessEq(String column, Object value) {
        this.appendOrSql(column, value, "<=");
        return (Query)this;
    }

    @Override
    public Query<T> orLike(String column, Object value) {
        this.appendOrSql(column, value, "LIKE ");
        return (Query)this;
    }

    @Override
    public Query<T> orNotLike(String column, Object value) {
        this.appendOrSql(column, value, "NOT LIKE ");
        return (Query)this;
    }

    @Override
    public Query<T> orIsNull(String column) {
        this.appendOrSql(column, null, "IS NULL ");
        return (Query)this;
    }

    @Override
    public Query<T> orIsNotNull(String column) {
        this.appendOrSql(column, null, "IS NOT NULL ");
        return (Query)this;
    }

    @Override
    public Query<T> orIn(String column, Collection<?> value) {
        this.appendInSql(column, value, IN, OR);
        return (Query)this;
    }

    @Override
    public Query<T> orIn(String column, StrongValue value) {
        this.appendInSql(column, value, IN, OR);
        return (Query)this;
    }

    @Override
    public Query<T> orIn(String column, Optional value) {
        this.appendInSql(column, value, IN, OR);
        return (Query)this;
    }

    @Override
    public Query<T> orNotIn(String column, Collection<?> value) {
        this.appendInSql(column, value, NOT_IN, OR);
        return (Query)this;
    }

    @Override
    public Query<T> orNotIn(String column, StrongValue value) {
        this.appendInSql(column, value, NOT_IN, OR);
        return (Query)this;
    }

    @Override
    public Query<T> orNotIn(String column, Optional value) {
        this.appendInSql(column, value, NOT_IN, OR);
        return (Query)this;
    }

    @Override
    public Query<T> orBetween(String column, Object value1, Object value2) {
        this.appendBetweenSql(column, BETWEEN, OR, value1, value2);
        return (Query)this;
    }

    @Override
    public Query<T> orNotBetween(String column, Object value1, Object value2) {
        this.appendBetweenSql(column, NOT_BETWEEN, OR, value1, value2);
        return (Query)this;
    }

    @Override
    public Query<T> and(QueryCondition condition) {
        return this.manyCondition(condition, AND);
    }

    @Override
    public Query<T> or(QueryCondition condition) {
        return this.manyCondition(condition, OR);
    }

    @Override
    public Query<T> asTable(String tableName) {
        this.tableName = tableName;
        return (Query)this;
    }

    @Override
    public Query<T> virtualTable() {
        this.asVirtual = true;
        return (Query)this;
    }

    private Query<T> manyCondition(QueryCondition condition, String link) {
        if (!(condition instanceof QueryCondition)) {
            throw new BeetlSQLException(20, "\u8fde\u63a5\u6761\u4ef6\u5fc5\u987b\u662f\u4e00\u4e2a QueryCondition \u7c7b\u578b");
        }
        if (condition.getSql() == null || "".equals(condition.getSql().toString())) {
            return (Query)this;
        }
        int i = condition.getSql().indexOf(WHERE);
        if (i > -1) {
            condition.getSql().delete(i, i + 5);
        }
        if (this.getSql().indexOf(WHERE) < 0) {
            link = WHERE;
        }
        this.appendSql(link).appendSql(" (").appendSql(condition.getSql().toString()).appendSql(")");
        this.addParam(condition.getParams());
        return (Query)this;
    }

    @Override
    public StringBuilder getSql() {
        if (this.sql == null) {
            return new StringBuilder();
        }
        return this.sql;
    }

    @Override
    public void setSql(StringBuilder sql) {
        this.sql = sql;
    }

    @Override
    public List<Object> getParams() {
        return this.params;
    }

    @Override
    public Query<T> distinct() {
        this.distinct = true;
        return (Query)this;
    }
}

