/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core.loader;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.beetl.sql.clazz.kit.BeetlSQLException;
import org.beetl.sql.core.SQLSource;
import org.beetl.sql.core.SqlId;
import org.beetl.sql.core.db.DBStyle;
import org.beetl.sql.core.loader.SQLLoader;

public abstract class AbstractSQLLoader
implements SQLLoader {
    protected DBStyle dbs = null;
    protected boolean product;
    protected Map<SqlId, SQLSource> autoGenSourceMap = new ConcurrentHashMap<SqlId, SQLSource>();

    public abstract SQLSource queryExternalSource(SqlId var1);

    public abstract boolean existExternalSource(SqlId var1);

    public abstract boolean isExternalSourceModified(SqlId var1);

    public abstract void removeExternalSource(SqlId var1);

    @Override
    public SQLSource querySQL(SqlId id) {
        SQLSource sqlSource = this.autoGenSourceMap.get(id);
        if (sqlSource != null) {
            return sqlSource;
        }
        sqlSource = this.queryExternalSource(id);
        return sqlSource;
    }

    @Override
    public SQLSource queryAutoSQL(SqlId id) {
        SQLSource sqlSource = this.autoGenSourceMap.get(id);
        return sqlSource;
    }

    @Override
    public boolean isModified(SqlId id) {
        if (this.isProduct()) {
            return false;
        }
        if (this.autoGenSourceMap.containsKey(id)) {
            return false;
        }
        boolean isModified = this.isExternalSourceModified(id);
        if (isModified) {
            this.removeExternalSource(id);
        }
        return isModified;
    }

    @Override
    public boolean exist(SqlId id) {
        if (this.autoGenSourceMap.containsKey(id)) {
            return true;
        }
        return this.existExternalSource(id);
    }

    @Override
    public DBStyle getDbStyle() {
        return this.dbs;
    }

    @Override
    public void setDbStyle(DBStyle dbs) {
        this.dbs = dbs;
    }

    @Override
    public void addSQL(SqlId id, SQLSource source) {
        this.autoGenSourceMap.put(id, source);
    }

    @Override
    public boolean isProduct() {
        return this.product;
    }

    @Override
    public void setProduct(boolean product) {
        this.product = product;
    }

    @Override
    public String getPathBySqlId(SqlId id) {
        return id.getNamespace().replace('.', '/');
    }

    @Override
    public void refresh() {
        this.autoGenSourceMap.clear();
    }

    @Override
    public BeetlSQLException getException(SqlId sqlId) {
        String path = this.getPathBySqlId(sqlId);
        String envInfo = path + ".md(sql) sqlLoader:" + this;
        envInfo = this.existNamespace(sqlId) ? envInfo + ",\u6587\u4ef6\u627e\u5230\uff0c\u4f46\u6ca1\u6709\u5bf9\u5e94\u7684sqlId" : envInfo + ",\u672a\u627e\u5230\u5bf9\u5e94\u7684sql\u6587\u4ef6";
        return new BeetlSQLException(2, "\u672a\u80fd\u627e\u5230" + sqlId + "\u5bf9\u5e94\u7684sql,\u641c\u7d22\u8def\u5f84:" + envInfo);
    }
}

