/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core.db;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.beetl.sql.annotation.builder.AttributeConvert;
import org.beetl.sql.annotation.entity.AssignID;
import org.beetl.sql.annotation.entity.AutoID;
import org.beetl.sql.annotation.entity.Seq;
import org.beetl.sql.annotation.entity.SeqID;
import org.beetl.sql.clazz.ClassAnnotation;
import org.beetl.sql.clazz.ClassDesc;
import org.beetl.sql.clazz.NameConversion;
import org.beetl.sql.clazz.SQLType;
import org.beetl.sql.clazz.TableDesc;
import org.beetl.sql.clazz.kit.AutoSQLEnum;
import org.beetl.sql.clazz.kit.BeanKit;
import org.beetl.sql.clazz.kit.BeetlSQLException;
import org.beetl.sql.clazz.kit.DefaultKeyWordHandler;
import org.beetl.sql.clazz.kit.KeyWordHandler;
import org.beetl.sql.core.BaseSQLExecutor;
import org.beetl.sql.core.BaseStatementOnlySQLExecutor;
import org.beetl.sql.core.ConnectionSource;
import org.beetl.sql.core.ExecuteContext;
import org.beetl.sql.core.SQLExecutor;
import org.beetl.sql.core.SQLManager;
import org.beetl.sql.core.SQLSource;
import org.beetl.sql.core.SQLTableSource;
import org.beetl.sql.core.concat.ConcatContext;
import org.beetl.sql.core.concat.Delete;
import org.beetl.sql.core.concat.Insert;
import org.beetl.sql.core.concat.LoopExpress;
import org.beetl.sql.core.concat.Select;
import org.beetl.sql.core.concat.Update;
import org.beetl.sql.core.concat.WhereNode;
import org.beetl.sql.core.db.DBStyle;
import org.beetl.sql.core.engine.template.SQLTemplateEngine;
import org.beetl.sql.core.meta.MetadataManager;
import org.beetl.sql.core.meta.SchemaMetadataManager;

public abstract class AbstractDBStyle
implements DBStyle {
    public boolean offsetStartZero = false;
    protected NameConversion nameConversion;
    protected MetadataManager metadataManager;
    protected String lineSeparator = System.getProperty("line.separator", "\n");
    protected KeyWordHandler keyWordHandler = new DefaultKeyWordHandler();
    SQLTemplateEngine sqlTemplateEngine = null;
    protected SQLManager sqlManager = null;
    public static AssignID DEFAULT_ASSIGNID = null;

    @Override
    public void init(SQLTemplateEngine sqlTemplateEngine, Properties ps) {
        this.sqlTemplateEngine = sqlTemplateEngine;
        this.offsetStartZero = Boolean.parseBoolean(ps.getProperty("OFFSET_START_ZERO", "false").trim());
    }

    @Override
    public NameConversion getNameConversion() {
        return this.nameConversion;
    }

    @Override
    public void setNameConversion(NameConversion nameConversion) {
        this.nameConversion = nameConversion;
    }

    @Override
    public SQLSource genSelectById(Class<?> cls, Class viewType) {
        ConcatContext concatContext = this.createConcatContext();
        Select select = concatContext.select();
        this.appendIdCondition(cls, select);
        this.appendLogicFlagCondition(cls, select);
        select.from(cls);
        if (viewType != null) {
            select.all(cls, viewType);
        } else {
            select.all();
        }
        return new SQLTableSource(select.toSql(), SQLType.SELECT);
    }

    @Override
    public SQLSource genSelectByIds(Class<?> cls, Class viewType) {
        ConcatContext concatContext = this.createConcatContext();
        Select select = concatContext.select();
        this.appendJoinInIdsCondition(cls, select);
        this.appendLogicFlagCondition(cls, select);
        select.from(cls);
        if (viewType != null) {
            select.all(cls, viewType);
        } else {
            select.all();
        }
        return new SQLTableSource(select.toSql(), SQLType.SELECT);
    }

    @Override
    public SQLSource genExistSql(Class<?> cls) {
        ConcatContext concatContext = this.createConcatContext();
        Select select = concatContext.select();
        select.count().from(cls);
        this.appendIdCondition(cls, select);
        this.appendLogicFlagCondition(cls, select);
        return new SQLTableSource(select.toSql(), SQLType.SELECT);
    }

    @Override
    public SQLSource genSelectByIdForUpdate(Class<?> cls, Class viewType) {
        SQLSource source = this.genSelectById(cls, viewType);
        String template = source.getTemplate();
        template = template + " for update";
        source.setTemplate(template);
        return source;
    }

    @Override
    public SQLSource genSelectByTemplate(Class<?> cls, Class viewType) {
        ConcatContext concatContext = this.createConcatContext();
        Select select = concatContext.select();
        if (viewType == null) {
            select.all().from(cls);
        } else {
            select.all(cls, viewType).from(cls);
        }
        this.appendLogicFlagCondition(cls, select);
        this.getSelectTemplate(cls, select);
        return new SQLTableSource(select.toSql(), SQLType.SELECT);
    }

    @Override
    public SQLSource genSelectCountByTemplate(Class<?> cls) {
        ConcatContext concatContext = this.createConcatContext();
        Select select = concatContext.select();
        this.appendLogicFlagCondition(cls, select);
        select.count().from(cls);
        this.getSelectTemplate(cls, select);
        return new SQLTableSource(select.toSql(), SQLType.SELECT);
    }

    @Override
    public SQLSource genDeleteById(Class<?> cls) {
        String tableName = this.nameConversion.getTableName(cls);
        TableDesc table = this.metadataManager.getTable(tableName);
        ClassDesc classDesc = table.genClassDesc(cls, this.nameConversion);
        ConcatContext concatContext = this.createConcatContext();
        if (classDesc.getClassAnnotation().getLogicDeleteAttrName() == null) {
            Delete delete = concatContext.delete().from(cls);
            this.appendIdCondition(cls, delete);
            return new SQLTableSource(delete.toSql(), SQLType.DELETE);
        }
        Update update = concatContext.update().from(cls);
        this.appendIdCondition(cls, update);
        String col = this.nameConversion.getColName(cls, classDesc.getClassAnnotation().getLogicDeleteAttrName());
        Integer value = classDesc.getClassAnnotation().getLogicDeleteAttrValue();
        update.assignConstants(col, value);
        return new SQLTableSource(update.toSql(), SQLType.DELETE);
    }

    @Override
    public SQLSource genSelectAll(Class<?> cls, Class viewType) {
        Select select = this.createConcatContext().select().from(cls);
        select.from(cls);
        if (viewType == null) {
            select.all();
        } else {
            select.all(cls, viewType);
        }
        this.appendLogicFlagCondition(cls, select);
        String sql = select.toSql();
        return new SQLTableSource(sql, SQLType.SELECT);
    }

    @Override
    public SQLSource genUpdateById(Class<?> cls) {
        String tableName = this.nameConversion.getTableName(cls);
        TableDesc table = this.metadataManager.getTable(tableName);
        ClassDesc classDesc = table.genClassDesc(cls, this.nameConversion);
        Update update = this.getUpdate(cls);
        this.appendIdCondition(cls, update);
        this.appendLogicFlagCondition(cls, update);
        this.appendVersion(classDesc, update);
        return new SQLTableSource(update.toSql(), SQLType.UPDATE);
    }

    @Override
    public SQLSource genUpdateRawById(Class<?> cls) {
        String tableName = this.nameConversion.getTableName(cls);
        TableDesc table = this.metadataManager.getTable(tableName);
        Update update = this.getRawUpdate(cls);
        this.appendIdCondition(cls, update);
        this.appendLogicFlagCondition(cls, update);
        return new SQLTableSource(update.toSql(), SQLType.UPDATE);
    }

    @Override
    public SQLSource genUpdateAbsolute(Class<?> cls) {
        Update update = this.getUpdate(cls);
        return new SQLTableSource(update.toSql(), SQLType.UPDATE);
    }

    @Override
    public SQLSource genUpdateTemplate(Class<?> cls) {
        String tableName = this.nameConversion.getTableName(cls);
        TableDesc table = this.metadataManager.getTable(tableName);
        ClassDesc classDesc = table.genClassDesc(cls, this.nameConversion);
        Update update = this.createConcatContext().update().from(cls);
        this.appendIdCondition(cls, update);
        this.appendLogicFlagCondition(cls, update);
        this.appendVersion(classDesc, update);
        Iterator<String> cols = classDesc.getInCols().iterator();
        Iterator<String> properties = classDesc.getAttrs().iterator();
        List<String> idCols = classDesc.getIdCols();
        Map<String, AttributeConvert> attributeConvertMap = classDesc.getClassAnnotation().getExtAnnotation().getAttributeConvertMap();
        while (cols.hasNext() && properties.hasNext()) {
            AttributeConvert attributeConvert;
            String real;
            String col = cols.next();
            String prop = properties.next();
            if (classDesc.getClassAnnotation().isUpdateIgnore(prop) || idCols.contains(col)) continue;
            if (prop.equals(classDesc.getClassAnnotation().getVersionProperty())) {
                update.assignVersion(col);
                continue;
            }
            if (attributeConvertMap.containsKey(prop) && (real = (attributeConvert = attributeConvertMap.get(prop)).toAutoSqlPart(this, cls, AutoSQLEnum.UPDATE_TEMPLATE_BY_ID, prop)) != null) {
                update.notEmptyAssign(prop, col, real);
                continue;
            }
            update.notEmptyAssign(prop, col);
        }
        return new SQLTableSource(update.toSql(), SQLType.UPDATE);
    }

    @Override
    public SQLSource genUpdateAll(Class<?> cls) {
        String tableName = this.nameConversion.getTableName(cls);
        TableDesc table = this.metadataManager.getTable(tableName);
        ClassDesc classDesc = table.genClassDesc(cls, this.nameConversion);
        Update update = this.createConcatContext().update().from(cls);
        Iterator<String> cols = classDesc.getInCols().iterator();
        Iterator<String> properties = classDesc.getAttrs().iterator();
        List<String> idCols = classDesc.getIdCols();
        while (cols.hasNext() && properties.hasNext()) {
            String col = cols.next();
            String prop = properties.next();
            if (classDesc.getClassAnnotation().isUpdateIgnore(prop) || idCols.contains(col)) continue;
            if (prop.equals(classDesc.getClassAnnotation().getVersionProperty())) {
                update.assignVersion(col);
                continue;
            }
            update.notEmptyAssign(prop, col);
        }
        this.appendLogicFlagCondition(cls, update);
        return new SQLTableSource(update.toSql(), SQLType.UPDATE);
    }

    @Override
    public SQLSource genInsert(Class<?> cls) {
        return this.generalInsert(cls, false);
    }

    @Override
    public SQLSource genInsertTemplate(Class<?> cls) {
        return this.generalInsert(cls, true);
    }

    protected SQLSource generalInsert(Class<?> cls, boolean template) {
        String tableName = this.nameConversion.getTableName(cls);
        TableDesc table = this.metadataManager.getTable(tableName);
        ClassDesc classDesc = table.genClassDesc(cls, this.nameConversion);
        Insert insert = this.createConcatContext().insert().into(cls);
        int idType = 1;
        SQLTableSource source = new SQLTableSource();
        source.setSqlType(SQLType.INSERT);
        Iterator<String> cols = classDesc.getInCols().iterator();
        Iterator<String> attrs = classDesc.getAttrs().iterator();
        List<String> idCols = classDesc.getIdCols();
        ClassAnnotation classAnnotation = classDesc.getClassAnnotation();
        Map<String, AttributeConvert> attributeConvertMap = classDesc.getClassAnnotation().getExtAnnotation().getAttributeConvertMap();
        while (cols.hasNext() && attrs.hasNext()) {
            String expressProp;
            AttributeConvert attributeConvert;
            String seqExpress;
            String col = cols.next();
            String attr = attrs.next();
            if (classAnnotation.isInsertIgnore(attr)) continue;
            if (classAnnotation.isAutoAttr(attr)) {
                insert.conditionalSet(col, attr);
                continue;
            }
            if (classAnnotation.isSeqAttr(attr)) {
                Seq seq = (Seq)BeanKit.getAnnotation((Class)classDesc.getTargetClass(), (String)attr, Seq.class);
                seqExpress = this.getSeqValue(seq.name());
                insert.conditionalSet(col, attr, seqExpress);
                continue;
            }
            if (attr.equals(classDesc.getClassAnnotation().getVersionProperty()) && classDesc.getClassAnnotation().getInitVersionValue() != -1) {
                insert.setConstant(col, classDesc.getClassAnnotation().getInitVersionValue() + "");
                continue;
            }
            if (idCols.contains(col)) {
                idType = this.getIdType(classDesc.getTargetClass(), attr);
                if (idType == 2) {
                    insert.conditionalSet(col, attr);
                    continue;
                }
                if (idType == 3) {
                    SeqID seqId = (SeqID)BeanKit.getAnnotation((Class)classDesc.getTargetClass(), (String)attr, (Method)((Method)classDesc.getIdMethods().get(attr)), SeqID.class);
                    seqExpress = this.getSeqValue(seqId.name());
                    insert.conditionalSet(col, attr, seqExpress);
                    continue;
                }
                if (idType == 1) {
                    // empty if block
                }
            }
            if (template) {
                String real;
                if (attributeConvertMap.containsKey(attr) && (real = (attributeConvert = attributeConvertMap.get(attr)).toAutoSqlPart(this, cls, AutoSQLEnum.INSERT_TEMPLATE, attr)) != null) {
                    insert.conditionalSetWIthReal(col, attr, real);
                    continue;
                }
                insert.conditionalSet(col, attr);
                continue;
            }
            if (attributeConvertMap.containsKey(attr) && (expressProp = (attributeConvert = attributeConvertMap.get(attr)).toAutoSqlPart(this, cls, AutoSQLEnum.INSERT, attr)) != null) {
                insert.set(col, expressProp);
                continue;
            }
            insert.set(col, attr);
        }
        source.setTemplate(insert.toSql());
        source.setIdType(idType);
        source.setTableDesc(table);
        if (idType == 1) {
            HashMap<String, AssignID> map = new HashMap<String, AssignID>();
            for (String idAttr : classDesc.getIdAttrs()) {
                AssignID assignId = (AssignID)BeanKit.getAnnotation((Class)classDesc.getTargetClass(), (String)idAttr, AssignID.class);
                if (assignId != null) {
                    map.put(idAttr, assignId);
                    continue;
                }
                map.put(idAttr, DEFAULT_ASSIGNID);
            }
            source.setAssignIds(map);
        }
        return source;
    }

    protected void getSelectTemplate(Class<?> cls, WhereNode whereNode) {
        String tableName = this.nameConversion.getTableName(cls);
        TableDesc table = this.metadataManager.getTable(tableName);
        ClassDesc classDesc = table.genClassDesc(cls, this.nameConversion);
        Iterator<String> cols = classDesc.getInCols().iterator();
        Iterator<String> attrs = classDesc.getAttrs().iterator();
        while (cols.hasNext() && attrs.hasNext()) {
            String col = cols.next();
            String attr = attrs.next();
            whereNode.andIfNotEmpty(col, attr);
        }
    }

    protected Update getUpdate(Class<?> cls) {
        String tableName = this.nameConversion.getTableName(cls);
        TableDesc table = this.metadataManager.getTable(tableName);
        ClassDesc classDesc = table.genClassDesc(cls, this.nameConversion);
        Update update = this.createConcatContext().update().from(cls);
        Iterator<String> cols = classDesc.getInCols().iterator();
        Iterator<String> properties = classDesc.getAttrs().iterator();
        List<String> idCols = classDesc.getIdCols();
        Map<String, AttributeConvert> attributeConvertMap = classDesc.getClassAnnotation().getExtAnnotation().getAttributeConvertMap();
        while (cols.hasNext() && properties.hasNext()) {
            AttributeConvert attributeConvert;
            String expressProp;
            String col = cols.next();
            String prop = properties.next();
            if (classDesc.getClassAnnotation().isUpdateIgnore(prop) || idCols.contains(col)) continue;
            if (prop.equals(classDesc.getClassAnnotation().getVersionProperty())) {
                update.assignVersion(col);
                continue;
            }
            if (attributeConvertMap.containsKey(prop) && (expressProp = (attributeConvert = attributeConvertMap.get(prop)).toAutoSqlPart(this, cls, AutoSQLEnum.UPDATE_BY_ID, prop)) != null) {
                update.assignConstants(col, expressProp);
                continue;
            }
            update.assign(col).tplValue(prop);
        }
        return update;
    }

    protected Update getRawUpdate(Class<?> cls) {
        String tableName = this.nameConversion.getTableName(cls);
        TableDesc table = this.metadataManager.getTable(tableName);
        ClassDesc classDesc = table.genClassDesc(cls, this.nameConversion);
        Update update = this.createConcatContext().update().from(cls);
        Iterator<String> cols = classDesc.getInCols().iterator();
        Iterator<String> properties = classDesc.getAttrs().iterator();
        List<String> idCols = classDesc.getIdCols();
        while (cols.hasNext() && properties.hasNext()) {
            String col = cols.next();
            String prop = properties.next();
            if (idCols.contains(col)) continue;
            update.assign(col).tplValue(prop);
        }
        return update;
    }

    protected void appendVersion(ClassDesc desc, WhereNode node) {
        String property = desc.getClassAnnotation().getVersionProperty();
        if (property == null) {
            return;
        }
        String col = this.nameConversion.getColName(desc.getTargetClass(), property);
        node.andEq(col, property);
    }

    protected void appendIdCondition(Class<?> cls, WhereNode node) {
        String tableName = this.nameConversion.getTableName(cls);
        TableDesc table = this.metadataManager.getTable(tableName);
        ClassDesc classDesc = table.genClassDesc(cls, this.nameConversion);
        List<String> colIds = classDesc.getIdCols();
        List<String> propertyIds = classDesc.getIdAttrs();
        this.checkId(colIds, propertyIds, cls.getName());
        Iterator<String> colIt = colIds.iterator();
        Iterator<String> propertyIt = propertyIds.iterator();
        if (colIt.hasNext() && propertyIt.hasNext()) {
            String colId = colIt.next();
            String properId = propertyIt.next();
            node.andEq(colId, properId);
            while (colIt.hasNext() && propertyIt.hasNext()) {
                colId = colIt.next();
                properId = propertyIt.next();
                node.andEq(colId, properId);
            }
        }
    }

    protected void appendLogicFlagCondition(Class<?> cls, WhereNode node) {
        if (!this.sqlManager.isQueryLogicDeleteEnable()) {
            return;
        }
        String tableName = this.nameConversion.getTableName(cls);
        TableDesc table = this.metadataManager.getTable(tableName);
        ClassDesc classDesc = table.genClassDesc(cls, this.nameConversion);
        if (classDesc.getClassAnnotation().getLogicDeleteAttrName() == null) {
            return;
        }
        String col = this.nameConversion.getColName(cls, classDesc.getClassAnnotation().getLogicDeleteAttrName());
        Integer value = classDesc.getClassAnnotation().getLogicDeleteAttrValue();
        node.andConstNotEq(col, String.valueOf(value));
    }

    protected void appendJoinInIdsCondition(Class<?> cls, WhereNode node) {
        String tableName = this.nameConversion.getTableName(cls);
        TableDesc table = this.metadataManager.getTable(tableName);
        ClassDesc classDesc = table.genClassDesc(cls, this.nameConversion);
        List<String> colIds = classDesc.getIdCols();
        if (colIds.size() == 1) {
            String colId = colIds.get(0);
            node.andIn(colId, "ids");
            return;
        }
        LoopExpress loopExpress = node.loop("ids", "id");
        List<String> attrIds = classDesc.getIdAttrs();
        for (int i = 0; i < colIds.size(); ++i) {
            String col = colIds.get(i);
            String attr = attrIds.get(i);
            loopExpress.addTpl(col, attr);
        }
    }

    protected void checkId(Collection colsId, Collection attrsId, String clsName) {
        if (colsId.size() == 0 || attrsId.size() == 0) {
            throw new BeetlSQLException(7, "\u4e3b\u952e\u672a\u53d1\u73b0," + clsName + ",\u68c0\u67e5\u6570\u636e\u5e93\u8868\u5b9a\u4e49\u6216\u8005NameConversion");
        }
    }

    public String getOrderBy() {
        return this.lineSeparator + this.appendExpress("text(has(_orderBy)?' order by '+_orderBy)") + " ";
    }

    public String appendExpress(String express) {
        return this.sqlTemplateEngine.appendVar(express);
    }

    @Override
    public int getIdType(Class c, String idProperty) {
        List ans = BeanKit.getAllAnnotation((Class)c, (String)idProperty);
        int idType = 2;
        for (Annotation an : ans) {
            if (an instanceof AutoID) {
                idType = 2;
                break;
            }
            if (an instanceof SeqID) {
                idType = 3;
                break;
            }
            if (!(an instanceof AssignID)) continue;
            idType = 1;
            break;
        }
        return idType;
    }

    @Override
    public KeyWordHandler getKeyWordHandler() {
        return this.keyWordHandler;
    }

    @Override
    public void setKeyWordHandler(KeyWordHandler keyWordHandler) {
        this.keyWordHandler = keyWordHandler;
    }

    @Override
    public String getSeqValue(String seqName) {
        throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u5e8f\u5217");
    }

    @Override
    public SQLExecutor buildExecutor(ExecuteContext executeContext) {
        BaseSQLExecutor sqlExecutor = null;
        sqlExecutor = this.preparedStatementSupport() ? new BaseSQLExecutor(executeContext) : new BaseStatementOnlySQLExecutor(executeContext);
        return sqlExecutor;
    }

    @Override
    public MetadataManager initMetadataManager(ConnectionSource cs) {
        this.metadataManager = new SchemaMetadataManager(cs, this);
        return this.metadataManager;
    }

    @Override
    public MetadataManager initMetadataManager(ConnectionSource cs, String defaultSchema, String defalutCatalog) {
        this.metadataManager = new SchemaMetadataManager(cs, defaultSchema, defalutCatalog, this);
        return this.metadataManager;
    }

    @Override
    public String wrapStatementValue(Object value) {
        if (this.preparedStatementSupport()) {
            throw new IllegalStateException("\u652f\u6301jdbc PreparedStatement\uff0c\u4f18\u5148\u4f7f\u7528PreparedStatement\u63d0\u9ad8\u6027\u80fd\uff0c\u4fdd\u8bc1\u5b89\u5168");
        }
        if (value == null) {
            return "null";
        }
        if (value instanceof String) {
            return "'" + value + "'";
        }
        if (value instanceof Number) {
            return value.toString();
        }
        if (value instanceof Timestamp) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
            String str = sdf.format((java.util.Date)value);
            return "parse_datetime('" + str + "',yyyy-MM-dd hh:mm:ss)";
        }
        if (value instanceof Date) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            String str = sdf.format((java.util.Date)value);
            return "parse_date('" + str + "',yyyy-MM-dd)";
        }
        if (value instanceof java.util.Date) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
            String str = sdf.format((java.util.Date)value);
            return "parse_datetime('" + str + "',yyyy-MM-dd hh:mm:ss)";
        }
        if (value instanceof Boolean) {
            return ((Boolean)value).toString();
        }
        throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7c7b\u578b " + value.getClass() + "," + value);
    }

    protected ConcatContext createConcatContext() {
        ConcatContext concatContext = ConcatContext.createTemplateContext(this.nameConversion, (KeyWordHandler)(this.keyWordHandler != null ? this.getKeyWordHandler() : new DefaultKeyWordHandler()), this.sqlTemplateEngine);
        return concatContext;
    }

    public boolean isOffsetStartZero() {
        return this.offsetStartZero;
    }

    @Override
    public void setOffsetStartZero(boolean offsetStartZero) {
        this.offsetStartZero = offsetStartZero;
    }

    @Override
    public String getDefaultSchema() {
        return null;
    }

    @Override
    public SQLTemplateEngine getSQLTemplateEngine() {
        return this.sqlTemplateEngine;
    }

    @Override
    public void config(SQLManager sqlManager) {
        this.sqlManager = sqlManager;
    }

    static {
        DEFAULT_ASSIGNID = (AssignID)BeanKit.getAnnotation(MockXXX.class, (String)"id", AssignID.class);
    }

    public static class MockXXX {
        @AssignID
        String id;

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MockXXX)) {
                return false;
            }
            MockXXX other = (MockXXX)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            return !(this$id == null ? other$id != null : !this$id.equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MockXXX;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            return result;
        }

        public String toString() {
            return "AbstractDBStyle.MockXXX(id=" + this.getId() + ")";
        }
    }
}

