/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core.concat;

import java.util.ArrayList;
import java.util.List;
import org.beetl.sql.core.concat.AutoCommaAppend;
import org.beetl.sql.core.concat.ConcatBuilder;
import org.beetl.sql.core.concat.Express;
import org.beetl.sql.core.concat.Insert;
import org.beetl.sql.core.concat.Output;
import org.beetl.sql.core.concat.TrimSupport;

public class InsertValueNode
extends TrimSupport
implements Output {
    static ValueHolderExpress holderExpress = new ValueHolderExpress();
    List<Express> list = new ArrayList<Express>();
    Insert insert;

    public InsertValueNode(Insert insert) {
        this.insert = insert;
    }

    public void add(String varName) {
        ValueExpress valueExpress = new ValueExpress(this, varName);
        this.list.add(valueExpress);
    }

    public void addConstants(String sql) {
        ConstantExpress constantExpress = new ConstantExpress(this, sql);
        this.list.add(constantExpress);
    }

    public InsertValueNode conditional(String varName) {
        InsertValueEmptyExpress valueExpress = new InsertValueEmptyExpress(varName);
        this.list.add(valueExpress);
        this.trim = true;
        return this;
    }

    public InsertValueNode conditionalWithReal(String varName, String real) {
        InsertValueEmptyExpress valueExpress = new InsertValueEmptyExpress(varName, real);
        this.list.add(valueExpress);
        this.trim = true;
        return this;
    }

    public InsertValueNode conditional(String varName, String defaultValue) {
        InsertDefaultValueEmptyExpress valueExpress = new InsertDefaultValueEmptyExpress(varName, defaultValue);
        this.list.add(valueExpress);
        this.trim = true;
        return this;
    }

    @Override
    public void toSql(ConcatBuilder sb) {
        if (this.trim) {
            sb.appendTrimStart();
            for (int i = 0; i < this.list.size(); ++i) {
                Express express = this.list.get(i);
                if (i != 0 && !(express instanceof AutoCommaAppend)) {
                    sb.comma();
                }
                express.toSql(sb);
            }
            sb.appendTrimEnd();
        } else {
            for (int i = 0; i < this.list.size(); ++i) {
                Express express = this.list.get(i);
                if (i != 0 && !(express instanceof AutoCommaAppend)) {
                    sb.comma();
                }
                express.toSql(sb);
            }
        }
    }

    public static class InsertDefaultValueEmptyExpress
    extends Express {
        String varName;
        String defaultValue;

        public InsertDefaultValueEmptyExpress(String varName, String defaultValue) {
            this.varName = varName;
            this.defaultValue = defaultValue;
        }

        @Override
        public void toSql(ConcatBuilder sb) {
            sb.testVarOrDefault(this.varName, this.defaultValue);
        }
    }

    public static class InsertValueEmptyExpress
    extends Express
    implements AutoCommaAppend {
        String varName;
        String real;

        public InsertValueEmptyExpress(String varName) {
            this.varName = varName;
        }

        public InsertValueEmptyExpress(String varName, String real) {
            this.varName = varName;
            this.real = real;
        }

        @Override
        public void toSql(ConcatBuilder sb) {
            if (this.real != null) {
                sb.testRealVar(this.varName, this.real);
            } else {
                sb.testVar(this.varName);
            }
        }
    }

    static class ValueHolderExpress
    extends Express {
        ValueHolderExpress() {
        }

        @Override
        public void toSql(ConcatBuilder sb) {
            sb.valueHolder();
        }
    }

    static class ConstantExpress
    extends Express {
        String sql;
        InsertValueNode node;

        public ConstantExpress(InsertValueNode node, String sql) {
            this.node = node;
            this.sql = sql;
        }

        @Override
        public void toSql(ConcatBuilder sb) {
            sb.append(this.sql);
        }
    }

    static class ValueExpress
    extends Express {
        String varName;
        InsertValueNode node;

        public ValueExpress(InsertValueNode node, String varName) {
            this.varName = varName;
            this.node = node;
        }

        @Override
        public void toSql(ConcatBuilder sb) {
            sb.appendVar(this.varName);
        }
    }
}

