/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core.concat;

import org.beetl.sql.core.concat.ConcatBuilder;
import org.beetl.sql.core.concat.ConcatContext;
import org.beetl.sql.core.concat.InsertColNode;
import org.beetl.sql.core.concat.InsertValueNode;
import org.beetl.sql.core.concat.Output;

public class Insert
implements Output {
    String mainTable;
    InsertColNode colNode;
    InsertValueNode valueNode;
    ConcatContext ctx;
    boolean trim = false;

    public Insert(ConcatContext ctx) {
        this.ctx = ctx;
        this.colNode = new InsertColNode(this);
        this.valueNode = new InsertValueNode(this);
    }

    public Insert into(Class clazz) {
        this.mainTable = this.ctx.keyWordHandler.getTable(this.ctx.nc.getTableName(clazz));
        return this;
    }

    public Insert set(String col, String varName) {
        this.colNode.add(col);
        this.valueNode.add(varName);
        return this;
    }

    public Insert setConstant(String col, String sql) {
        this.colNode.addConstants(col);
        this.valueNode.addConstants(sql);
        return this;
    }

    public Insert conditionalSet(String col, String varName) {
        this.colNode.conditional(col, varName);
        this.valueNode.conditional(varName);
        return this;
    }

    public Insert conditionalSetWIthReal(String col, String varName, String realVar) {
        this.colNode.conditional(col, varName);
        this.valueNode.conditionalWithReal(varName, realVar);
        return this;
    }

    public Insert conditionalSet(String col, String varName, String defaultValue) {
        this.colNode.add(col);
        this.valueNode.conditional(varName, defaultValue);
        return this;
    }

    public String toSql() {
        ConcatBuilder sb = new ConcatBuilder(this.ctx);
        this.toSql(sb);
        return sb.toString();
    }

    @Override
    public void toSql(ConcatBuilder sb) {
        sb.append("insert into");
        sb.append(this.mainTable);
        sb.leftBracket();
        this.colNode.toSql(sb);
        sb.rightBracket().append(" values").leftBracket();
        this.valueNode.toSql(sb);
        sb.rightBracket();
    }
}

