/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.beetl.core.resource.StringTemplateResourceLoader;
import org.beetl.sql.clazz.ColDesc;
import org.beetl.sql.clazz.TableDesc;
import org.beetl.sql.clazz.kit.AutoSQLEnum;
import org.beetl.sql.clazz.kit.BeanKit;
import org.beetl.sql.clazz.kit.BeetlSQLException;
import org.beetl.sql.clazz.kit.CaseInsensitiveHashMap;
import org.beetl.sql.clazz.kit.JavaType;
import org.beetl.sql.core.SQLManager;
import org.beetl.sql.core.SQLReady;
import org.beetl.sql.core.SQLResult;
import org.beetl.sql.core.SQLSource;
import org.beetl.sql.core.SqlId;
import org.beetl.sql.core.engine.SQLParameter;
import org.beetl.sql.core.page.DefaultPageRequest;
import org.beetl.sql.core.page.PageRequest;
import org.beetl.sql.core.page.PageResult;
import org.beetl.sql.core.query.GroupBy;
import org.beetl.sql.core.query.LambdaQuery;
import org.beetl.sql.core.query.OrderBy;
import org.beetl.sql.core.query.QueryCondition;
import org.beetl.sql.core.query.interfacer.QueryExecuteI;
import org.beetl.sql.core.query.interfacer.QueryOtherI;
import org.beetl.sql.core.query.interfacer.StrongValue;

public class Query<T>
extends QueryCondition<T>
implements QueryExecuteI<T>,
QueryOtherI<Query> {
    private static final String ALL_COLUMNS = "*";
    Class<T> clazz;
    StringTemplateResourceLoader tempLoader = new StringTemplateResourceLoader();

    public Query(SQLManager sqlManager, Class<T> clazz) {
        this.sqlManager = sqlManager;
        this.clazz = clazz;
    }

    public Query<T> condition() {
        return new Query<T>(this.sqlManager, this.clazz);
    }

    @Deprecated
    public LambdaQuery<T> lambda() {
        if (BeanKit.queryLambdasSupport) {
            if (this.sql != null || this.groupBy != null || this.orderBy != null) {
                throw new UnsupportedOperationException("LambdaQuery\u5fc5\u987b\u5728\u8c03\u7528\u5176\u4ed6AP\u524d\u83b7\u53d6");
            }
            return new LambdaQuery(this.sqlManager, (Class)this.clazz);
        }
        throw new UnsupportedOperationException("\u9700\u8981\u4f7f\u7528Java8\u4ee5\u4e0a");
    }

    @Override
    public List<T> select(String ... columns) {
        return this.selectByType(this.clazz, columns);
    }

    @Override
    public List<T> select() {
        return this.selectByType(this.clazz, new String[0]);
    }

    @Override
    public List<T> selectSimple() {
        return this.selectByType(this.clazz, this.getSimpleColumns());
    }

    @Override
    public T single(String ... columns) {
        List<T> list = ((Query)this.limit(this.getFirstRowNumber(), 1L)).select(columns);
        if (list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    @Override
    public Map mapSingle(String ... columns) {
        List<Map> list = ((Query)this.limit(this.getFirstRowNumber(), 1L)).selectByType(Map.class, columns);
        if (list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    @Override
    public T singleSimple() {
        return this.single(this.getSimpleColumns());
    }

    @Override
    public T uniqueSimple() {
        return this.unique(this.getSimpleColumns());
    }

    @Override
    public T unique(String ... cols) {
        List<T> list = ((Query)this.limit(this.getFirstRowNumber(), 2L)).select(cols);
        if (list.isEmpty()) {
            throw new BeetlSQLException(12, "unique\u67e5\u8be2\uff0c\u4f46\u6570\u636e\u5e93\u672a\u627e\u5230\u7ed3\u679c\u96c6");
        }
        if (list.size() != 1) {
            throw new BeetlSQLException(12, "unique\u67e5\u8be2\uff0c\u67e5\u8be2\u51fa\u591a\u6761\u7ed3\u679c\u96c6");
        }
        return list.get(0);
    }

    private int getFirstRowNumber() {
        return this.sqlManager.isOffsetStartZero() ? 0 : 1;
    }

    @Override
    public <K> List<K> select(Class<K> retType, String ... columns) {
        return this.selectByType(retType, columns);
    }

    @Override
    public List<Map> mapSelect(String ... columns) {
        return this.selectByType(Map.class, columns);
    }

    protected <K> List<K> selectByType(Class<K> retType, String ... columns) {
        String column = this.splicingColumns(columns);
        if (this.distinct) {
            column = " DISTINCT " + column;
        }
        StringBuilder sql = this.assembleSelectSql(column);
        String targetSql = sql.toString();
        Object[] paras = this.getParams().toArray();
        List<K> list = this.sqlManager.execute(new SQLReady(targetSql, paras), retType);
        this.clear();
        return list;
    }

    private StringBuilder assembleSelectSql(String column) {
        StringBuilder sb = new StringBuilder("SELECT ").append(column);
        sb.append(" FROM ").append(this.getTableName(this.clazz)).append(' ').append((CharSequence)this.getSql());
        sb = this.addAdditionalPartSql(sb);
        return sb;
    }

    private StringBuilder addAdditionalPartSql(StringBuilder sql) {
        this.addGroupAndOrderPartSql(sql);
        if (this.startRow != null) {
            sql = new StringBuilder(this.sqlManager.getDbStyle().getRangeSql().toRange(sql.toString(), this.startRow, this.pageSize));
        }
        return sql;
    }

    private void addGroupAndOrderPartSql(StringBuilder sql) {
        if (this.orderBy != null && this.groupBy != null) {
            sql.append(this.groupBy.getGroupBy()).append(' ');
            sql.append(this.orderBy.getOrderBy()).append(' ');
        } else if (this.orderBy != null) {
            sql.append(this.orderBy.getOrderBy()).append(' ');
        } else if (this.groupBy != null) {
            sql.append(this.groupBy.getGroupBy()).append(' ');
        }
    }

    @Override
    public int update(Object t) {
        SqlId id = this.sqlManager.getSqlIdFactory().buildIdentity(this.clazz, AutoSQLEnum.UPDATE_ALL);
        SQLSource sqlSource = this.sqlManager.getSqlLoader().queryAutoSQL(id);
        if (sqlSource == null) {
            sqlSource = this.sqlManager.getDbStyle().genUpdateAbsolute(this.clazz);
            this.sqlManager.getSqlLoader().addSQL(id, sqlSource);
            sqlSource.setId(id);
        }
        return this.handlerUpdateSql(t, sqlSource);
    }

    @Override
    public int updateSelective(Object t) {
        SqlId id = this.sqlManager.getSqlIdFactory().buildIdentity(this.clazz, AutoSQLEnum.UPDATE_ALL);
        SQLSource sqlSource = this.sqlManager.getSqlLoader().queryAutoSQL(id);
        if (sqlSource == null) {
            sqlSource = this.sqlManager.getDbStyle().genUpdateAll(this.clazz);
            this.sqlManager.getSqlLoader().addSQL(id, sqlSource);
            sqlSource.setId(id);
        }
        return this.handlerUpdateSql(t, sqlSource);
    }

    private int handlerUpdateSql(Object t, SQLSource sqlSource) {
        if (this.sql == null || this.sql.length() == 0) {
            throw new BeetlSQLException(20, "update\u64cd\u4f5c\u6ca1\u6709\u8f93\u5165\u8fc7\u6ee4\u6761\u4ef6\u4f1a\u5bfc\u81f4\u66f4\u65b0\u6240\u6709\u8bb0\u5f55");
        }
        SQLResult result = this.sqlManager.getSQLResult(sqlSource.getId(), t, true);
        ArrayList<Object> paraLis = new ArrayList<Object>();
        for (SQLParameter sqlParameter : result.jdbcPara) {
            paraLis.add(sqlParameter.value);
        }
        this.addPreParam(paraLis);
        String targetSql = result.jdbcSql + " " + this.getSql();
        Object[] paras = paraLis.toArray();
        int row = this.sqlManager.executeUpdate(new SQLReady(targetSql, paras));
        this.clear();
        return row;
    }

    @Override
    public int insert(T t) {
        return this.sqlManager.insert(t);
    }

    @Override
    public int insertSelective(T t) {
        return this.sqlManager.insertTemplate(t);
    }

    @Override
    public int delete() {
        String targetSql = "DELETE FROM " + this.getTableName(this.clazz) + " " + this.getSql();
        Object[] paras = this.getParams().toArray();
        int row = this.sqlManager.executeUpdate(new SQLReady(targetSql, paras));
        this.clear();
        return row;
    }

    @Override
    public long count() {
        String targetSql = "SELECT COUNT(1) FROM " + this.getTableName(this.clazz) + " " + this.getSql();
        Object[] paras = this.getParams().toArray();
        List<Long> results = this.sqlManager.execute(new SQLReady(targetSql, paras), Long.class);
        this.clear();
        return results.get(0);
    }

    @Override
    public PageResult<T> pageSimple(PageRequest pageRequest) {
        return this.pageByType(pageRequest, this.clazz, this.getSimpleColumns());
    }

    @Override
    public Query<T> having(QueryCondition condition) {
        int i = condition.getSql().indexOf("WHERE");
        if (i > -1) {
            condition.getSql().delete(i, i + 5);
        }
        if (this.groupBy == null) {
            throw new BeetlSQLException(21, this.getSqlErrorTip("having \u9700\u8981\u5728groupBy\u540e\u8c03\u7528"));
        }
        this.groupBy.addHaving(condition.getSql().toString());
        this.addParam(condition.getParams());
        return this;
    }

    @Override
    public Query<T> groupBy(String column) {
        GroupBy groupBy = this.getGroupBy();
        groupBy.add(this.getCol(column));
        return this;
    }

    @Override
    public Query<T> orderBy(String orderBy) {
        OrderBy orderByInfo = this.getOrderBy();
        orderByInfo.add(orderBy);
        return this;
    }

    @Override
    public Query<T> asc(String column) {
        OrderBy orderByInfo = this.getOrderBy();
        orderByInfo.add(this.getCol(column) + " ASC");
        return this;
    }

    @Override
    public Query<T> desc(String column) {
        OrderBy orderByInfo = this.getOrderBy();
        orderByInfo.add(this.getCol(column) + " DESC");
        return this;
    }

    private OrderBy getOrderBy() {
        if (this.orderBy == null) {
            this.orderBy = new OrderBy();
        }
        return this.orderBy;
    }

    private GroupBy getGroupBy() {
        if (this.groupBy == null) {
            this.groupBy = new GroupBy();
        }
        return this.groupBy;
    }

    @Override
    public Query<T> limit(Object startRow, long pageSize) {
        this.startRow = startRow;
        this.pageSize = pageSize;
        return this;
    }

    protected <K> PageResult<K> pageByType(PageRequest pageRequest, Class<K> retType, String ... columns) {
        String columnStr = this.splicingColumns(columns);
        this.startRow = null;
        StringBuilder sql = this.assembleSelectSql(columnStr);
        if (this.groupBy != null) {
            sql = new StringBuilder("SELECT * FROM (").append((CharSequence)sql).append(") t");
        }
        String targetSql = sql.toString();
        Object[] paras = this.getParams().toArray();
        SQLReady sqlReady = new SQLReady(targetSql, paras);
        this.clear();
        return this.sqlManager.execute(sqlReady, retType, pageRequest);
    }

    @Override
    public PageResult<T> page(PageRequest pageRequest, String ... columns) {
        return this.pageByType(pageRequest, this.clazz, columns);
    }

    @Override
    public <K> PageResult<K> page(PageRequest pageRequest, Class<K> retType, String ... columns) {
        return this.pageByType(pageRequest, retType, columns);
    }

    @Override
    public PageResult<Map> mapPage(PageRequest pageRequest, String ... columns) {
        return this.pageByType(pageRequest, Map.class, columns);
    }

    @Override
    public PageResult<T> page(long pageNumber, long pageSize, String ... columns) {
        PageRequest pageRequest = DefaultPageRequest.of(pageNumber, (int)pageSize);
        return this.pageByType(pageRequest, this.clazz, columns);
    }

    @Override
    public PageResult<T> pageSimple(long pageNumber, long pageSize) {
        return this.page(pageNumber, pageSize, this.getSimpleColumns());
    }

    @Override
    public <K> PageResult<K> page(long pageNumber, long pageSize, Class<K> retType, String ... columns) {
        PageRequest pageRequest = DefaultPageRequest.of(pageNumber, (int)pageSize);
        return this.pageByType(pageRequest, retType, columns);
    }

    @Override
    public PageResult<Map> mapPage(long pageNumber, long pageSize, String ... columns) {
        PageRequest pageRequest = DefaultPageRequest.of(pageNumber, (int)pageSize);
        return this.pageByType(pageRequest, Map.class, columns);
    }

    private String getSqlErrorTip(String cause) {
        return String.format("\n\u250f\u2501\u2501\u2501\u2501\u2501 SQL\u8bed\u6cd5\u9519\u8bef:\n\u2523SQL\uff1a%s\n\u2523\u539f\u56e0\uff1a%s\n\u2523\u89e3\u51b3\u529e\u6cd5\uff1a\u60a8\u53ef\u80fd\u9700\u8981\u91cd\u65b0\u83b7\u53d6\u4e00\u4e2aQuery\n\u2517\u2501\u2501\u2501\u2501\u2501\n", this.getSql().toString(), cause);
    }

    private String getSqlErrorTip(String cause, String solve) {
        return String.format("\n\u250f\u2501\u2501\u2501\u2501\u2501 SQL\u8bed\u6cd5\u9519\u8bef:\n\u2523SQL\uff1a%s\n\u2523\u539f\u56e0\uff1a%s\n\u2523\u89e3\u51b3\u529e\u6cd5\uff1a" + solve + "\n\u2517\u2501\u2501\u2501\u2501\u2501\n", this.getSql().toString(), cause);
    }

    private String[] getSimpleColumns() {
        String tname = this.sqlManager.getNc().getTableName(this.clazz);
        TableDesc desc = this.sqlManager.getMetaDataManager().getTable(tname);
        CaseInsensitiveHashMap<String, ColDesc> colMap = desc.getColsDetail();
        ArrayList cols = new ArrayList(colMap.size());
        for (Map.Entry entry : colMap.entrySet()) {
            int sqlType = ((ColDesc)entry.getValue()).getSqlType();
            if (JavaType.isBigType((int)sqlType)) continue;
            cols.add(entry.getKey());
        }
        String[] columns = new String[cols.size()];
        cols.toArray(columns);
        return columns;
    }

    private String splicingColumns(String[] columns) {
        if (columns == null || columns.length < 1) {
            return ALL_COLUMNS;
        }
        StringBuilder columnStr = new StringBuilder();
        for (String column : columns) {
            columnStr.append(this.getColTrunk(column)).append(',');
        }
        columnStr.deleteCharAt(columnStr.length() - 1);
        return columnStr.toString();
    }

    public static StrongValue filterEmpty(final Object value) {
        return new StrongValue(){

            @Override
            public boolean isEffective() {
                if (value == null) {
                    return false;
                }
                if (value instanceof String) {
                    return !"".equals(value);
                }
                if (value instanceof Collection) {
                    return !((Collection)value).isEmpty();
                }
                return true;
            }

            @Override
            public Object getValue() {
                return value;
            }
        };
    }

    public static StrongValue filterNull(final Object value) {
        return new StrongValue(){

            @Override
            public boolean isEffective() {
                return value != null;
            }

            @Override
            public Object getValue() {
                return value;
            }
        };
    }

    @Override
    public Query<T> useCondition(QueryCondition condition) {
        this.sql = new StringBuilder(condition.sql);
        this.params = new ArrayList<Object>(condition.params);
        this.startRow = condition.startRow;
        this.pageSize = condition.pageSize;
        this.orderBy = new OrderBy(condition.orderBy.sb.toString());
        this.groupBy = new GroupBy(condition.groupBy.sb.toString());
        return this;
    }
}

