/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core.db;

import java.util.ArrayList;
import java.util.Map;
import org.beetl.sql.clazz.ClassAnnotation;
import org.beetl.sql.clazz.kit.BeanKit;

public class KeyHolder {
    String[] attrNames = null;
    Object[] values = null;
    public static KeyHolder empty = new KeyHolder(new String[0]);

    protected KeyHolder() {
    }

    public KeyHolder(String[] attrNames) {
        this.attrNames = attrNames;
    }

    public KeyHolder(String attrName) {
        this.attrNames = new String[]{attrName};
    }

    public int getInt(String attrName) {
        int index = this.findIndex(attrName);
        return ((Number)this.values[index]).intValue();
    }

    public static KeyHolder getKeyHolderByClass(Object obj) {
        if (obj instanceof Map) {
            return empty;
        }
        Class<?> c = obj.getClass();
        ClassAnnotation annotation = ClassAnnotation.getClassAnnotation(c);
        String[] attrs = annotation.getInsertAutoAttrs();
        if (attrs.length == 0) {
            return empty;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (String attr : attrs) {
            Object o = BeanKit.getBeanProperty((Object)obj, (String)attr);
            if (o != null) continue;
            list.add(attr);
        }
        return attrs.length == list.size() ? new KeyHolder(attrs) : new KeyHolder(list.toArray(new String[0]));
    }

    public Long getLong(String attrName) {
        int index = this.findIndex(attrName);
        return this.values[index] == null ? null : Long.valueOf(((Number)this.values[index]).longValue());
    }

    public String getString(String attrName) {
        int index = this.findIndex(attrName);
        return this.values[index] == null ? null : this.values[index].toString();
    }

    public Object getObject(String attrName) {
        int index = this.findIndex(attrName);
        return this.values[index] == null ? null : this.values[index];
    }

    private int findIndex(String attrName) {
        if (this.attrNames.length == 1 && this.attrNames[0].equals(attrName)) {
            return 0;
        }
        for (int i = 0; i < this.attrNames.length; ++i) {
            if (!attrName.equalsIgnoreCase(this.attrNames[i])) continue;
            return i;
        }
        throw new IllegalArgumentException("\u672a\u627e\u5230\u5c5e\u6027" + attrName);
    }

    public boolean hasAttr() {
        return this.attrNames != null && this.attrNames.length != 0;
    }

    public String[] getAttrNames() {
        return this.attrNames;
    }

    public Object[] getValues() {
        return this.values;
    }

    public void setValues(Object[] values) {
        this.values = values;
    }
}

