/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core.engine.template;

import java.util.Properties;
import org.beetl.core.Configuration;
import org.beetl.core.ResourceLoader;
import org.beetl.core.Template;
import org.beetl.core.exception.BeetlException;
import org.beetl.core.exception.ErrorInfo;
import org.beetl.core.resource.StringTemplateResourceLoader;
import org.beetl.sql.core.SqlId;
import org.beetl.sql.core.concat.ConcatBuilder;
import org.beetl.sql.core.engine.template.Beetl;
import org.beetl.sql.core.engine.template.BeetlSQLTemplate;
import org.beetl.sql.core.engine.template.BeetlTemplateContext;
import org.beetl.sql.core.engine.template.SQLErrorInfo;
import org.beetl.sql.core.engine.template.SQLTemplate;
import org.beetl.sql.core.engine.template.SQLTemplateEngine;
import org.beetl.sql.core.engine.template.TemplateContext;
import org.beetl.sql.core.loader.SQLLoader;

public class BeetlTemplateEngine
implements SQLTemplateEngine {
    Beetl beetl = null;
    StringTemplateResourceLoader tempLoader = new StringTemplateResourceLoader();
    public String STATEMENT_START;
    public String STATEMENT_END;
    public String HOLDER_START;
    public String HOLDER_END;

    @Override
    public void init(SQLLoader loader, Properties ps) {
        this.beetl = new Beetl(loader, ps);
        Configuration cf = this.beetl.getGroupTemplate().getConf();
        this.STATEMENT_START = cf.getStatementStart();
        this.STATEMENT_END = cf.getStatementEnd();
        if (this.STATEMENT_END == null || this.STATEMENT_END.length() == 0) {
            this.STATEMENT_END = System.getProperty("line.separator", "\n");
        }
        this.HOLDER_START = cf.getPlaceholderStart();
        this.HOLDER_END = cf.getPlaceholderEnd();
    }

    @Override
    public SQLTemplate getSqlTemplate(SqlId id) {
        Template template = this.beetl.getGroupTemplate().getTemplate((Object)id);
        return new BeetlSQLTemplate(template);
    }

    @Override
    public SQLTemplate getSqlTemplate(SqlId id, TemplateContext parent) {
        BeetlTemplateContext context = (BeetlTemplateContext)parent;
        Template template = this.beetl.getGroupTemplate().getTemplate((Object)id, context.ctx);
        return new BeetlSQLTemplate(template);
    }

    @Override
    public SQLErrorInfo validate(String sqlTemplate) {
        StringTemplateResourceLoader templateResourceLoader = new StringTemplateResourceLoader();
        BeetlException exception = this.beetl.getGroupTemplate().validateTemplate((Object)sqlTemplate, (ResourceLoader)templateResourceLoader);
        if (exception == null) {
            return null;
        }
        ErrorInfo error = new ErrorInfo(exception);
        SQLErrorInfo sqlErrorInfo = new SQLErrorInfo();
        sqlErrorInfo.setLine(error.getErrorTokenLine());
        sqlErrorInfo.setToken(error.getErrorTokenText());
        sqlErrorInfo.setRoot(error.getCause());
        return sqlErrorInfo;
    }

    @Override
    public void genVar(ConcatBuilder concatBuilder, String var) {
        this.appendVar(concatBuilder, var);
    }

    @Override
    public String appendVar(String express) {
        return this.HOLDER_START + express + this.HOLDER_END + " ";
    }

    @Override
    public void genTrimStart(ConcatBuilder concatBuilder) {
        this.genTrimStart(concatBuilder, ",");
    }

    @Override
    public void genTrimStart(ConcatBuilder concatBuilder, String keyword) {
        this.appendStatement(concatBuilder, "trim({prefixOverrides:'" + keyword + "'}){");
    }

    @Override
    public void genTrimEnd(ConcatBuilder concatBuilder) {
        this.appendStatement(concatBuilder, "}");
    }

    @Override
    public void genIfNotEmptyStart(ConcatBuilder concatBuilder, String var) {
        this.appendStatement(concatBuilder, "if(isNotEmpty(" + var + ")){");
    }

    @Override
    public void genIfNotEmptyEnd(ConcatBuilder concatBuilder) {
        this.appendStatement(concatBuilder, "}");
    }

    @Override
    public void genForStart(ConcatBuilder concatBuilder, String collection, String var) {
        String express = "for(" + var + " in " + collection + "){";
        this.appendStatement(concatBuilder, express);
    }

    @Override
    public void genForEnd(ConcatBuilder concatBuilder) {
        this.appendStatement(concatBuilder, "}");
    }

    @Override
    public void genTestVar(ConcatBuilder concatBuilder, String var) {
        this.appendVar(concatBuilder, "db.testNull(" + var + "!,\"" + var + "\")");
    }

    @Override
    public void genTestVar(ConcatBuilder concatBuilder, String var, String col) {
        if (col.startsWith("'")) {
            this.appendVar(concatBuilder, "db.testColNull(" + var + ",\"" + col + "\")");
        } else {
            String colName = concatBuilder.getCtx().getKeyWordHandler().getCol(col);
            this.appendVar(concatBuilder, "db.testColNull(" + var + ",'" + colName + "')");
        }
    }

    @Override
    public void genTestVarOrDefault(ConcatBuilder concatBuilder, String var, String defaultValue) {
        this.appendVar(concatBuilder, "db.testVarNull(" + var + ",\"" + defaultValue + "\")");
    }

    @Override
    public String wrapString(String str) {
        if (str.startsWith(this.STATEMENT_START)) {
            return "\\" + str;
        }
        return str;
    }

    protected void appendVar(ConcatBuilder concatBuilder, String express) {
        concatBuilder.append(this.HOLDER_START).append(express).append(this.HOLDER_END).append(" ");
    }

    protected void appendStatement(ConcatBuilder concatBuilder, String statement) {
        concatBuilder.append(this.STATEMENT_START).append(statement).append(this.STATEMENT_END);
    }

    public Beetl getBeetl() {
        return this.beetl;
    }
}

