/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.ext;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.beetl.sql.clazz.SQLType;
import org.beetl.sql.clazz.kit.EnumKit;
import org.beetl.sql.clazz.kit.JavaType;
import org.beetl.sql.core.ExecuteContext;
import org.beetl.sql.core.Interceptor;
import org.beetl.sql.core.InterceptorContext;
import org.beetl.sql.core.SQLManager;
import org.beetl.sql.core.SqlId;
import org.beetl.sql.core.engine.SQLParameter;
import org.beetl.sql.core.query.LambdaQuery;
import org.beetl.sql.core.query.Query;
import org.beetl.sql.core.query.interfacer.QueryExecuteI;

public class DebugInterceptor
implements Interceptor {
    protected static String mapperName = "org.beetl.sql.mapper.MapperJavaProxy";
    protected static String sqlManager = SQLManager.class.getName();
    protected static String queryClassName = Query.class.getName();
    protected static String lambdaQueryName = LambdaQuery.class.getName();
    protected static String defaultQueryMethod = QueryExecuteI.class.getName();
    String preferredShowClass;

    public DebugInterceptor() {
    }

    public DebugInterceptor(String preferredShowClass) {
        this.preferredShowClass = preferredShowClass;
    }

    @Override
    public void before(InterceptorContext ctx) {
        ExecuteContext executeContext = ctx.getExecuteContext();
        SqlId sqlId = executeContext.sqlId;
        String jdbcSql = ctx.getExecuteContext().sqlResult.jdbcSql;
        if (this.isDebugEnable(sqlId)) {
            ctx.put("debug.time", System.currentTimeMillis());
        }
        if (this.isSimple(sqlId)) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        String lineSeparator = System.getProperty("line.separator", "\n");
        sb.append("\u250f\u2501\u2501\u2501\u2501\u2501 Debug [").append(this.formatSqlId(executeContext)).append("] \u2501\u2501\u2501").append(lineSeparator).append("\u2523 SQL\uff1a\t " + DebugInterceptor.formatSql(jdbcSql) + lineSeparator).append("\u2523 \u53c2\u6570\uff1a\t " + this.formatParas(ctx.getExecuteContext().sqlResult.jdbcPara)).append(lineSeparator);
        RuntimeException ex = new RuntimeException();
        StackTraceElement[] traces = ex.getStackTrace();
        int index = this.lookBusinessCodeInTrace(traces);
        StackTraceElement bussinessCode = traces[index];
        String className = bussinessCode.getClassName();
        String mehodName = bussinessCode.getMethodName();
        int line = bussinessCode.getLineNumber();
        sb.append("\u2523 \u4f4d\u7f6e\uff1a\t " + className + "." + mehodName + "(" + bussinessCode.getFileName() + ":" + line + ")" + lineSeparator);
        ctx.put("logs", sb);
    }

    protected String formatSqlId(ExecuteContext executeContext) {
        SqlId id = executeContext.sqlId;
        String str = id.toString();
        String sql = DebugInterceptor.formatSql(str);
        if (sql.length() > 50) {
            return sql.substring(0, 50) + "...";
        }
        return sql;
    }

    protected int lookBusinessCodeInTrace(StackTraceElement[] traces) {
        String className = this.getTraceClassName();
        for (int i = traces.length - 1; i >= 0; --i) {
            String name = traces[i].getClassName();
            if (className != null && className.equals(name)) {
                return i;
            }
            if (name.equals(mapperName)) {
                int skipLine = JavaType.isJdk8() ? 3 : 2;
                return i + skipLine;
            }
            if (name.equals(lambdaQueryName)) {
                return i + 1;
            }
            if (name.equals(queryClassName)) {
                return i + 1;
            }
            if (name.equals(defaultQueryMethod)) {
                return i + 1;
            }
            if (!name.equals(sqlManager)) continue;
            return i + 1;
        }
        throw new IllegalStateException();
    }

    protected String getTraceClassName() {
        return this.preferredShowClass;
    }

    @Override
    public void after(InterceptorContext ctx) {
        ExecuteContext executeContext = ctx.getExecuteContext();
        SqlId sqlId = executeContext.sqlId;
        if (this.isSimple(sqlId)) {
            this.simpleOut(ctx);
            return;
        }
        long time = System.currentTimeMillis();
        long start = (Long)ctx.get("debug.time");
        String lineSeparator = System.getProperty("line.separator", "\n");
        StringBuilder sb = (StringBuilder)ctx.get("logs");
        sb.append("\u2523 \u65f6\u95f4\uff1a\t " + (time - start) + "ms").append(lineSeparator);
        SQLType sqlType = ctx.getExecuteContext().sqlSource.sqlType;
        Object result = ctx.getExecuteContext().executeResult;
        if (sqlType.isUpdate()) {
            sb.append("\u2523 \u66f4\u65b0\uff1a\t [");
            if (result.getClass().isArray()) {
                int[] ret = (int[])result;
                for (int i = 0; i < ret.length; ++i) {
                    if (i > 0) {
                        sb.append(",");
                    }
                    sb.append(ret[i]);
                }
            } else {
                sb.append(result);
            }
            sb.append("]").append(lineSeparator);
        } else if (result instanceof Collection) {
            sb.append("\u2523 \u7ed3\u679c\uff1a\t [").append(((Collection)result).size()).append("]").append(lineSeparator);
        } else {
            sb.append("\u2523 \u7ed3\u679c\uff1a\t [").append(result).append("]").append(lineSeparator);
        }
        sb.append("\u2517\u2501\u2501\u2501\u2501\u2501 Debug [").append(this.formatSqlId(executeContext)).append("] \u2501\u2501\u2501").append(lineSeparator);
        this.println(sb.toString());
    }

    protected boolean isDebugEnable(SqlId sqlId) {
        return true;
    }

    protected List<String> formatParas(List<SQLParameter> list) {
        ArrayList<String> data = new ArrayList<String>(list.size());
        for (SQLParameter para : list) {
            Object obj = para.value;
            if (obj == null) {
                data.add(null);
                continue;
            }
            if (obj instanceof String) {
                String str = (String)obj;
                if (str.length() > 60) {
                    data.add(str.substring(0, 60) + "...(" + str.length() + ")");
                    continue;
                }
                data.add(str);
                continue;
            }
            if (obj instanceof Date) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd (HH:mm:ss.SSS)");
                data.add(sdf.format((Date)obj));
                continue;
            }
            if (obj instanceof Enum) {
                Object value = EnumKit.getValueByEnum((Object)obj);
                data.add(String.valueOf(value));
                continue;
            }
            data.add(obj.toString());
        }
        return data;
    }

    protected void println(String str) {
        System.out.println(str);
    }

    protected void error(String str) {
        System.out.println(str);
    }

    protected String getSqlId(String sqlId) {
        if (sqlId.length() > 50) {
            sqlId = sqlId.substring(0, 50);
            sqlId = sqlId + "...";
        }
        return sqlId;
    }

    @Override
    public void exception(InterceptorContext ctx, Exception ex) {
        SqlId sqlId = ctx.getExecuteContext().sqlId;
        if (this.isSimple(sqlId)) {
            this.simpleOutException(ctx, ex);
            return;
        }
        String lineSeparator = System.getProperty("line.separator", "\n");
        StringBuilder sb = (StringBuilder)ctx.get("logs");
        sb.append("\u2517\u2501\u2501\u2501\u2501\u2501 Debug [ ERROR:").append(ex != null ? ex.getMessage().replace(lineSeparator, "") : "").append("] \u2501\u2501\u2501").append(lineSeparator);
        this.error(sb.toString());
    }

    public static String formatSql(String sql) {
        return sql.replaceAll("--.*", "").replaceAll("\\n", "").replaceAll("\\s+", " ");
    }

    protected boolean isSimple(SqlId sqlId) {
        return false;
    }

    protected void simpleOut(InterceptorContext ctx) {
        SqlId sqlId = ctx.getExecuteContext().sqlId;
        StringBuilder sb = new StringBuilder();
        sb.append("--BeetlSql:").append(sqlId).append(", paras:").append(this.formatParas(ctx.getExecuteContext().sqlResult.jdbcPara));
        this.println(sb.toString());
    }

    protected void simpleOutException(InterceptorContext ctx, Exception ex) {
        SqlId sqlId = ctx.getExecuteContext().sqlId;
        StringBuilder sb = new StringBuilder();
        sb.append("--BeetlSql Error:");
        sb.append(ex != null ? ex.getMessage() : "");
        sb.append(" \u4f4d\u4e8e ").append(sqlId).append(", paras:").append(this.formatParas(ctx.getExecuteContext().sqlResult.jdbcPara));
        this.error(sb.toString());
    }
}

