/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core.concat;

import java.util.ArrayList;
import java.util.List;
import org.beetl.sql.core.concat.ColName;
import org.beetl.sql.core.concat.ConcatBuilder;
import org.beetl.sql.core.concat.Express;
import org.beetl.sql.core.concat.Insert;
import org.beetl.sql.core.concat.Output;
import org.beetl.sql.core.concat.TrimSupport;

public class InsertColNode
extends TrimSupport
implements Output {
    List<Express> list = new ArrayList<Express>();
    Insert insert;

    public InsertColNode(Insert insert) {
        this.insert = insert;
    }

    public InsertColNode add(String name) {
        ColName colName = new ColName(name);
        this.list.add(colName);
        return this;
    }

    public InsertColNode conditional(String col, String varName) {
        InsertColEmptyExpress notEmptyExpress = new InsertColEmptyExpress(col, varName);
        this.list.add(notEmptyExpress);
        this.trim = true;
        return this;
    }

    @Override
    public void toSql(ConcatBuilder sb) {
        if (this.trim) {
            sb.appendTrimStart();
            for (int i = 0; i < this.list.size(); ++i) {
                Express express = this.list.get(i);
                express.toSql(sb);
            }
            sb.appendTrimEnd();
        } else {
            for (int i = 0; i < this.list.size(); ++i) {
                Express express = this.list.get(i);
                if (i != 0) {
                    sb.comma();
                }
                express.toSql(sb);
            }
        }
    }

    public static class InsertColEmptyExpress
    extends Express {
        String col;
        String varName;

        public InsertColEmptyExpress(String col, String varName) {
            this.col = col;
            this.varName = varName;
        }

        @Override
        public void toSql(ConcatBuilder sb) {
            sb.testVar(this.varName, this.col);
        }
    }
}

