/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.beetl.sql.clazz.NameConversion;
import org.beetl.sql.clazz.kit.ClassLoaderKit;
import org.beetl.sql.core.ConnectionSource;
import org.beetl.sql.core.DefaultNameConversion;
import org.beetl.sql.core.Interceptor;
import org.beetl.sql.core.SQLManager;
import org.beetl.sql.core.SqlIdFactory;
import org.beetl.sql.core.db.DBStyle;
import org.beetl.sql.core.db.MySqlStyle;
import org.beetl.sql.core.engine.template.BeetlTemplateEngine;
import org.beetl.sql.core.engine.template.SQLTemplateEngine;
import org.beetl.sql.core.loader.AbstractClassPathSQLLoader;
import org.beetl.sql.core.loader.MarkdownClasspathLoader;
import org.beetl.sql.core.loader.SQLLoader;
import org.beetl.sql.core.mapping.BeanProcessor;
import org.beetl.sql.core.meta.MetadataManager;
import org.beetl.sql.ext.DebugInterceptor;

public class SQLManagerBuilder {
    Properties beetlPs;
    Interceptor[] inters;
    private String defaultSchema;
    private String defaultCatalog;
    private boolean setSchema = false;
    private String name = null;
    private DBStyle dbStyle;
    private SQLLoader sqlLoader;
    private NameConversion nc;
    private ConnectionSource ds;
    private MetadataManager metadataManager;
    private SqlIdFactory sqlIdFactory;
    private String charset = "UTF-8";
    private boolean isProduct = false;
    SQLTemplateEngine sqlTemplateEngine;
    BeanProcessor beanProcessor;
    private List<Interceptor> interceptorList = new LinkedList<Interceptor>();
    private ClassLoaderKit classLoaderKit = null;
    SQLManagerNameGenerator sqlManagerNameGenerator = new SQLManagerNameGenerator();
    public static Map<String, SQLManager> sqlManagerMap = new ConcurrentHashMap<String, SQLManager>();

    public SQLManagerBuilder(ConnectionSource ds) {
        this.ds = ds;
    }

    public SQLManager build() {
        boolean offsetStartZero;
        this.check();
        SQLManager mySqlManager = new SQLManager();
        mySqlManager.isProduct = this.isProduct;
        mySqlManager.charset = this.charset;
        DBStyle myDbStyle = this.getDbStyle();
        SQLLoader mySqlLoader = this.getSqlLoader();
        NameConversion myNc = this.getNc();
        Interceptor[] myInters = this.getInters();
        Properties myPs = this.getBeetlPs();
        SQLTemplateEngine mysSqlTemplateEngine = this.getSqlTemplateEngine();
        myDbStyle.setNameConversion(myNc);
        myDbStyle.init(mysSqlTemplateEngine, myPs);
        MetadataManager myMetadataManager = this.dbStyle.initMetadataManager(this.ds);
        ClassLoaderKit myClassLoaderKit = this.getClassLoaderKit();
        mySqlLoader.setDbStyle(myDbStyle);
        if (mySqlLoader instanceof AbstractClassPathSQLLoader) {
            ((AbstractClassPathSQLLoader)mySqlLoader).setClassLoaderKit(myClassLoaderKit);
        }
        mySqlManager.setDs(this.ds);
        mySqlManager.setSQLTemplateEngine(mysSqlTemplateEngine);
        mySqlManager.setDbStyle(myDbStyle);
        mySqlManager.setSqlLoader(mySqlLoader);
        mySqlManager.setNc(myNc);
        mySqlManager.setInters(myInters);
        mySqlManager.setMetaDataManager(myMetadataManager);
        if (this.name == null) {
            this.name = this.sqlManagerNameGenerator.nextName();
        }
        mySqlManager.setName(this.name);
        mySqlManager.offsetStartZero = offsetStartZero = Boolean.parseBoolean(myPs.getProperty("OFFSET_START_ZERO", "false"));
        this.dbStyle.setOffsetStartZero(offsetStartZero);
        BeanProcessor myBeanProcessor = this.getBeanProcessor();
        mySqlManager.setDefaultBeanProcessors(myBeanProcessor);
        SqlIdFactory mySqlIdFactory = this.getSqlIdFactory();
        mySqlManager.setSqlIdFactory(mySqlIdFactory);
        mySqlManager.setClassLoaderKit(myClassLoaderKit);
        this.dbStyle.config(mySqlManager);
        sqlManagerMap.put(this.name, mySqlManager);
        return mySqlManager;
    }

    private void check() {
        if (this.ds == null) {
            throw new IllegalArgumentException("\u4e0d\u80fd\u521b\u5efaSQLManager,\u81f3\u5c11\u9700\u8981\u63d0\u4f9b ConnectionSource");
        }
    }

    public SQLManagerBuilder addInterceptor(Interceptor interceptor) {
        this.interceptorList.add(interceptor);
        return this;
    }

    public SQLManagerBuilder addInterDebug() {
        this.interceptorList.add(new DebugInterceptor());
        return this;
    }

    private Properties getBeetlPs() {
        if (this.beetlPs == null) {
            Properties ps = this.loadDefaultConfig();
            Properties ext = this.loadExtConfig();
            ps.putAll((Map<?, ?>)ext);
            this.beetlPs = ps;
        }
        return this.beetlPs;
    }

    public Properties loadDefaultConfig() {
        Properties ps = new Properties();
        InputStream ins = this.getClass().getResourceAsStream("/btsql.properties");
        if (ins == null) {
            throw new IllegalStateException("\u9ed8\u8ba4\u914d\u7f6e\u6587\u4ef6\u52a0\u8f7d\u9519:\u627e\u4e0d\u5230 btsql.properties");
        }
        try {
            ps.load(ins);
        }
        catch (IOException e) {
            throw new IllegalStateException("\u9ed8\u8ba4\u914d\u7f6e\u6587\u4ef6\u52a0\u8f7d\u9519:/btsql.properties");
        }
        return ps;
    }

    public Properties loadExtConfig() {
        Properties ps = new Properties();
        InputStream ins = Thread.currentThread().getContextClassLoader().getResourceAsStream("btsql-ext.properties");
        if (ins == null) {
            return ps;
        }
        try {
            ps.load(ins);
            ins.close();
        }
        catch (IOException e) {
            throw new IllegalStateException("\u9ed8\u8ba4\u914d\u7f6e\u6587\u4ef6\u52a0\u8f7d\u9519:/btsql-ext.properties");
        }
        return ps;
    }

    public SQLManagerBuilder setBeetlPs(Properties beetlPs) {
        if (this.beetlPs == null) {
            this.getBeetlPs();
            this.beetlPs.putAll((Map<?, ?>)beetlPs);
        }
        return this;
    }

    public SQLManagerBuilder setBeanProcessor(BeanProcessor beanProcessor) {
        this.beanProcessor = beanProcessor;
        return this;
    }

    private String getDefaultSchema() {
        return this.defaultSchema;
    }

    public SQLManagerBuilder setDefaultSchema(String defaultSchema, String defaultCatalog) {
        this.defaultSchema = defaultSchema;
        this.defaultCatalog = defaultCatalog;
        this.setSchema = true;
        return this;
    }

    public SQLManagerBuilder setName(String name) {
        this.name = name;
        return this;
    }

    private Interceptor[] getInters() {
        if (this.inters == null) {
            this.inters = new Interceptor[0];
        }
        if (this.interceptorList.size() > 0) {
            HashMap<String, Interceptor> map = new HashMap<String, Interceptor>();
            for (Interceptor inter : this.interceptorList) {
                String name = inter.getClass().getName();
                map.put(name, inter);
            }
            for (Interceptor inter : this.inters) {
                String name = inter.getClass().getName();
                map.put(name, inter);
            }
            this.inters = new Interceptor[map.size()];
            int i = 0;
            for (Interceptor inter : map.values()) {
                this.inters[i++] = inter;
            }
        }
        return this.inters;
    }

    public SQLManagerBuilder setInters(Interceptor[] inters) {
        this.inters = inters;
        return this;
    }

    private DBStyle getDbStyle() {
        if (this.dbStyle == null) {
            this.dbStyle = new MySqlStyle();
        }
        return this.dbStyle;
    }

    public SQLManagerBuilder setDbStyle(DBStyle dbStyle) {
        this.dbStyle = dbStyle;
        return this;
    }

    private SQLLoader getSqlLoader() {
        if (this.sqlLoader == null) {
            this.sqlLoader = new MarkdownClasspathLoader("sql", "utf-8");
        }
        return this.sqlLoader;
    }

    public SQLManagerBuilder setSqlLoader(String root, String charset) {
        this.sqlLoader = new MarkdownClasspathLoader(root, charset);
        return this;
    }

    public SQLManagerBuilder setSqlLoader(SQLLoader sqlLoader) {
        this.sqlLoader = sqlLoader;
        return this;
    }

    private NameConversion getNc() {
        if (this.nc == null) {
            this.nc = new DefaultNameConversion();
        }
        return this.nc;
    }

    private BeanProcessor getBeanProcessor() {
        if (this.beanProcessor == null) {
            this.beanProcessor = new BeanProcessor();
        }
        return this.beanProcessor;
    }

    public SqlIdFactory getSqlIdFactory() {
        if (this.sqlIdFactory == null) {
            this.sqlIdFactory = new SqlIdFactory();
        }
        return this.sqlIdFactory;
    }

    public void setSqlIdFactory(SqlIdFactory sqlIdFactory) {
        this.sqlIdFactory = sqlIdFactory;
    }

    private SQLTemplateEngine getSqlTemplateEngine() {
        if (this.sqlTemplateEngine != null) {
            return this.sqlTemplateEngine;
        }
        this.sqlTemplateEngine = new BeetlTemplateEngine();
        this.sqlTemplateEngine.init(this.sqlLoader, this.beetlPs);
        return this.sqlTemplateEngine;
    }

    public SQLManagerBuilder setNc(NameConversion nc) {
        this.nc = nc;
        return this;
    }

    public ClassLoaderKit getClassLoaderKit() {
        if (this.classLoaderKit == null) {
            this.classLoaderKit = new ClassLoaderKit();
        }
        return this.classLoaderKit;
    }

    public void setClassLoaderKit(ClassLoaderKit classLoaderKit) {
        this.classLoaderKit = classLoaderKit;
    }

    static class SQLManagerNameGenerator {
        AtomicInteger count = null;

        SQLManagerNameGenerator() {
        }

        public String nextName() {
            if (this.count == null) {
                this.count = new AtomicInteger(1);
                return "default";
            }
            return "default" + this.count.addAndGet(1);
        }
    }
}

