/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.clazz;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.beetl.sql.annotation.builder.AttributeConvert;
import org.beetl.sql.annotation.builder.BeanConvert;
import org.beetl.sql.annotation.builder.Builder;
import org.beetl.sql.annotation.builder.TargetAdditional;
import org.beetl.sql.annotation.entity.Auto;
import org.beetl.sql.annotation.entity.AutoID;
import org.beetl.sql.annotation.entity.Column;
import org.beetl.sql.annotation.entity.EnumMapping;
import org.beetl.sql.annotation.entity.EnumValue;
import org.beetl.sql.annotation.entity.InsertIgnore;
import org.beetl.sql.annotation.entity.LogicDelete;
import org.beetl.sql.annotation.entity.ProviderConfig;
import org.beetl.sql.annotation.entity.ResultProvider;
import org.beetl.sql.annotation.entity.RowProvider;
import org.beetl.sql.annotation.entity.SeqID;
import org.beetl.sql.annotation.entity.Table;
import org.beetl.sql.annotation.entity.UpdateIgnore;
import org.beetl.sql.annotation.entity.Version;
import org.beetl.sql.clazz.ClassExtAnnotation;
import org.beetl.sql.clazz.NameConversion;
import org.beetl.sql.clazz.kit.BeanKit;
import org.beetl.sql.clazz.kit.CaseInsensitiveHashMap;
import org.beetl.sql.clazz.kit.DefaultCache;
import org.beetl.sql.clazz.kit.EnumKit;
import org.beetl.sql.core.mapping.BeanFetch;
import org.beetl.sql.core.mapping.ResultSetMapper;
import org.beetl.sql.core.mapping.RowMapper;

public class ClassAnnotation {
    static DefaultCache<Class, ClassAnnotation> cache = new DefaultCache();
    Class entityClass = null;
    String tableName = null;
    Map<String, String> attrAnnotationName = new HashMap<String, String>();
    CaseInsensitiveHashMap<String, String> colAnnotationName = new CaseInsensitiveHashMap();
    Set<String> attrUpdateIgnores = null;
    Set<String> attrInsertIgnores = null;
    Map<String, String> enums = null;
    String logicDeleteAttrName = null;
    int logicDeleteAttrValue = 0;
    String versionProperty;
    int initVersionValue = -1;
    RowMapper rowMapper = null;
    ResultSetMapper resultSetMapper = null;
    Annotation mapperConfig = null;
    BeanFetch beanFetch = null;
    Annotation beanFetchAnnotation = null;
    List<String> autoAttrList = null;
    ClassExtAnnotation extAnnotation = new ClassExtAnnotation();
    boolean containExtAnnotation = false;

    public static ClassAnnotation getClassAnnotation(Class entity) {
        ClassAnnotation ca = (ClassAnnotation)cache.get((Object)entity);
        if (ca != null) {
            return ca;
        }
        ca = new ClassAnnotation(entity);
        ca.init();
        cache.put((Object)entity, (Object)ca);
        return ca;
    }

    protected ClassAnnotation(Class entityClass) {
        this.entityClass = entityClass;
    }

    protected void init() {
        if (BeanKit.isJavaClass((Class)this.entityClass)) {
            return;
        }
        this.mappingCheck();
        this.propertyCheck();
        this.checkExtAnnotation();
    }

    protected void checkExtAnnotation() {
        PropertyDescriptor[] ps;
        Annotation[] ans;
        for (Annotation an : ans = this.entityClass.getAnnotations()) {
            Builder builder = an.annotationType().getAnnotation(Builder.class);
            if (builder == null) continue;
            Class ext = builder.value();
            if (TargetAdditional.class.isAssignableFrom(ext)) {
                this.extAnnotation.setAdditionalAnnotation(an);
                this.extAnnotation.setTargetAdditional((TargetAdditional)BeanKit.newSingleInstance((Class)ext));
                continue;
            }
            if (BeanConvert.class.isAssignableFrom(ext)) {
                this.extAnnotation.setBeanConvert((BeanConvert)BeanKit.newSingleInstance((Class)ext));
                this.extAnnotation.setBeanConvertAnnotation(an);
                continue;
            }
            if (!BeanFetch.class.isAssignableFrom(ext)) continue;
            this.beanFetch = (BeanFetch)BeanKit.newSingleInstance((Class)ext);
            this.beanFetchAnnotation = an;
        }
        for (PropertyDescriptor p : ps = this.getPropertyDescriptor(this.entityClass)) {
            String attr = p.getName();
            List attrAns = BeanKit.getAllAnnotation((Class)this.entityClass, (String)attr);
            for (Annotation an : attrAns) {
                Class attrExt = this.getBuilderAnnotation(an);
                if (attrExt == null || !AttributeConvert.class.isAssignableFrom(attrExt)) continue;
                this.extAnnotation.addAttributeConvert(attr, (AttributeConvert)BeanKit.newSingleInstance((Class)attrExt));
            }
        }
        this.containExtAnnotation = this.extAnnotation.hasAttributeExt() || this.extAnnotation.hasEntityExt();
    }

    protected void mappingCheck() {
        Annotation[] ans;
        RowProvider provider;
        ResultProvider mappingConfig;
        Table table = (Table)BeanKit.getAnnotation((Class)this.entityClass, Table.class);
        if (table != null) {
            this.tableName = table.name();
        }
        if ((mappingConfig = this.entityClass.getAnnotation(ResultProvider.class)) != null) {
            this.resultSetMapper = (ResultSetMapper)BeanKit.newSingleInstance(mappingConfig.value());
        }
        if ((provider = this.entityClass.getAnnotation(RowProvider.class)) != null) {
            this.rowMapper = (RowMapper)BeanKit.newInstance(provider.value());
        }
        if (this.rowMapper != null && this.resultSetMapper != null) {
            throw new IllegalArgumentException("rowMapper \u6216\u8005 resultSetMapper \u4e0d\u80fd\u540c\u65f6\u5b58\u5728\u4e8e" + this.entityClass);
        }
        for (Annotation an : ans = this.entityClass.getAnnotations()) {
            ProviderConfig builder = an.annotationType().getAnnotation(ProviderConfig.class);
            if (builder == null) continue;
            this.mapperConfig = an;
        }
    }

    protected void propertyCheck() {
        PropertyDescriptor[] ps;
        for (PropertyDescriptor p : ps = this.getPropertyDescriptor(this.entityClass)) {
            Version version;
            LogicDelete logicDelete;
            SeqID seqId;
            AutoID autoId;
            Auto auto;
            Column column;
            Method readMethod = p.getReadMethod();
            Class<?> type = p.getPropertyType();
            String attr = p.getName();
            if (type.isEnum()) {
                String enumAttr;
                EnumMapping enumMapping = (EnumMapping)BeanKit.getAnnotation((Class)this.entityClass, (String)attr, (Method)readMethod, EnumMapping.class);
                if (enumMapping != null) {
                    enumAttr = enumMapping.value();
                    if (this.enums == null) {
                        this.enums = new HashMap<String, String>();
                    }
                    this.enums.put(attr, enumAttr);
                    EnumKit.init(type, (String)enumAttr);
                } else {
                    enumAttr = this.lookupEnumValueAttr(type);
                    if (enumAttr != null) {
                        EnumKit.init(type, (String)enumAttr);
                    } else {
                        EnumKit.initNoAnotation(type);
                    }
                }
            }
            if ((column = (Column)BeanKit.getAnnotation((Class)this.entityClass, (String)attr, (Method)readMethod, Column.class)) != null) {
                String col = column.value();
                this.attrAnnotationName.put(attr, col);
                this.colAnnotationName.put(col, (Object)attr);
            }
            if ((auto = (Auto)BeanKit.getAnnotation((Class)this.entityClass, (String)attr, (Method)readMethod, Auto.class)) != null) {
                this.checkAutoAttrList();
                this.autoAttrList.add(attr);
            }
            if ((autoId = (AutoID)BeanKit.getAnnotation((Class)this.entityClass, (String)attr, (Method)readMethod, AutoID.class)) != null) {
                this.checkAutoAttrList();
                this.autoAttrList.add(0, attr);
            }
            if ((seqId = (SeqID)BeanKit.getAnnotation((Class)this.entityClass, (String)attr, (Method)readMethod, SeqID.class)) != null) {
                this.checkAutoAttrList();
                this.autoAttrList.add(0, attr);
            }
            InsertIgnore ig = (InsertIgnore)BeanKit.getAnnotation((Class)this.entityClass, (String)attr, (Method)readMethod, InsertIgnore.class);
            UpdateIgnore ug = (UpdateIgnore)BeanKit.getAnnotation((Class)this.entityClass, (String)attr, (Method)readMethod, UpdateIgnore.class);
            if (ig != null) {
                this.checkAttrInsertIgnores();
                this.attrInsertIgnores.add(attr);
            }
            if (ug != null) {
                this.checkAttrUpdateIgnores();
                this.attrUpdateIgnores.add(attr);
            }
            if ((logicDelete = (LogicDelete)BeanKit.getAnnotation((Class)this.entityClass, (String)attr, (Method)readMethod, LogicDelete.class)) != null) {
                this.logicDeleteAttrName = p.getName();
                this.logicDeleteAttrValue = logicDelete.value();
            }
            if ((version = (Version)BeanKit.getAnnotation((Class)this.entityClass, (String)attr, (Method)readMethod, Version.class)) == null) continue;
            this.versionProperty = attr;
            this.initVersionValue = version.value();
        }
    }

    private String lookupEnumValueAttr(Class enumClass) {
        PropertyDescriptor[] ps;
        for (PropertyDescriptor p : ps = this.getPropertyDescriptor(enumClass)) {
            Method readMethod = p.getReadMethod();
            if (readMethod.getDeclaringClass() == Object.class) continue;
            Class<?> type = p.getPropertyType();
            String attr = p.getName();
            EnumValue enumValue = (EnumValue)BeanKit.getAnnotation((Class)enumClass, (String)attr, (Method)readMethod, EnumValue.class);
            if (enumValue == null) continue;
            return attr;
        }
        return null;
    }

    protected Class getBuilderAnnotation(Annotation userCustomizedAnnotation) {
        Builder builder = userCustomizedAnnotation.annotationType().getAnnotation(Builder.class);
        if (builder == null) {
            return null;
        }
        return builder.value();
    }

    public PropertyDescriptor[] getPropertyDescriptor(Class entityClass) {
        try {
            return BeanKit.propertyDescriptors((Class)entityClass);
        }
        catch (IntrospectionException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isInsertIgnore(String attrName) {
        return this.attrInsertIgnores != null && this.attrInsertIgnores.contains(attrName);
    }

    public boolean isUpdateIgnore(String attrName) {
        return this.attrUpdateIgnores != null && this.attrUpdateIgnores.contains(attrName);
    }

    public BeanFetch getBeanFetch() {
        return this.beanFetch;
    }

    public String[] getInsertAutoAttrs() {
        if (this.autoAttrList == null) {
            return BeanKit.EMP_STRING_ARRAY;
        }
        return this.autoAttrList.toArray(new String[0]);
    }

    public String[] getInsertAutoCols(NameConversion nc) {
        if (this.autoAttrList.isEmpty()) {
            return null;
        }
        return this.autoAttrList.stream().map(t -> nc.getColName(this.entityClass, (String)t)).collect(Collectors.toList()).toArray(new String[0]);
    }

    protected void checkAutoAttrList() {
        if (this.autoAttrList == null) {
            this.autoAttrList = new ArrayList<String>(1);
        }
    }

    protected void checkAttrInsertIgnores() {
        if (this.attrInsertIgnores == null) {
            this.attrInsertIgnores = new HashSet<String>();
        }
    }

    protected void checkAttrUpdateIgnores() {
        if (this.attrUpdateIgnores == null) {
            this.attrUpdateIgnores = new HashSet<String>();
        }
    }

    public Class getEntityClass() {
        return this.entityClass;
    }

    public String getTableName() {
        return this.tableName;
    }

    public Map<String, String> getAttrAnnotationName() {
        return this.attrAnnotationName;
    }

    public CaseInsensitiveHashMap<String, String> getColAnnotationName() {
        return this.colAnnotationName;
    }

    public Set<String> getAttrUpdateIgnores() {
        return this.attrUpdateIgnores;
    }

    public Set<String> getAttrInsertIgnores() {
        return this.attrInsertIgnores;
    }

    public Map<String, String> getEnums() {
        return this.enums;
    }

    public String getLogicDeleteAttrName() {
        return this.logicDeleteAttrName;
    }

    public int getLogicDeleteAttrValue() {
        return this.logicDeleteAttrValue;
    }

    public String getVersionProperty() {
        return this.versionProperty;
    }

    public int getInitVersionValue() {
        return this.initVersionValue;
    }

    public RowMapper getRowMapper() {
        return this.rowMapper;
    }

    public ResultSetMapper getResultSetMapper() {
        return this.resultSetMapper;
    }

    public Annotation getMapperConfig() {
        return this.mapperConfig;
    }

    public Annotation getBeanFetchAnnotation() {
        return this.beanFetchAnnotation;
    }

    public List<String> getAutoAttrList() {
        return this.autoAttrList;
    }

    public ClassExtAnnotation getExtAnnotation() {
        return this.extAnnotation;
    }

    public boolean isContainExtAnnotation() {
        return this.containExtAnnotation;
    }

    public void setEntityClass(Class entityClass) {
        this.entityClass = entityClass;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setAttrAnnotationName(Map<String, String> attrAnnotationName) {
        this.attrAnnotationName = attrAnnotationName;
    }

    public void setColAnnotationName(CaseInsensitiveHashMap<String, String> colAnnotationName) {
        this.colAnnotationName = colAnnotationName;
    }

    public void setAttrUpdateIgnores(Set<String> attrUpdateIgnores) {
        this.attrUpdateIgnores = attrUpdateIgnores;
    }

    public void setAttrInsertIgnores(Set<String> attrInsertIgnores) {
        this.attrInsertIgnores = attrInsertIgnores;
    }

    public void setEnums(Map<String, String> enums) {
        this.enums = enums;
    }

    public void setLogicDeleteAttrName(String logicDeleteAttrName) {
        this.logicDeleteAttrName = logicDeleteAttrName;
    }

    public void setLogicDeleteAttrValue(int logicDeleteAttrValue) {
        this.logicDeleteAttrValue = logicDeleteAttrValue;
    }

    public void setVersionProperty(String versionProperty) {
        this.versionProperty = versionProperty;
    }

    public void setInitVersionValue(int initVersionValue) {
        this.initVersionValue = initVersionValue;
    }

    public void setRowMapper(RowMapper rowMapper) {
        this.rowMapper = rowMapper;
    }

    public void setResultSetMapper(ResultSetMapper resultSetMapper) {
        this.resultSetMapper = resultSetMapper;
    }

    public void setMapperConfig(Annotation mapperConfig) {
        this.mapperConfig = mapperConfig;
    }

    public void setBeanFetch(BeanFetch beanFetch) {
        this.beanFetch = beanFetch;
    }

    public void setBeanFetchAnnotation(Annotation beanFetchAnnotation) {
        this.beanFetchAnnotation = beanFetchAnnotation;
    }

    public void setAutoAttrList(List<String> autoAttrList) {
        this.autoAttrList = autoAttrList;
    }

    public void setExtAnnotation(ClassExtAnnotation extAnnotation) {
        this.extAnnotation = extAnnotation;
    }

    public void setContainExtAnnotation(boolean containExtAnnotation) {
        this.containExtAnnotation = containExtAnnotation;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClassAnnotation)) {
            return false;
        }
        ClassAnnotation other = (ClassAnnotation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Class this$entityClass = this.getEntityClass();
        Class other$entityClass = other.getEntityClass();
        if (this$entityClass == null ? other$entityClass != null : !this$entityClass.equals(other$entityClass)) {
            return false;
        }
        String this$tableName = this.getTableName();
        String other$tableName = other.getTableName();
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
            return false;
        }
        Map<String, String> this$attrAnnotationName = this.getAttrAnnotationName();
        Map<String, String> other$attrAnnotationName = other.getAttrAnnotationName();
        if (this$attrAnnotationName == null ? other$attrAnnotationName != null : !((Object)this$attrAnnotationName).equals(other$attrAnnotationName)) {
            return false;
        }
        CaseInsensitiveHashMap<String, String> this$colAnnotationName = this.getColAnnotationName();
        CaseInsensitiveHashMap<String, String> other$colAnnotationName = other.getColAnnotationName();
        if (this$colAnnotationName == null ? other$colAnnotationName != null : !this$colAnnotationName.equals(other$colAnnotationName)) {
            return false;
        }
        Set<String> this$attrUpdateIgnores = this.getAttrUpdateIgnores();
        Set<String> other$attrUpdateIgnores = other.getAttrUpdateIgnores();
        if (this$attrUpdateIgnores == null ? other$attrUpdateIgnores != null : !((Object)this$attrUpdateIgnores).equals(other$attrUpdateIgnores)) {
            return false;
        }
        Set<String> this$attrInsertIgnores = this.getAttrInsertIgnores();
        Set<String> other$attrInsertIgnores = other.getAttrInsertIgnores();
        if (this$attrInsertIgnores == null ? other$attrInsertIgnores != null : !((Object)this$attrInsertIgnores).equals(other$attrInsertIgnores)) {
            return false;
        }
        Map<String, String> this$enums = this.getEnums();
        Map<String, String> other$enums = other.getEnums();
        if (this$enums == null ? other$enums != null : !((Object)this$enums).equals(other$enums)) {
            return false;
        }
        String this$logicDeleteAttrName = this.getLogicDeleteAttrName();
        String other$logicDeleteAttrName = other.getLogicDeleteAttrName();
        if (this$logicDeleteAttrName == null ? other$logicDeleteAttrName != null : !this$logicDeleteAttrName.equals(other$logicDeleteAttrName)) {
            return false;
        }
        if (this.getLogicDeleteAttrValue() != other.getLogicDeleteAttrValue()) {
            return false;
        }
        String this$versionProperty = this.getVersionProperty();
        String other$versionProperty = other.getVersionProperty();
        if (this$versionProperty == null ? other$versionProperty != null : !this$versionProperty.equals(other$versionProperty)) {
            return false;
        }
        if (this.getInitVersionValue() != other.getInitVersionValue()) {
            return false;
        }
        RowMapper this$rowMapper = this.getRowMapper();
        RowMapper other$rowMapper = other.getRowMapper();
        if (this$rowMapper == null ? other$rowMapper != null : !this$rowMapper.equals(other$rowMapper)) {
            return false;
        }
        ResultSetMapper this$resultSetMapper = this.getResultSetMapper();
        ResultSetMapper other$resultSetMapper = other.getResultSetMapper();
        if (this$resultSetMapper == null ? other$resultSetMapper != null : !this$resultSetMapper.equals(other$resultSetMapper)) {
            return false;
        }
        Annotation this$mapperConfig = this.getMapperConfig();
        Annotation other$mapperConfig = other.getMapperConfig();
        if (this$mapperConfig == null ? other$mapperConfig != null : !((Object)this$mapperConfig).equals(other$mapperConfig)) {
            return false;
        }
        BeanFetch this$beanFetch = this.getBeanFetch();
        BeanFetch other$beanFetch = other.getBeanFetch();
        if (this$beanFetch == null ? other$beanFetch != null : !this$beanFetch.equals(other$beanFetch)) {
            return false;
        }
        Annotation this$beanFetchAnnotation = this.getBeanFetchAnnotation();
        Annotation other$beanFetchAnnotation = other.getBeanFetchAnnotation();
        if (this$beanFetchAnnotation == null ? other$beanFetchAnnotation != null : !((Object)this$beanFetchAnnotation).equals(other$beanFetchAnnotation)) {
            return false;
        }
        List<String> this$autoAttrList = this.getAutoAttrList();
        List<String> other$autoAttrList = other.getAutoAttrList();
        if (this$autoAttrList == null ? other$autoAttrList != null : !((Object)this$autoAttrList).equals(other$autoAttrList)) {
            return false;
        }
        ClassExtAnnotation this$extAnnotation = this.getExtAnnotation();
        ClassExtAnnotation other$extAnnotation = other.getExtAnnotation();
        if (this$extAnnotation == null ? other$extAnnotation != null : !((Object)this$extAnnotation).equals(other$extAnnotation)) {
            return false;
        }
        return this.isContainExtAnnotation() == other.isContainExtAnnotation();
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClassAnnotation;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Class $entityClass = this.getEntityClass();
        result = result * 59 + ($entityClass == null ? 43 : $entityClass.hashCode());
        String $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        Map<String, String> $attrAnnotationName = this.getAttrAnnotationName();
        result = result * 59 + ($attrAnnotationName == null ? 43 : ((Object)$attrAnnotationName).hashCode());
        CaseInsensitiveHashMap<String, String> $colAnnotationName = this.getColAnnotationName();
        result = result * 59 + ($colAnnotationName == null ? 43 : $colAnnotationName.hashCode());
        Set<String> $attrUpdateIgnores = this.getAttrUpdateIgnores();
        result = result * 59 + ($attrUpdateIgnores == null ? 43 : ((Object)$attrUpdateIgnores).hashCode());
        Set<String> $attrInsertIgnores = this.getAttrInsertIgnores();
        result = result * 59 + ($attrInsertIgnores == null ? 43 : ((Object)$attrInsertIgnores).hashCode());
        Map<String, String> $enums = this.getEnums();
        result = result * 59 + ($enums == null ? 43 : ((Object)$enums).hashCode());
        String $logicDeleteAttrName = this.getLogicDeleteAttrName();
        result = result * 59 + ($logicDeleteAttrName == null ? 43 : $logicDeleteAttrName.hashCode());
        result = result * 59 + this.getLogicDeleteAttrValue();
        String $versionProperty = this.getVersionProperty();
        result = result * 59 + ($versionProperty == null ? 43 : $versionProperty.hashCode());
        result = result * 59 + this.getInitVersionValue();
        RowMapper $rowMapper = this.getRowMapper();
        result = result * 59 + ($rowMapper == null ? 43 : $rowMapper.hashCode());
        ResultSetMapper $resultSetMapper = this.getResultSetMapper();
        result = result * 59 + ($resultSetMapper == null ? 43 : $resultSetMapper.hashCode());
        Annotation $mapperConfig = this.getMapperConfig();
        result = result * 59 + ($mapperConfig == null ? 43 : ((Object)$mapperConfig).hashCode());
        BeanFetch $beanFetch = this.getBeanFetch();
        result = result * 59 + ($beanFetch == null ? 43 : $beanFetch.hashCode());
        Annotation $beanFetchAnnotation = this.getBeanFetchAnnotation();
        result = result * 59 + ($beanFetchAnnotation == null ? 43 : ((Object)$beanFetchAnnotation).hashCode());
        List<String> $autoAttrList = this.getAutoAttrList();
        result = result * 59 + ($autoAttrList == null ? 43 : ((Object)$autoAttrList).hashCode());
        ClassExtAnnotation $extAnnotation = this.getExtAnnotation();
        result = result * 59 + ($extAnnotation == null ? 43 : ((Object)$extAnnotation).hashCode());
        result = result * 59 + (this.isContainExtAnnotation() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "ClassAnnotation(entityClass=" + this.getEntityClass() + ", tableName=" + this.getTableName() + ", attrAnnotationName=" + this.getAttrAnnotationName() + ", colAnnotationName=" + this.getColAnnotationName() + ", attrUpdateIgnores=" + this.getAttrUpdateIgnores() + ", attrInsertIgnores=" + this.getAttrInsertIgnores() + ", enums=" + this.getEnums() + ", logicDeleteAttrName=" + this.getLogicDeleteAttrName() + ", logicDeleteAttrValue=" + this.getLogicDeleteAttrValue() + ", versionProperty=" + this.getVersionProperty() + ", initVersionValue=" + this.getInitVersionValue() + ", rowMapper=" + this.getRowMapper() + ", resultSetMapper=" + this.getResultSetMapper() + ", mapperConfig=" + this.getMapperConfig() + ", beanFetch=" + this.getBeanFetch() + ", beanFetchAnnotation=" + this.getBeanFetchAnnotation() + ", autoAttrList=" + this.getAutoAttrList() + ", extAnnotation=" + this.getExtAnnotation() + ", containExtAnnotation=" + this.isContainExtAnnotation() + ")";
    }
}

