/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.ext;

import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.beetl.sql.core.DefaultConnectionSource;
import org.beetl.sql.core.SQLManager;

public class DBInitHelper {
    public static void executeSqlScript(SQLManager sqlManager, String sqlFile) {
        try {
            InputStream ins = sqlManager.getClassLoaderKit().loadResource(sqlFile);
            if (ins == null) {
                throw new IllegalArgumentException("sql script \u4e0d\u5b58\u5728 " + sqlFile);
            }
            int len = ins.available();
            byte[] bs = new byte[len];
            ins.read(bs);
            String str = new String(bs, "UTF-8");
            String[] sqls = str.split(";");
            DefaultConnectionSource defaultConnectionSource = (DefaultConnectionSource)sqlManager.getDs();
            DBInitHelper.executeSql(defaultConnectionSource.getMasterConn(), sqls);
            if (defaultConnectionSource.getSlaves() != null) {
                for (DataSource salve : defaultConnectionSource.getSlaves()) {
                    DBInitHelper.executeSql(salve.getConnection(), sqls);
                }
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private static void executeSql(Connection conn, String[] sqls) throws SQLException {
        for (String sql : sqls) {
            PreparedStatement ps = conn.prepareStatement(sql);
            ps.executeUpdate();
            ps.close();
        }
    }
}

