/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core.mapping.join;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Type;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.beetl.sql.clazz.kit.BeanKit;
import org.beetl.sql.clazz.kit.BeetlSQLException;
import org.beetl.sql.core.ExecuteContext;
import org.beetl.sql.core.mapping.BeanProcessor;
import org.beetl.sql.core.mapping.join.ConfigJoinMapper;
import org.beetl.sql.core.mapping.type.JavaSqlTypeHandler;
import org.beetl.sql.core.mapping.type.ReadTypeParameter;

public class AttrNode {
    public Class target;
    public AttrNode parent;
    public List<AttrNode> children;
    public PropertyDescriptor typePdInParent;
    public Map<Integer, String> colMap = new HashMap<Integer, String>();
    public Map<String, PropertyDescriptor> propertyMap = new HashMap<String, PropertyDescriptor>();

    public AttrNode() {
        this.parent = null;
    }

    public AttrNode(AttrNode parent) {
        this.parent = parent;
    }

    public void initNode(Class target, Map<String, Object> mapping, Map<String, Integer> columnIndexMap) throws Exception {
        this.target = target;
        for (Map.Entry<String, Object> entry : mapping.entrySet()) {
            String attr = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof String) {
                String col = (String)value;
                Integer index = columnIndexMap.get(col);
                if (index == null) continue;
                this.colMap.put(index, attr);
                PropertyDescriptor pd = BeanKit.getPropertyDescriptor((Class)target, (String)attr);
                if (pd == null) {
                    throw new BeetlSQLException(3, "\u6620\u5c04\u914d\u7f6e\u9519\uff0c\u672a\u627e\u5230\u914d\u7f6e col " + col + "\u5bf9\u5e94\u7684\u5c5e\u6027");
                }
                this.propertyMap.put(attr, pd);
                continue;
            }
            if (this.children == null) {
                this.children = new ArrayList<AttrNode>();
            }
            Map childMapping = (Map)value;
            PropertyDescriptor pd = BeanKit.getPropertyDescriptor((Class)target, (String)attr);
            Class<?> type = pd.getPropertyType();
            AttrNode childNode = new AttrNode(this);
            childNode.typePdInParent = pd;
            if (Collection.class.isAssignableFrom(type)) {
                Type genericReturnType = pd.getReadMethod().getGenericReturnType();
                Class<Map> childTarget = BeanKit.getCollectionType((Type)genericReturnType);
                if (childTarget == null) {
                    childTarget = Map.class;
                }
                childNode.initNode(childTarget, childMapping, columnIndexMap);
                this.children.add(childNode);
                continue;
            }
            childNode.initNode(type, childMapping, columnIndexMap);
            this.children.add(childNode);
        }
    }

    public void visit(ConfigJoinMapper.RenderContext renderContext, ExecuteContext ctx, ReadTypeParameter rtp) throws Exception {
        ConfigJoinMapper.NodeValue nodeValue = this.getNodeValueFromResultSet(renderContext, ctx, rtp);
        ConfigJoinMapper.Grid grid = renderContext.grid;
        if (grid.contain(this, nodeValue.key)) {
            ConfigJoinMapper.ObjectWrapper obj;
            renderContext.parent = obj = grid.getNodeValue((AttrNode)this, (Object)nodeValue.key).objectWrapper;
            this.visitAll(renderContext, ctx, rtp);
            return;
        }
        grid.push(this, nodeValue);
        this.fillObject(nodeValue);
        ConfigJoinMapper.ObjectWrapper realObj = nodeValue.objectWrapper;
        if (this.parent != null) {
            ConfigJoinMapper.ObjectWrapper parentObj = renderContext.parent;
            this.assignToParent(renderContext, ctx, parentObj, realObj, this.typePdInParent);
        }
        renderContext.parent = realObj;
        this.visitAll(renderContext, ctx, rtp);
    }

    void fillObject(ConfigJoinMapper.NodeValue nodeValue) throws Exception {
        ConfigJoinMapper.ObjectWrapper objectWrapper = new ConfigJoinMapper.ObjectWrapper();
        objectWrapper.fromNodeValue = nodeValue;
        objectWrapper.target = this.target;
        objectWrapper.makeObject(this.propertyMap);
    }

    ConfigJoinMapper.NodeValue getNodeValueFromResultSet(ConfigJoinMapper.RenderContext renderContext, ExecuteContext ctx, ReadTypeParameter rtp) throws SQLException {
        if (this.colMap.isEmpty()) {
            throw new IllegalArgumentException("\u65e0\u6cd5\u6620\u5c04\uff0c\u6b64\u5c42\u6ca1\u6709\u503c,\u65e0\u6cd5\u8bc6\u522b\u662f\u5426\u91cd\u590d");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        BeanProcessor beanProcessor = renderContext.beanProcessor;
        for (Map.Entry<Integer, String> entry : this.colMap.entrySet()) {
            rtp.setIndex(entry.getKey());
            JavaSqlTypeHandler sqlTypeHandler = beanProcessor.getHandler(this.target);
            if (sqlTypeHandler == null) {
                sqlTypeHandler = beanProcessor.getDefaultHandler();
            }
            Object value = sqlTypeHandler.getValue(rtp);
            String attr = entry.getValue();
            map.put(attr, value);
        }
        ConfigJoinMapper.NodeValue nodeValue = new ConfigJoinMapper.NodeValue(map);
        return nodeValue;
    }

    void assignToParent(ConfigJoinMapper.RenderContext renderContext, ExecuteContext ctx, ConfigJoinMapper.ObjectWrapper parent, ConfigJoinMapper.ObjectWrapper attrValue, PropertyDescriptor typePdInParent) throws Exception {
        Class<?> propertyType = typePdInParent.getPropertyType();
        if (List.class.isAssignableFrom(propertyType) || Set.class.isAssignableFrom(propertyType)) {
            HashSet<Object> set = parent.flagMap.get(typePdInParent);
            if (set == null) {
                set = new HashSet<Object>();
                parent.flagMap.put(typePdInParent, set);
            }
            if (set.contains(attrValue.fromNodeValue.key)) {
                return;
            }
            Collection values = (Collection)typePdInParent.getReadMethod().invoke(parent.realObject, new Object[0]);
            if (values == null) {
                values = BeanKit.newCollectionInstance(typePdInParent.getPropertyType());
                typePdInParent.getWriteMethod().invoke(parent.realObject, values);
            }
            values.add(attrValue.realObject);
            set.add(attrValue.fromNodeValue.key);
        } else if (!parent.flagMap.containsKey(typePdInParent)) {
            BeanProcessor beanProcessor = ctx.sqlManager.getDefaultBeanProcessors();
            beanProcessor.callSetter(parent.realObject, typePdInParent, attrValue.realObject, typePdInParent.getPropertyType());
        }
    }

    public void visitAll(ConfigJoinMapper.RenderContext renderContext, ExecuteContext ctx, ReadTypeParameter rtp) throws Exception {
        if (this.children != null) {
            ConfigJoinMapper.ObjectWrapper wrapper = renderContext.parent;
            for (AttrNode node : this.children) {
                node.visit(renderContext, ctx, rtp);
                renderContext.parent = wrapper;
            }
        }
    }
}

