/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.beetl.sql.clazz.ClassDesc;
import org.beetl.sql.clazz.MockClassDesc;
import org.beetl.sql.clazz.NameConversion;
import org.beetl.sql.clazz.SQLType;
import org.beetl.sql.clazz.TableDesc;
import org.beetl.sql.clazz.kit.AutoSQLEnum;
import org.beetl.sql.clazz.kit.BeanKit;
import org.beetl.sql.clazz.kit.BeetlSQLException;
import org.beetl.sql.clazz.kit.ClassLoaderKit;
import org.beetl.sql.clazz.kit.PageKit;
import org.beetl.sql.clazz.kit.StringKit;
import org.beetl.sql.core.ConnectionSource;
import org.beetl.sql.core.ConnectionSourceHelper;
import org.beetl.sql.core.DataAPI;
import org.beetl.sql.core.ExecuteContext;
import org.beetl.sql.core.IDAutoGen;
import org.beetl.sql.core.Interceptor;
import org.beetl.sql.core.MapperBuilder;
import org.beetl.sql.core.OnConnection;
import org.beetl.sql.core.QueryConfig;
import org.beetl.sql.core.SQLBatchReady;
import org.beetl.sql.core.SQLExecutor;
import org.beetl.sql.core.SQLManagerBuilder;
import org.beetl.sql.core.SQLReady;
import org.beetl.sql.core.SQLResult;
import org.beetl.sql.core.SQLSource;
import org.beetl.sql.core.SqlId;
import org.beetl.sql.core.SqlIdFactory;
import org.beetl.sql.core.db.DBStyle;
import org.beetl.sql.core.engine.PageQuery;
import org.beetl.sql.core.engine.template.SQLErrorInfo;
import org.beetl.sql.core.engine.template.SQLTemplateEngine;
import org.beetl.sql.core.engine.template.TemplateContext;
import org.beetl.sql.core.loader.SQLLoader;
import org.beetl.sql.core.mapping.BeanProcessor;
import org.beetl.sql.core.meta.MetadataManager;
import org.beetl.sql.core.page.PageRequest;
import org.beetl.sql.core.page.PageResult;
import org.beetl.sql.core.query.LambdaQuery;
import org.beetl.sql.core.query.Query;

public class SQLManager
implements DataAPI {
    Interceptor[] inters = new Interceptor[0];
    SQLTemplateEngine sqlTemplateEngine = null;
    boolean offsetStartZero = false;
    Map<String, BeanProcessor> processors = new HashMap<String, BeanProcessor>();
    BeanProcessor defaultBeanProcessors = null;
    Map<String, IDAutoGen> idAutonGenMap = new HashMap<String, IDAutoGen>();
    private DBStyle dbStyle;
    private SQLLoader sqlLoader;
    private ConnectionSource ds = null;
    private NameConversion nc = null;
    private MetadataManager metaDataManager;
    private ClassLoaderKit classLoaderKit = null;
    SqlIdFactory sqlIdFactory;
    String charset;
    boolean isProduct = false;
    MapperBuilder mapperBuilder = null;
    ThreadLocal<QueryConfig> queryConfigLocal = ThreadLocal.withInitial(() -> new QueryConfig());
    protected Map<String, SQLManager> group = new HashMap<String, SQLManager>();
    protected String name;

    protected SQLManager() {
        Class<?> c = null;
        try {
            c = Class.forName("org.beetl.sql.mapper.DefaultMapperBuilder");
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
        this.mapperBuilder = (MapperBuilder)BeanKit.newInstance(c);
        this.mapperBuilder.setSqlManager(this);
    }

    public static SQLManagerBuilder newBuilder(ConnectionSource ds) {
        return new SQLManagerBuilder(ds);
    }

    public static SQLManagerBuilder newBuilder(String driver, String url, String userName, String password) {
        ConnectionSource source = ConnectionSourceHelper.getSimple(driver, url, userName, password);
        return SQLManager.newBuilder(source);
    }

    @Override
    public <T> Query<T> query(Class<T> clazz) {
        return new Query<T>(this, clazz);
    }

    @Override
    public <T> LambdaQuery<T> lambdaQuery(Class<T> clazz) {
        if (BeanKit.queryLambdasSupport) {
            return new LambdaQuery(this, (Class)clazz);
        }
        throw new UnsupportedOperationException("\u9700\u8981Java8\u4ee5\u4e0a");
    }

    public boolean isOffsetStartZero() {
        return this.offsetStartZero;
    }

    public boolean isProductMode() {
        return this.isProduct;
    }

    public SQLResult getSQLResult(SqlId id, Object paras) {
        SQLExecutor script = this.getScript(id);
        Map map = script.beforeExecute(null, paras, false);
        return script.run(map);
    }

    public SQLResult getSQLResult(SQLSource source, Object inputParas) {
        ExecuteContext ctx = ExecuteContext.instance(this);
        ctx.sqlId = source.id;
        ctx.sqlSource = source;
        SQLExecutor script = this.dbStyle.buildExecutor(ctx);
        Map map = script.beforeExecute(null, inputParas, false);
        SQLResult result = script.run(map);
        return result;
    }

    public SQLResult getSQLResult(SqlId id, Object paras, TemplateContext ctx) {
        SQLExecutor script = this.getScript(id);
        Map parasMap = script.beforeExecute(null, paras, false);
        return script.run(parasMap, ctx);
    }

    public SQLExecutor getScript(SqlId sqlId) {
        SQLSource source = this.sqlLoader.querySQL(sqlId);
        if (source == null) {
            throw this.sqlLoader.getExeception(sqlId);
        }
        ExecuteContext context = ExecuteContext.instance(this).initSQLSource(source);
        context.fill(this.queryConfigLocal);
        SQLExecutor script = this.dbStyle.buildExecutor(context);
        return script;
    }

    public boolean containSqlId(SqlId sqlId) {
        return this.sqlLoader.exist(sqlId);
    }

    @Override
    public SQLErrorInfo validateSqlId(SqlId id) {
        SQLSource source = this.sqlLoader.querySQL(id);
        if (source == null) {
            throw new IllegalArgumentException(id + " \u4e0d\u5b58\u5728");
        }
        String sqlTemplate = source.template;
        return this.sqlTemplateEngine.validate(sqlTemplate);
    }

    public SQLManager viewType(Class view) {
        this.queryConfigLocal.get().setViewClass(view);
        return this;
    }

    public SQLManager resultSetMapper(Class resultSetMapperClass) {
        this.queryConfigLocal.get().setResultSetClass(resultSetMapperClass);
        return this;
    }

    public SQLManager rowMapper(Class rowMapperClass) {
        this.queryConfigLocal.get().setRowMapperClass(rowMapperClass);
        return this;
    }

    public SQLExecutor getScript(Class<?> cls, AutoSQLEnum autoSQLEnum) {
        SqlId id = this.sqlIdFactory.buildIdentity(cls, autoSQLEnum);
        QueryConfig queryConfig = this.queryConfigLocal.get();
        Class viewType = null;
        if (queryConfig != null && (viewType = queryConfig.getViewClass()) != null) {
            id = id.toView(viewType);
            queryConfig.setViewClass(null);
        }
        ExecuteContext context = ExecuteContext.instance(this);
        SQLSource tempSource = this.sqlLoader.querySQL(id);
        if (tempSource != null) {
            context.initSQLSource(tempSource);
            return this.dbStyle.buildExecutor(context);
        }
        SQLType sqlType = null;
        switch (autoSQLEnum) {
            case SELECT_BY_ID: {
                tempSource = this.dbStyle.genSelectById(cls, viewType);
                sqlType = SQLType.SELECT;
                break;
            }
            case SELECT_BY_IDS: {
                tempSource = this.dbStyle.genSelectByIds(cls, viewType);
                sqlType = SQLType.SELECT;
                break;
            }
            case EXIST_BY_ID: {
                tempSource = this.dbStyle.genExistSql(cls);
                sqlType = SQLType.SELECT;
                break;
            }
            case SELECT_BY_TEMPLATE: {
                tempSource = this.dbStyle.genSelectByTemplate(cls, viewType);
                sqlType = SQLType.SELECT;
                break;
            }
            case SELECT_COUNT_BY_TEMPLATE: {
                tempSource = this.dbStyle.genSelectCountByTemplate(cls);
                sqlType = SQLType.SELECT;
                break;
            }
            case DELETE_BY_ID: {
                tempSource = this.dbStyle.genDeleteById(cls);
                sqlType = SQLType.SELECT;
                break;
            }
            case SELECT_ALL: {
                tempSource = this.dbStyle.genSelectAll(cls, viewType);
                sqlType = SQLType.SELECT;
                break;
            }
            case UPDATE_ALL: {
                tempSource = this.dbStyle.genUpdateAll(cls);
                sqlType = SQLType.UPDATE;
                break;
            }
            case UPDATE_BY_ID: {
                tempSource = this.dbStyle.genUpdateById(cls);
                sqlType = SQLType.UPDATE;
                break;
            }
            case UPDATE_TEMPLATE_BY_ID: {
                tempSource = this.dbStyle.genUpdateTemplate(cls);
                sqlType = SQLType.UPDATE;
                break;
            }
            case INSERT: {
                tempSource = this.dbStyle.genInsert(cls);
                sqlType = SQLType.INSERT;
                break;
            }
            case INSERT_TEMPLATE: {
                tempSource = this.dbStyle.genInsertTemplate(cls);
                sqlType = SQLType.INSERT;
                break;
            }
            case DELETE_TEMPLATE_BY_ID: {
                tempSource = this.dbStyle.genDeleteById(cls);
                sqlType = SQLType.DELETE;
                break;
            }
            case LOCK_BY_ID: {
                tempSource = this.dbStyle.genSelectByIdForUpdate(cls, viewType);
                sqlType = SQLType.SELECT;
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        tempSource.setId(id);
        tempSource.setSqlType(sqlType);
        tempSource.setAutoGenerated(true);
        context.initSQLSource(tempSource);
        this.sqlLoader.addSQL(id, tempSource);
        return this.dbStyle.buildExecutor(context);
    }

    protected SQLExecutor getPageSqlScript(Class mapping, SqlId selectId) {
        SqlId pageId = selectId.toPage();
        ExecuteContext ctx = ExecuteContext.instance(this);
        SQLSource source = this.sqlLoader.querySQL(pageId);
        if (source != null) {
            ctx.initSQLSource(source);
            return this.dbStyle.buildExecutor(ctx);
        }
        SQLSource script = this.sqlLoader.querySQL(selectId);
        String template = script.getTemplate();
        String pageTemplate = this.dbStyle.getRangeSql().toTemplateRange(mapping, template);
        source = new SQLSource(pageId, pageTemplate);
        source.setSqlType(SQLType.SELECT);
        source.version = script.version;
        this.sqlLoader.addSQL(pageId, source);
        ctx.initSQLSource(source);
        return this.dbStyle.buildExecutor(ctx);
    }

    @Override
    public <T> List<T> select(SqlId sqlId, Class<T> clazz, Object paras) {
        SQLExecutor script = this.getScript(sqlId);
        return script.select(clazz, paras);
    }

    @Override
    public <T> List<T> select(SqlId sqlId, Class<T> clazz) {
        return this.select(sqlId, clazz, null);
    }

    @Override
    public <T> PageResult<T> pageQuery(SqlId sqlId, Class<T> clazz, Object paras, PageRequest request) {
        List<T> list;
        if (request instanceof PageQuery) {
            paras = request.getParas();
        }
        Long totalRow = null;
        boolean totalRequired = request.isTotalRequired();
        String orderBy = request.getOrderBy();
        SqlId sqlCountId = sqlId.toCount();
        boolean hasCountSQL = false;
        if (request.isTotalRequired()) {
            hasCountSQL = this.sqlLoader.exist(sqlCountId);
            try {
                if (hasCountSQL) {
                    totalRow = this.selectUnique(sqlCountId, paras, Long.class);
                } else {
                    SQLExecutor script = this.getScript(sqlId);
                    Map pageParas = script.beforeExecute(Long.class, paras, false);
                    pageParas.put("_page", Boolean.TRUE);
                    totalRow = script.selectUnique(Long.class, pageParas);
                }
            }
            catch (BeetlSQLException ex) {
                if (ex.code == 12) {
                    throw new BeetlSQLException(24, "\u7ffb\u9875\u8bed\u53e5\u683c\u5f0f\u51fa\u9519\uff0c\u671f\u671b\u603b\u6570\u67e5\u8be2SQL,\u9057\u6f0f\u4e86page\u51fd\u6570\u6216\u8005sql\u662f\u5206\u7ec4\u67e5\u8be2?");
                }
                throw ex;
            }
            if (totalRow == null) {
                totalRow = 0L;
            }
        }
        if (totalRow == null || totalRow != 0L) {
            long size = request.getPageSize();
            Object start = request.getStart(this.offsetStartZero);
            SQLExecutor sqlExecutor = this.getScript(sqlId);
            SQLExecutor pageSqlEx = this.getPageSqlScript(clazz, sqlId);
            Map pageParas = pageSqlEx.beforeExecute(clazz, paras, false);
            if (pageParas.containsKey("_page")) {
                pageParas.remove("_page");
            }
            this.dbStyle.getRangeSql().addTemplateRangeParas(pageParas, start, size);
            if (!StringKit.isEmpty((String)orderBy)) {
                pageParas.put("_orderBy", orderBy);
            }
            list = pageSqlEx.select(clazz, pageParas);
        } else {
            list = Collections.EMPTY_LIST;
        }
        PageResult pageReqeust = totalRequired ? request.of(list, totalRow) : request.of(list);
        return pageReqeust;
    }

    @Override
    public <T> T unique(Class<T> clazz, Object pk) {
        SQLExecutor script = this.getScript(clazz, AutoSQLEnum.SELECT_BY_ID);
        return script.unique(clazz, pk);
    }

    @Override
    public <T> T single(Class<T> clazz, Object pk) {
        SQLExecutor script = this.getScript(clazz, AutoSQLEnum.SELECT_BY_ID);
        return script.single(clazz, pk);
    }

    @Override
    public <T> List<T> selectByIds(Class<T> clazz, List<?> pks) {
        SQLExecutor script = this.getScript(clazz, AutoSQLEnum.SELECT_BY_IDS);
        HashMap paras = new HashMap();
        paras.put("ids", pks);
        return script.select(clazz, paras);
    }

    @Override
    public <T> T lock(Class<T> clazz, Object pk) {
        SQLExecutor script = this.getScript(clazz, AutoSQLEnum.LOCK_BY_ID);
        return script.single(clazz, pk);
    }

    @Override
    public <T> List<T> all(Class<T> clazz) {
        SQLExecutor script = this.getScript(clazz, AutoSQLEnum.SELECT_ALL);
        return script.select(clazz, null);
    }

    @Override
    public long allCount(Class<?> clazz) {
        SQLExecutor script = this.getScript(clazz, AutoSQLEnum.SELECT_COUNT_BY_TEMPLATE);
        return script.singleSelect(Long.class, new HashMap());
    }

    @Override
    public <T> List<T> all(Class<T> clazz, Object start, Long pageSize) {
        String sql = "select * from " + this.nc.getTableName(clazz);
        String pageSql = this.dbStyle.getRangeSql().toRange(sql, start, pageSize);
        return this.execute(new SQLReady(pageSql), clazz);
    }

    @Override
    public <T> T templateOne(T t) {
        if (t == null) {
            throw new NullPointerException();
        }
        long start = this.offsetStartZero ? 0L : 1L;
        Class<?> target = t.getClass();
        SQLExecutor script = this.getScript(target, AutoSQLEnum.SELECT_BY_TEMPLATE);
        String sqlTemplate = script.getExecuteContext().sqlSource.template;
        String pageSqlTemplate = this.dbStyle.getRangeSql().toTemplateRange(target, sqlTemplate);
        Map param = script.beforeExecute(target, t, false);
        this.dbStyle.getRangeSql().addTemplateRangeParas(param, start, 2L);
        List<?> list = this.execute(pageSqlTemplate, target, param);
        if (list.isEmpty()) {
            return null;
        }
        if (list.size() > 1) {
            throw new BeetlSQLException(12, "\u6a21\u677f\u67e5\u8be2\u671f\u671b\u53ea\u8fd4\u56de\u4e00\u6761\u7ed3\u679c\u96c6");
        }
        return (T)list.get(0);
    }

    @Override
    public <T> List<T> template(T t) {
        SQLExecutor script = this.getScript(t.getClass(), AutoSQLEnum.SELECT_BY_TEMPLATE);
        return script.select(t.getClass(), t);
    }

    @Override
    public <T> long templateCount(T t) {
        return this.templateCount(t.getClass(), t);
    }

    protected <T> long templateCount(Class<T> target, Object paras) {
        SQLExecutor script = this.getScript(target, AutoSQLEnum.SELECT_COUNT_BY_TEMPLATE);
        Long l = script.singleSelect(Long.class, paras);
        return l;
    }

    @Override
    public Long longValue(SqlId id, Object paras) {
        return this.selectSingle(id, paras, Long.class);
    }

    @Override
    public Integer intValue(SqlId id, Object paras) {
        return this.selectSingle(id, paras, Integer.class);
    }

    @Override
    public BigDecimal bigDecimalValue(SqlId id, Object paras) {
        return this.selectSingle(id, paras, BigDecimal.class);
    }

    @Override
    public <T> T selectSingle(SqlId sqlId, Object paras, Class<T> target) {
        SQLExecutor script = this.getScript(sqlId);
        return script.singleSelect(target, paras);
    }

    @Override
    public <T> T selectUnique(SqlId id, Object paras, Class<T> target) {
        SQLExecutor script = this.getScript(id);
        return script.selectUnique(target, paras);
    }

    @Override
    public <T> List<T> select(SqlId sqlId, Object paras, Class<T> clazz, Object start, long size) {
        SQLExecutor newSqlEx = this.getPageSqlScript(clazz, sqlId);
        return newSqlEx.select(clazz, paras, start, size);
    }

    @Override
    public int deleteById(Class<?> clazz, Object pkValue) {
        SQLExecutor script = this.getScript(clazz, AutoSQLEnum.DELETE_BY_ID);
        return script.deleteById(clazz, pkValue);
    }

    @Override
    public int deleteObject(Object obj) {
        Class<?> target = obj.getClass();
        SQLExecutor script = this.getScript(target, AutoSQLEnum.DELETE_TEMPLATE_BY_ID);
        return script.update(target, obj);
    }

    @Override
    public int insert(Object paras) {
        return this.insert(paras.getClass(), paras);
    }

    @Override
    public int insertTemplate(Object paras) {
        return this.insertTemplate(paras.getClass(), paras);
    }

    @Override
    public int insert(Class clazz, Object paras) {
        return this.generalInsert(clazz, paras, false);
    }

    @Override
    public int insertTemplate(Class clazz, Object paras) {
        return this.generalInsert(clazz, paras, true);
    }

    @Override
    public boolean exist(Class<?> clazz, Object pk) {
        SQLExecutor script = this.getScript(clazz, AutoSQLEnum.EXIST_BY_ID);
        return script.existById(clazz, pk);
    }

    protected int generalInsert(Class clazz, Object paras, boolean template) {
        SQLExecutor script = this.getScript(clazz, template ? AutoSQLEnum.INSERT_TEMPLATE : AutoSQLEnum.INSERT);
        return script.insert(clazz, paras);
    }

    protected void assignAutoId(Object bean, Object id) {
        Class<?> target = bean.getClass();
        String table = this.nc.getTableName(target);
        ClassDesc desc = this.metaDataManager.getTable(table).genClassDesc(target, this.nc);
        if (desc.getIdCols().isEmpty()) {
            return;
        }
        Method getterMethod = (Method)desc.getIdMethods().get(desc.getIdAttrs().get(0));
        String name = getterMethod.getName();
        String setterName = name.replaceFirst("get", "set");
        try {
            Method setterMethod = target.getMethod(setterName, getterMethod.getReturnType());
            Object value = BeanKit.convertValueToRequiredType((Object)id, getterMethod.getReturnType());
            setterMethod.invoke(bean, value);
        }
        catch (Exception ex) {
            throw new UnsupportedOperationException("autoAssignKey failure " + ex.getMessage());
        }
    }

    @Override
    public int[] insertBatch(Class clazz, List<?> list) {
        SQLExecutor script = this.getScript(clazz, AutoSQLEnum.INSERT);
        int max = this.dbStyle.getMaxBatchCount();
        int[] ret = script.insertBatch(clazz, list);
        return ret;
    }

    @Override
    public int insert(SqlId sqlId, Object paras) {
        SQLExecutor script = this.getScript(sqlId);
        return script.insert(null, paras);
    }

    @Override
    public Object[] insert(SqlId sqlId, Object paras, String[] cols) {
        SQLExecutor script = this.getScript(sqlId);
        return script.insert(null, paras, cols);
    }

    @Override
    public boolean upsert(Object obj) {
        return this.upsert(obj, false);
    }

    @Override
    public boolean upsertByTemplate(Object obj) {
        return this.upsert(obj, true);
    }

    protected boolean upsert(Object obj, boolean template) {
        Class<?> c = obj.getClass();
        String tableName = this.nc.getTableName(c);
        TableDesc table = this.metaDataManager.getTable(tableName);
        MockClassDesc classDesc = table.genClassDesc(this.nc);
        List<String> idProperties = classDesc.getIdAttrs();
        if (idProperties.size() != 1) {
            throw new BeetlSQLException(4, "upsert\u65b9\u6cd5\u671f\u671b\u53ea\u6709\u4e00\u4e2a\u4e3b\u952e");
        }
        Object pk = BeanKit.getBeanProperty((Object)obj, (String)idProperties.get(0));
        if (pk == null) {
            if (template) {
                this.insertTemplate(obj);
            } else {
                this.insert(obj);
            }
            return true;
        }
        Object dbValue = this.single(c, pk);
        if (dbValue == null) {
            if (template) {
                this.insertTemplate(obj);
            } else {
                this.insert(obj);
            }
            return true;
        }
        if (template) {
            this.updateTemplateById(obj);
        } else {
            this.updateById(obj);
        }
        return false;
    }

    @Override
    public int updateById(Object obj) {
        Class<?> target = obj.getClass();
        SQLExecutor script = this.getScript(target, AutoSQLEnum.UPDATE_BY_ID);
        return script.update(target, obj);
    }

    @Override
    public int updateTemplateById(Object obj) {
        Class<?> target = obj.getClass();
        SQLExecutor script = this.getScript(target, AutoSQLEnum.UPDATE_TEMPLATE_BY_ID);
        return script.update(target, obj);
    }

    @Override
    public int updateTemplateById(Class c, Map paras) {
        SQLExecutor script = this.getScript(c, AutoSQLEnum.UPDATE_TEMPLATE_BY_ID);
        return script.update(c, paras);
    }

    @Override
    public int updateTemplateById(Class c, Object obj) {
        SQLExecutor script = this.getScript(c, AutoSQLEnum.UPDATE_TEMPLATE_BY_ID);
        return script.update(c, obj);
    }

    @Override
    public int[] updateByIdBatch(List<?> list) {
        if (list == null || list.isEmpty()) {
            return new int[0];
        }
        Class<?> target = list.get(0).getClass();
        SQLExecutor script = this.getScript(list.get(0).getClass(), AutoSQLEnum.UPDATE_BY_ID);
        return script.updateBatch(target, list);
    }

    @Override
    public int update(SqlId sqlId, Object obj) {
        SQLExecutor script = this.getScript(sqlId);
        return script.update(null, obj);
    }

    @Override
    public int update(SqlId sqlId) {
        SQLExecutor script = this.getScript(sqlId);
        return script.update(null, null);
    }

    @Override
    public int update(SqlId sqlId, Map<String, Object> paras) {
        SQLExecutor script = this.getScript(sqlId);
        return script.update(null, paras);
    }

    @Override
    public int[] updateBatch(SqlId sqlId, List<?> list) {
        SQLExecutor script = this.getScript(sqlId);
        return script.updateBatch(list);
    }

    @Override
    public int[] updateBatchTemplateById(Class clz, List<?> list) {
        SQLExecutor script = this.getScript(clz, AutoSQLEnum.UPDATE_TEMPLATE_BY_ID);
        return script.updateBatch(list);
    }

    @Override
    public int updateAll(Class<?> clazz, Object param) {
        SQLExecutor script = this.getScript(clazz, AutoSQLEnum.UPDATE_ALL);
        return script.update(clazz, param);
    }

    @Override
    public <T> List<T> execute(String sqlTemplate, Class<T> clazz, Object paras) {
        SqlId id = this.sqlIdFactory.buildTemplate(sqlTemplate);
        SQLSource source = this.sqlLoader.querySQL(id);
        if (source == null) {
            source = new SQLSource(id, sqlTemplate);
            source.setSqlType(SQLType.SELECT);
            this.sqlLoader.addSQL(id, source);
        }
        ExecuteContext executeContext = ExecuteContext.instance(this).initSQLSource(source);
        SQLExecutor script = this.dbStyle.buildExecutor(executeContext);
        return script.select(clazz, paras);
    }

    public TableDesc getTableDesc(String table) {
        return this.metaDataManager.getTable(table);
    }

    public ClassDesc getClassDesc(Class target) {
        String table = this.nc.getTableName(target);
        TableDesc desc = this.metaDataManager.getTable(table);
        return desc.genClassDesc(target, this.nc);
    }

    @Override
    public <T> List<T> execute(String sqlTemplate, Class<T> clazz, Map paras) {
        SqlId id = this.sqlIdFactory.buildTemplate(sqlTemplate);
        SQLSource source = this.sqlLoader.querySQL(id);
        if (source == null) {
            source = new SQLSource(id, sqlTemplate);
            source.setSqlType(SQLType.SELECT);
            this.sqlLoader.addSQL(id, source);
        }
        ExecuteContext executeContext = ExecuteContext.instance(this).initSQLSource(source);
        SQLExecutor script = this.dbStyle.buildExecutor(executeContext);
        return script.select(clazz, paras);
    }

    @Override
    public <T> List<T> execute(String sqlTemplate, Class<T> clazz, Object paras, Object start, long size) {
        SqlId id = this.sqlIdFactory.buildTemplate(sqlTemplate).toPage();
        SQLSource source = this.sqlLoader.querySQL(id);
        if (source == null) {
            String pageSql = this.dbStyle.getRangeSql().toTemplateRange(clazz, sqlTemplate);
            source = new SQLSource(id, pageSql);
            source.setSqlType(SQLType.SELECT);
            this.sqlLoader.addSQL(id, source);
        }
        HashMap<String, Object> pageParas = new HashMap<String, Object>();
        this.dbStyle.getRangeSql().addTemplateRangeParas(pageParas, start, size);
        ExecuteContext executeContext = ExecuteContext.instance(this).initSQLSource(source);
        SQLExecutor script = this.dbStyle.buildExecutor(executeContext);
        Map map = script.beforeExecute(clazz, paras, false);
        map.putAll(pageParas);
        return script.select(clazz, map);
    }

    @Override
    public <T> PageResult<T> executePageQuery(String sqlTemplate, Class<T> clazz, Object paras, PageRequest<T> request) {
        SqlId id = this.sqlIdFactory.buildTemplate(sqlTemplate);
        SQLSource source = this.sqlLoader.querySQL(id);
        if (source == null) {
            source = new SQLSource(id, sqlTemplate);
            source.setSqlType(SQLType.SELECT);
            this.sqlLoader.addSQL(id, source);
        }
        return this.pageQuery(id, clazz, paras, request);
    }

    @Override
    public int executeUpdate(String sqlTemplate, Object paras) {
        SqlId id = this.sqlIdFactory.buildTemplate(sqlTemplate);
        SQLSource source = this.sqlLoader.querySQL(id);
        if (source == null) {
            source = new SQLSource(id, sqlTemplate);
            source.setSqlType(SQLType.UPDATE);
            this.sqlLoader.addSQL(id, source);
        }
        ExecuteContext executeContext = ExecuteContext.instance(this).initSQLSource(source);
        SQLExecutor script = this.dbStyle.buildExecutor(executeContext);
        return script.update(null, paras);
    }

    @Override
    public <T> List<T> execute(SQLReady p, Class<T> clazz) {
        SqlId id = this.sqlIdFactory.buildSql(p.getSql());
        return this.executeWithId(id, p, clazz);
    }

    @Override
    public <T> T executeQueryOne(SQLReady p, Class<T> clazz) {
        SqlId id = this.sqlIdFactory.buildSql(p.getSql());
        List<T> list = this.executeWithId(id, p, clazz);
        if (list.isEmpty()) {
            return null;
        }
        if (list.size() == 1) {
            return list.get(0);
        }
        throw new BeetlSQLException(12, "unique\u67e5\u8be2\uff0c\u627e\u5230\u591a\u6761\u8bb0\u5f55 " + list.size());
    }

    private <T> List<T> executeWithId(SqlId id, SQLReady p, Class<T> clazz) {
        SQLSource source = new SQLSource(id, p.getSql());
        ExecuteContext executeContext = ExecuteContext.instance(this).initSQLSource(source);
        SQLExecutor script = this.dbStyle.buildExecutor(executeContext);
        return script.sqlReadySelect(clazz, p);
    }

    @Override
    public <T> PageResult<T> execute(SQLReady p, Class<T> clazz, PageRequest<T> pageRequest) {
        String countSql;
        List<Long> countList;
        String sql = p.getSql();
        Long count = null;
        List<Object> list = null;
        if (pageRequest.isTotalRequired() && ((count = (countList = this.execute(new SQLReady(countSql = PageKit.getCountSql((String)sql), p.getArgs()), Long.class)).get(0)) == null || count == 0L)) {
            list = new ArrayList();
            return pageRequest.of(list, 0L);
        }
        long pageSize = pageRequest.getPageSize();
        Object offset = pageRequest.getStart(this.offsetStartZero);
        String pageSql = this.dbStyle.getRangeSql().toRange(sql, offset, pageSize);
        SqlId id = this.sqlIdFactory.buildSql(p.getSql());
        id.type = SqlId.Type.page;
        list = this.executeWithId(id, new SQLReady(pageSql, p.getArgs()), clazz);
        return pageRequest.isTotalRequired() ? pageRequest.of(list, count) : pageRequest.of(list);
    }

    @Override
    public int executeUpdate(SQLReady p) {
        SqlId id = this.sqlIdFactory.buildSql(p.getSql());
        SQLSource source = new SQLSource(id, p.getSql());
        source.setSqlType(SQLType.UPDATE);
        ExecuteContext executeContext = ExecuteContext.instance(this).initSQLSource(source);
        SQLExecutor script = this.dbStyle.buildExecutor(executeContext);
        return script.sqlReadyExecuteUpdate(p);
    }

    @Override
    public int[] executeBatchUpdate(SQLBatchReady batch) {
        SqlId id = this.sqlIdFactory.buildSql(batch.getSql());
        SQLSource source = new SQLSource(id, batch.getSql());
        source.setSqlType(SQLType.UPDATE);
        ExecuteContext executeContext = ExecuteContext.instance(this).initSQLSource(source);
        SQLExecutor script = this.dbStyle.buildExecutor(executeContext);
        return script.sqlReadyBatchExecuteUpdate(batch);
    }

    public <T> T executeOnConnection(OnConnection<T> onConnection) {
        Connection conn = null;
        onConnection.setSqlManagaer(this);
        try {
            conn = onConnection.getConn(this.getDs());
            T t = onConnection.call(conn);
            return t;
        }
        catch (SQLException e) {
            throw new BeetlSQLException(1, (Throwable)e);
        }
        finally {
            if (!this.getDs().isTransaction()) {
                try {
                    if (!conn.getAutoCommit()) {
                        conn.commit();
                    }
                    conn.close();
                }
                catch (SQLException e) {
                    throw new BeetlSQLException(1, (Throwable)e);
                }
            }
        }
    }

    public SQLLoader getSqlLoader() {
        return this.sqlLoader;
    }

    public void setSqlLoader(SQLLoader sqlLoader) {
        this.sqlLoader = sqlLoader;
    }

    public ConnectionSource getDs() {
        return this.ds;
    }

    public void setDs(ConnectionSource ds) {
        this.ds = ds;
    }

    public NameConversion getNc() {
        return this.nc;
    }

    public void setNc(NameConversion nc) {
        this.nc = nc;
        this.dbStyle.setNameConversion(nc);
    }

    public DBStyle getDbStyle() {
        return this.dbStyle;
    }

    public SQLTemplateEngine getSqlTemplateEngine() {
        return this.sqlTemplateEngine;
    }

    public MetadataManager getMetaDataManager() {
        return this.metaDataManager;
    }

    public Interceptor[] getInters() {
        return this.inters;
    }

    public void setInters(Interceptor[] inters) {
        this.inters = inters;
    }

    public void addIdAutonGen(String name, IDAutoGen alorithm) {
        this.idAutonGenMap.put(name, alorithm);
    }

    protected Object getAssignIdByIdAutonGen(String name, String param, String table) {
        IDAutoGen idGen = this.idAutonGenMap.get(name);
        if (idGen == null) {
            throw new BeetlSQLException(15, "\u672a\u53d1\u73b0\u81ea\u52a8id\u751f\u6210\u5668:" + name + " in " + table);
        }
        return idGen.nextID(param);
    }

    public Map<String, BeanProcessor> getProcessors() {
        return this.processors;
    }

    public void setProcessors(Map<String, BeanProcessor> processors) {
        this.processors = processors;
    }

    public BeanProcessor getDefaultBeanProcessors() {
        return this.defaultBeanProcessors;
    }

    public void setDefaultBeanProcessors(BeanProcessor defaultBeanProcessors) {
        this.defaultBeanProcessors = defaultBeanProcessors;
    }

    public <T> T getMapper(Class<T> mapperInterface) {
        return this.mapperBuilder.getMapper(mapperInterface);
    }

    public ClassLoaderKit getClassLoaderKit() {
        if (this.classLoaderKit == null) {
            this.classLoaderKit = new ClassLoaderKit();
        }
        return this.classLoaderKit;
    }

    public void setClassLoaderKit(ClassLoaderKit classLoaderKit) {
        this.classLoaderKit = classLoaderKit;
    }

    public void addVirtualTable(String realTable, String virtualTable) {
        this.metaDataManager.addTableVirtual(realTable, virtualTable);
    }

    public void setDbStyle(DBStyle dbStyle) {
        this.dbStyle = dbStyle;
    }

    public void setMetaDataManager(MetadataManager metaDataManager) {
        this.metaDataManager = metaDataManager;
    }

    public SqlIdFactory getSqlIdFactory() {
        return this.sqlIdFactory;
    }

    public void setSqlIdFactory(SqlIdFactory sqlIdFactory) {
        this.sqlIdFactory = sqlIdFactory;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public boolean isProduct() {
        return this.isProduct;
    }

    public void setProduct(boolean product) {
        this.isProduct = product;
    }

    public void setSQLTemplateEngine(SQLTemplateEngine sqlTemplateEngine) {
        this.sqlTemplateEngine = sqlTemplateEngine;
    }

    public SQLManager use(String name) {
        throw new UnsupportedOperationException("\u9700\u8981\u4f7f\u7528MultipleSQLManager\u5b50\u7c7b");
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void register() {
        if (this.getName() == null) {
            throw new IllegalStateException("\u5fc5\u987b\u8bbe\u5b9a\u4e00\u4e2a\u540d\u5b57 ");
        }
        SQLManagerBuilder.sqlManagerMap.put(this.getName(), this);
    }

    public void addSqlManagerInGroup(String name, SQLManager sqlManager) {
        this.group.put(name, sqlManager);
    }

    public SQLManager sqlManagerInGroup(String name) {
        return this.group.get(name);
    }
}

