/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Random;
import javax.sql.DataSource;
import org.beetl.sql.clazz.kit.BeetlSQLException;
import org.beetl.sql.core.ConnectionSource;
import org.beetl.sql.core.DSTransactionManager;
import org.beetl.sql.core.ExecuteContext;

public class DefaultConnectionSource
implements ConnectionSource {
    protected DataSource master = null;
    protected DataSource[] slaves = null;

    public DefaultConnectionSource() {
    }

    public DefaultConnectionSource(DataSource master, DataSource[] slaves) {
        this.master = master;
        this.slaves = slaves;
    }

    @Override
    public Connection getConn(ExecuteContext ctx, boolean isUpdate) {
        if (this.slaves == null || this.slaves.length == 0) {
            return this.getWriteConn(ctx);
        }
        if (isUpdate) {
            return this.getWriteConn(ctx);
        }
        return this.getReadConn(ctx);
    }

    @Override
    public Connection getMasterConn() {
        return this.doGetConnection(this.master);
    }

    protected Connection getReadConn(ExecuteContext ctx) {
        if (this.slaves == null || this.slaves.length == 0) {
            return this.getWriteConn(ctx);
        }
        return this.nextSlaveConn();
    }

    protected Connection getWriteConn(ExecuteContext ctx) {
        return this.doGetConnection(this.master);
    }

    protected Connection nextSlaveConn() {
        DataSource ds = this.slaves[new Random().nextInt(this.slaves.length)];
        return this.doGetConnection(ds);
    }

    protected Connection doGetConnection(DataSource ds) {
        try {
            if (DSTransactionManager.inTrans()) {
                return DSTransactionManager.getCurrentThreadConnection(ds);
            }
            return ds.getConnection();
        }
        catch (SQLException e) {
            throw new BeetlSQLException(0, (Throwable)e);
        }
    }

    public DataSource getMasterSource() {
        return this.master;
    }

    public void setMasterSource(DataSource master) {
        this.master = master;
    }

    @Override
    public boolean isTransaction() {
        return DSTransactionManager.inTrans();
    }

    @Override
    public Connection getMetaData() {
        return this.getMasterConn();
    }

    public DataSource[] getSlaves() {
        return this.slaves;
    }
}

