/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.ext;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.beetl.sql.core.Interceptor;
import org.beetl.sql.core.InterceptorContext;
import org.beetl.sql.core.kit.EnumKit;

public class DebugInterceptor
implements Interceptor {
    List<String> includes = null;

    public DebugInterceptor() {
    }

    public DebugInterceptor(List<String> includes) {
        this.includes = includes;
    }

    @Override
    public void before(InterceptorContext ctx) {
        String sqlId = ctx.getSqlId();
        if (this.isDebugEanble(sqlId)) {
            ctx.put("debug.time", System.currentTimeMillis());
        }
        this.print(sqlId, ctx.getSql(), ctx.getParas());
        RuntimeException ex = new RuntimeException();
        StackTraceElement[] traces = ex.getStackTrace();
        boolean found = false;
        for (StackTraceElement tr : traces) {
            if (!found && tr.getClassName().indexOf("SQLManager") != -1) {
                found = true;
            }
            if (!found || tr.getClassName().startsWith("org.beetl.sql.core") || tr.getClassName().startsWith("com.sun")) continue;
            String className = tr.getClassName();
            String mehodName = tr.getMethodName();
            int line = tr.getLineNumber();
            this.println("location:" + className + "." + mehodName + " " + line);
            break;
        }
    }

    @Override
    public void after(InterceptorContext ctx) {
        long time = System.currentTimeMillis();
        long start = (Long)ctx.get("debug.time");
        StringBuilder sb = new StringBuilder();
        sb.append("======DebugInterceptor After======\n").append("sqlId : " + ctx.getSqlId()).append("\n").append("execution time : " + (time - start) + "ms").append("\n");
        if (ctx.isUpdate()) {
            sb.append("\u6210\u529f\u66f4\u65b0[");
            if (ctx.getResult().getClass().isArray()) {
                int[] ret = (int[])ctx.getResult();
                for (int i = 0; i < ret.length; ++i) {
                    sb.append(ret[i]);
                    if (i == ret.length - 1) continue;
                    sb.append(",");
                }
            } else {
                sb.append(ctx.getResult());
            }
            sb.append("]");
        } else {
            sb.append("\u6210\u529f\u8fd4\u56de[").append(ctx.getResult()).append("]");
        }
        sb.append("\n");
        this.println(sb.toString());
    }

    protected void print(String sqlId, String sql, List<Object> paras) {
        StringBuilder sb = new StringBuilder();
        sb.append("======DebugInterceptor Before======\n").append("sqlId : " + sqlId).append("\n").append("sql \uff1a " + sql).append("\nparas : " + this.formatParas(paras));
        this.println(sb.toString());
    }

    protected boolean isDebugEanble(String sqlId) {
        if (this.includes == null) {
            return true;
        }
        for (String id : this.includes) {
            if (!sqlId.startsWith(id)) continue;
            return true;
        }
        return false;
    }

    protected List<String> formatParas(List<Object> list) {
        ArrayList<String> data = new ArrayList<String>(list.size());
        for (Object obj : list) {
            if (obj == null) {
                data.add(null);
                continue;
            }
            if (obj instanceof String) {
                String str = (String)obj;
                if (str.length() > 20) {
                    data.add(str.substring(0, 20) + "...(" + str.length() + ")");
                    continue;
                }
                data.add(str);
                continue;
            }
            if (obj instanceof Date) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
                data.add(sdf.format((Date)obj));
                continue;
            }
            if (obj instanceof Enum) {
                Object value = EnumKit.getValueByEnum(obj);
                data.add(String.valueOf(value));
                continue;
            }
            data.add(obj.toString());
        }
        return data;
    }

    protected void println(String str) {
        System.out.println(str);
    }
}

