/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core.orm;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.beetl.core.om.MethodInvoker;
import org.beetl.core.om.ObjectUtil;
import org.beetl.sql.core.SQLManager;
import org.beetl.sql.core.Tail;
import org.beetl.sql.core.kit.BeanKit;
import org.beetl.sql.core.kit.StringKit;

public class MappingEntity {
    private String target;
    private boolean isSingle = false;
    Map<String, String> mapkey;
    String sqlId = null;
    String tailName;
    boolean absentPackage = false;
    Class targetClass = null;
    Map<String, Method> setMethod = new HashMap<String, Method>();

    public void map(List list, SQLManager sm) {
        if (list.size() == 0) {
            return;
        }
        this.init(list.get(0));
        for (Object obj : list) {
            this.mapClassItem(obj, sm);
        }
    }

    private void init(Object obj) {
        if (this.target.indexOf(".") == -1) {
            this.tailName = StringKit.toLowerCaseFirstOne(this.target);
            this.absentPackage = true;
        } else {
            int index = this.target.lastIndexOf(".");
            String className = this.target.substring(index + 1);
            this.tailName = StringKit.toLowerCaseFirstOne(className);
        }
    }

    private void mapClassItem(Object obj, SQLManager sm) {
        if (this.targetClass == null) {
            String fullName = this.absentPackage ? obj.getClass().getPackage().getName() + "." + this.target : this.target;
            this.targetClass = this.getCls(fullName);
        }
        List<Object> ret = null;
        if (this.sqlId != null) {
            HashMap<String, Object> paras = new HashMap<String, Object>();
            for (Map.Entry<String, String> entry : this.mapkey.entrySet()) {
                String attr = entry.getKey();
                String targetAttr = entry.getValue();
                Object value = this.getBeanProperty(obj, attr);
                paras.put(targetAttr, value);
            }
            ret = sm.select(this.sqlId, this.targetClass, paras);
        } else {
            Object ins = this.getIns(this.targetClass);
            for (Map.Entry<String, String> entry : this.mapkey.entrySet()) {
                String attr = entry.getKey();
                String targetAttr = entry.getValue();
                Object value = this.getBeanProperty(obj, attr);
                this.setBeanProperty(ins, value, targetAttr);
            }
            ret = sm.template(ins);
        }
        if (!this.isSingle) {
            this.setTailAttr(obj, ret.get(0));
        } else {
            this.setTailAttr(obj, ret);
        }
    }

    private Object getBeanProperty(Object o, String attrName) {
        try {
            MethodInvoker inv = ObjectUtil.getInvokder(o.getClass(), (String)attrName);
            return inv.get(o);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private void setBeanProperty(Object o, Object value, String attrName) {
        Method m = this.setMethod.get(attrName);
        if (m == null) {
            try {
                Class<?> t = o.getClass();
                MethodInvoker inv = ObjectUtil.getInvokder(t, (String)attrName);
                String getterName = inv.getMethod().getName();
                String setterName = "s" + getterName.substring(1);
                m = t.getMethod(setterName, inv.getReturnType());
                this.setMethod.put(attrName, m);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        try {
            m.invoke(o, value);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private void setTailAttr(Object o, Object value) {
        if (o instanceof Tail) {
            ((Tail)o).set(this.tailName, value);
        } else {
            Method m = BeanKit.getTailMethod(o.getClass());
            if (m == null) {
                throw new RuntimeException("must implement tail or use @tail");
            }
            try {
                m.invoke(o, this.tailName, value);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    private Object getIns(Class cls) {
        try {
            return cls.newInstance();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private Class getCls(String fullName) {
        Class<?> cls = null;
        try {
            cls = Class.forName(fullName);
            return cls;
        }
        catch (Exception ex) {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            if (loader != null) {
                try {
                    cls = loader.loadClass(fullName);
                    return cls;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            throw new RuntimeException(ex);
        }
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public boolean isSingle() {
        return this.isSingle;
    }

    public void setSingle(boolean isSingle) {
        this.isSingle = isSingle;
    }

    public Map<String, String> getMapkey() {
        return this.mapkey;
    }

    public void setMapkey(Map<String, String> mapkey) {
        this.mapkey = mapkey;
    }

    public String getSqlId() {
        return this.sqlId;
    }

    public void setSqlId(String sqlId) {
        this.sqlId = sqlId;
    }
}

