/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core.mapping.handler;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.beetl.sql.core.BeetlSQLException;
import org.beetl.sql.core.NameConversion;
import org.beetl.sql.core.SQLManager;
import org.beetl.sql.core.mapping.BasicRowProcessor;
import org.beetl.sql.core.mapping.ResultSetHandler;
import org.beetl.sql.core.mapping.RowProcessor;

public class BeanHandler<T>
implements ResultSetHandler<T> {
    private final Class<T> type;
    private final RowProcessor convert;
    private boolean uniqueCheck = false;

    public BeanHandler(Class<T> type, NameConversion nc, SQLManager sm) {
        this(type, new BasicRowProcessor(nc, sm));
    }

    public BeanHandler(Class<T> type, NameConversion nc, SQLManager sm, boolean uniqueCheck) {
        this(type, new BasicRowProcessor(nc, sm));
        this.uniqueCheck = uniqueCheck;
    }

    protected BeanHandler(Class<T> type, RowProcessor convert) {
        this.type = type;
        this.convert = convert;
    }

    @Override
    public T handle(ResultSet rs) throws SQLException {
        if (rs.next()) {
            return this.convert.toBean(rs, this.type);
        }
        if (this.uniqueCheck) {
            throw new BeetlSQLException(12, "unique\u67e5\u8be2\uff0c\u4f46\u6570\u636e\u5e93\u672a\u627e\u5230\u7ed3\u679c\u96c6");
        }
        return null;
    }
}

