/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core.kit;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import org.beetl.sql.core.annotatoin.EnumMapping;
import org.beetl.sql.core.kit.StringKit;

public class EnumKit {
    private static Map<Class, EnumConfig> cache = new HashMap<Class, EnumConfig>();

    public static Enum getEnumByValue(Class c, Object value) {
        if (!c.isEnum()) {
            throw new IllegalArgumentException(c.getName());
        }
        EnumConfig config = cache.get(c);
        if (config == null) {
            EnumKit.init(c);
            config = cache.get(c);
        }
        Enum e = config.map.get(value);
        return e;
    }

    public static Object getValueByEnum(Object en) {
        if (en == null) {
            return null;
        }
        Class<?> c = en.getClass();
        EnumConfig config = cache.get(c);
        if (config == null) {
            EnumKit.init(c);
            config = cache.get(c);
        }
        return config.dbMap.get(en);
    }

    private static void initNoAnotation(Class c) {
        Enum[] temporaryConstants;
        HashMap<Object, Enum> map = new HashMap<Object, Enum>();
        HashMap<Enum, Object> map2 = new HashMap<Enum, Object>();
        for (Enum e : temporaryConstants = EnumKit.getEnumValues(c)) {
            String key = e.name();
            map.put(key, e);
            map2.put(e, key);
        }
        EnumConfig config = new EnumConfig(map, map2);
        cache.put(c, config);
    }

    private static void init(Class c) {
        try {
            EnumMapping db = c.getAnnotation(EnumMapping.class);
            if (db == null) {
                EnumKit.initNoAnotation(c);
            } else {
                Enum[] temporaryConstants;
                String name = db.value();
                String getter = "get" + StringKit.toUpperCaseFirstOne(name);
                Method m = c.getMethod(getter, new Class[0]);
                HashMap<Object, Enum> map = new HashMap<Object, Enum>();
                HashMap<Enum, Object> map2 = new HashMap<Enum, Object>();
                for (Enum e : temporaryConstants = EnumKit.getEnumValues(c)) {
                    Object key = m.invoke((Object)e, new Object[0]);
                    map.put(key, e);
                    map2.put(e, key);
                }
                EnumConfig config = new EnumConfig(map, map2);
                cache.put(c, config);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private static Enum[] getEnumValues(Class c) {
        try {
            final Method values = c.getMethod("values", new Class[0]);
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    values.setAccessible(true);
                    return null;
                }
            });
            Enum[] temporaryConstants = (Enum[])values.invoke(null, new Object[0]);
            return temporaryConstants;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) {
        Color c = Color.BLUE;
        Object value = EnumKit.getValueByEnum((Object)c);
        System.out.println(value);
        String a = "BLUE";
        Color e = (Color)EnumKit.getEnumByValue(Color.class, a);
        System.out.println((Object)e);
    }

    @EnumMapping(value="value")
    public static enum Color {
        RED("RED", 1),
        BLUE("BLUE", 2);

        private String name;
        private int value;

        private Color(String name, int value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int getValue() {
            return this.value;
        }

        public void setValue(int value) {
            this.value = value;
        }
    }

    public static class EnumConfig {
        Map<Object, Enum> map = new HashMap<Object, Enum>();
        Map<Enum, Object> dbMap = new HashMap<Enum, Object>();

        public EnumConfig(Map<Object, Enum> map, Map<Enum, Object> dbMap) {
            this.map = map;
            this.dbMap = dbMap;
        }
    }
}

