/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core.db;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.beetl.sql.core.NameConversion;
import org.beetl.sql.core.db.ColDesc;
import org.beetl.sql.core.db.TableDesc;
import org.beetl.sql.core.kit.BeanKit;
import org.beetl.sql.core.kit.CaseInsensitiveHashMap;
import org.beetl.sql.core.kit.CaseInsensitiveOrderSet;
import org.beetl.sql.ext.gen.JavaType;

public class ClassDesc {
    Class c;
    TableDesc table;
    NameConversion nc;
    Set<String> propertys = new CaseInsensitiveOrderSet();
    Set<String> dateTypes = new CaseInsensitiveOrderSet();
    Set<String> cols = new CaseInsensitiveOrderSet();
    List<String> idProperties = new ArrayList<String>(3);
    List<String> idCols = new ArrayList<String>(3);
    Map<String, Object> idMethods = new CaseInsensitiveHashMap();

    public ClassDesc(Class c, TableDesc table, NameConversion nc) {
        PropertyDescriptor[] ps;
        this.c = c;
        try {
            ps = BeanKit.propertyDescriptors(c);
        }
        catch (IntrospectionException e) {
            throw new RuntimeException(e);
        }
        Set<String> ids = table.getIdNames();
        this.idCols.addAll(ids);
        CaseInsensitiveHashMap tempMap = new CaseInsensitiveHashMap();
        for (PropertyDescriptor p : ps) {
            if (p.getReadMethod() == null || p.getWriteMethod() == null) continue;
            String property = p.getName();
            String col = nc.getColName(c, property);
            tempMap.put(col, (Object)p);
        }
        for (String col : table.getCols()) {
            if (!tempMap.containsKey(col)) continue;
            this.cols.add(col);
            PropertyDescriptor p = (PropertyDescriptor)tempMap.get(col);
            this.propertys.add(p.getName());
            if (!ids.contains(col)) continue;
            this.idProperties.add(p.getName());
            Method readMethod = p.getReadMethod();
            Class<?> retType = readMethod.getReturnType();
            this.idMethods.put(col, readMethod);
            if (!Date.class.isAssignableFrom(retType) && !Calendar.class.isAssignableFrom(retType)) continue;
            this.dateTypes.add(p.getName());
        }
    }

    public ClassDesc(TableDesc table, NameConversion nc) {
        this.table = table;
        this.nc = nc;
        for (String colName : table.getCols()) {
            String prop = nc.getPropertyName(colName);
            this.propertys.add(prop);
            ColDesc colDes = table.getColDesc(colName);
            if (JavaType.isDateType(colDes.sqlType)) {
                this.dateTypes.add(prop);
            }
            this.cols.add(colName);
        }
        for (String name : table.getIdNames()) {
            this.idProperties.add(nc.getPropertyName(name));
        }
    }

    public List<String> getIdAttrs() {
        return this.idProperties;
    }

    public List<String> getIdCols() {
        return this.idCols;
    }

    public Set<String> getAttrs() {
        return this.propertys;
    }

    public boolean isDateType(String property) {
        return this.dateTypes.contains(property);
    }

    public Set<String> getInCols() {
        return this.cols;
    }

    public Map<String, Object> getIdMethods() {
        return this.idMethods;
    }
}

