/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core.db;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.beetl.core.Configuration;
import org.beetl.sql.core.BeetlSQLException;
import org.beetl.sql.core.NameConversion;
import org.beetl.sql.core.SQLSource;
import org.beetl.sql.core.annotatoin.AssignID;
import org.beetl.sql.core.annotatoin.AutoID;
import org.beetl.sql.core.annotatoin.DateTemplate;
import org.beetl.sql.core.annotatoin.SeqID;
import org.beetl.sql.core.annotatoin.TableTemplate;
import org.beetl.sql.core.db.ClassDesc;
import org.beetl.sql.core.db.DBStyle;
import org.beetl.sql.core.db.MetadataManager;
import org.beetl.sql.core.db.TableDesc;
import org.beetl.sql.core.engine.Beetl;

public abstract class AbstractDBStyle
implements DBStyle {
    protected static AbstractDBStyle adbs;
    protected NameConversion nameConversion;
    protected MetadataManager metadataManager;
    public String STATEMENT_START;
    public String STATEMENT_END;
    public String HOLDER_START;
    public String HOLDER_END;
    protected String lineSeparator = System.getProperty("line.separator", "\n");
    protected boolean offsetStartZero = false;

    @Override
    public void init(Beetl beetl) {
        Configuration cf = beetl.getGroupTemplate().getConf();
        this.STATEMENT_START = cf.getStatementStart();
        this.STATEMENT_END = cf.getStatementEnd();
        if (this.STATEMENT_END == null || this.STATEMENT_END.length() == 0) {
            this.STATEMENT_END = this.lineSeparator;
        }
        this.HOLDER_START = cf.getPlaceholderStart();
        this.HOLDER_END = cf.getPlaceholderEnd();
        this.offsetStartZero = Boolean.parseBoolean(beetl.getPs().getProperty("OFFSET_START_ZERO").trim());
    }

    public String getSTATEMENTSTART() {
        return this.STATEMENT_START;
    }

    public String getSTATEMENTEND() {
        return this.STATEMENT_END;
    }

    @Override
    public NameConversion getNameConversion() {
        return this.nameConversion;
    }

    @Override
    public void setNameConversion(NameConversion nameConversion) {
        this.nameConversion = nameConversion;
    }

    @Override
    public MetadataManager getMetadataManager() {
        return this.metadataManager;
    }

    @Override
    public void setMetadataManager(MetadataManager metadataManager) {
        this.metadataManager = metadataManager;
    }

    @Override
    public SQLSource genSelectById(Class<?> cls) {
        String tableName = this.nameConversion.getTableName(cls);
        TableDesc table = this.metadataManager.getTable(tableName);
        String condition = this.appendIdCondition(cls);
        return new SQLSource("select * from " + this.getTableName(table) + condition);
    }

    @Override
    public SQLSource genSelectByTemplate(Class<?> cls) {
        String tableName = this.nameConversion.getTableName(cls);
        TableDesc table = this.metadataManager.getTable(tableName);
        String condition = this.getSelectTemplate(cls);
        String appendSql = "";
        TableTemplate t = cls.getAnnotation(TableTemplate.class);
        if (t != null && ((appendSql = t.value()) == null || appendSql.length() == 0) && table.getIdNames().size() != 0) {
            appendSql = " order by ";
            Set<String> ids = table.getIdNames();
            int i = 0;
            for (String id : ids) {
                appendSql = appendSql + id + " desc";
                if (i == ids.size() - 1) break;
                appendSql = appendSql + " , ";
            }
        }
        String sql = "select * from " + this.getTableName(table) + condition + appendSql;
        return new SQLSource(sql);
    }

    @Override
    public SQLSource genSelectCountByTemplate(Class<?> cls) {
        String tableName = this.nameConversion.getTableName(cls);
        TableDesc table = this.metadataManager.getTable(tableName);
        String condition = this.getSelectTemplate(cls);
        return new SQLSource("select count(1) from " + this.getTableName(table) + condition);
    }

    private String getSelectTemplate(Class<?> cls) {
        String condition = " where 1=1 " + this.lineSeparator;
        String tableName = this.nameConversion.getTableName(cls);
        TableDesc table = this.metadataManager.getTable(tableName);
        ClassDesc classDesc = table.getClassDesc(cls, this.nameConversion);
        Iterator<String> cols = classDesc.getInCols().iterator();
        Iterator<String> attrs = classDesc.getAttrs().iterator();
        while (cols.hasNext() && attrs.hasNext()) {
            String col = cols.next();
            String attr = attrs.next();
            if (classDesc.isDateType(col)) {
                String getter = "get" + col.substring(0, 1).toUpperCase() + col.substring(1);
                try {
                    Method m = cls.getMethod(getter, new Class[0]);
                    DateTemplate dateTemplate = m.getAnnotation(DateTemplate.class);
                    if (dateTemplate == null) continue;
                    String sql = this.genDateAnnotatonSql(dateTemplate, cls, col);
                    condition = condition + sql;
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException("\u83b7\u53d6metod\u51fa\u9519" + e.getMessage());
                }
            }
            condition = condition + this.appendWhere(cls, table, col, attr);
        }
        return condition;
    }

    @Override
    public SQLSource genDeleteById(Class<?> cls) {
        String tableName = this.nameConversion.getTableName(cls);
        TableDesc table = this.metadataManager.getTable(tableName);
        String condition = this.appendIdCondition(cls);
        return new SQLSource("delete from " + this.getTableName(table) + condition);
    }

    @Override
    public SQLSource genSelectAll(Class<?> cls) {
        String tableName = this.nameConversion.getTableName(cls);
        TableDesc table = this.metadataManager.getTable(tableName);
        tableName = table.getName();
        return new SQLSource("select * from " + this.getTableName(table));
    }

    @Override
    public SQLSource genUpdateById(Class<?> cls) {
        String tableName = this.nameConversion.getTableName(cls);
        TableDesc table = this.metadataManager.getTable(tableName);
        ClassDesc classDesc = table.getClassDesc(cls, this.nameConversion);
        StringBuilder sql = new StringBuilder("update ").append(this.getTableName(table)).append(" set ").append(this.lineSeparator);
        Iterator<String> cols = classDesc.getInCols().iterator();
        Iterator<String> properties = classDesc.getAttrs().iterator();
        List<String> idCols = classDesc.getIdCols();
        while (cols.hasNext() && properties.hasNext()) {
            String col = cols.next();
            String prop = properties.next();
            if (idCols.contains(col)) continue;
            sql.append(this.appendSetColumnAbsolute(cls, table, col, prop));
        }
        String condition = this.appendIdCondition(cls);
        sql = this.removeComma(sql, condition);
        return new SQLSource(sql.toString());
    }

    @Override
    public SQLSource genUpdateTemplate(Class<?> cls) {
        String tableName = this.nameConversion.getTableName(cls);
        TableDesc table = this.metadataManager.getTable(tableName);
        ClassDesc classDesc = table.getClassDesc(cls, this.nameConversion);
        StringBuilder sql = new StringBuilder("update ").append(this.getTableName(table)).append(" set ").append(this.lineSeparator);
        String condition = this.appendIdCondition(cls);
        Iterator<String> cols = classDesc.getInCols().iterator();
        Iterator<String> properties = classDesc.getAttrs().iterator();
        List<String> idCols = classDesc.getIdCols();
        while (cols.hasNext() && properties.hasNext()) {
            String col = cols.next();
            String prop = properties.next();
            if (idCols.contains(col)) continue;
            sql.append(this.appendSetColumn(cls, table, col, prop));
        }
        StringBuilder trimSql = new StringBuilder();
        trimSql.append(this.getSTATEMENTSTART()).append("trim(){\n").append(this.getSTATEMENTEND()).append("\n").append((CharSequence)sql);
        trimSql.append(this.getSTATEMENTSTART()).append("}\n").append(this.getSTATEMENTEND());
        sql = this.removeComma(trimSql, condition);
        if (condition == null) {
            throw new BeetlSQLException(4, "\u65e0\u6cd5\u751f\u6210sql\u8bed\u53e5\uff0c\u7f3a\u5c11\u4e3b\u952e");
        }
        return new SQLSource(sql.toString());
    }

    @Override
    public SQLSource genUpdateAll(Class<?> cls) {
        String tableName = this.nameConversion.getTableName(cls);
        TableDesc table = this.metadataManager.getTable(tableName);
        ClassDesc classDesc = table.getClassDesc(cls, this.nameConversion);
        StringBuilder sql = new StringBuilder("update ").append(this.getTableName(table)).append(" set ").append(this.lineSeparator);
        Iterator<String> cols = classDesc.getInCols().iterator();
        Iterator<String> properties = classDesc.getAttrs().iterator();
        List<String> idCols = classDesc.getIdCols();
        while (cols.hasNext() && properties.hasNext()) {
            String col = cols.next();
            String prop = properties.next();
            if (idCols.contains(col)) continue;
            sql.append(this.appendSetColumn(cls, table, col, prop));
        }
        sql = this.removeComma(sql, null);
        return new SQLSource(sql.toString());
    }

    @Override
    public SQLSource genInsert(Class<?> cls) {
        String tableName = this.nameConversion.getTableName(cls);
        TableDesc table = this.metadataManager.getTable(tableName);
        ClassDesc classDesc = table.getClassDesc(cls, this.nameConversion);
        StringBuilder sql = new StringBuilder("insert into " + this.getTableName(table) + this.lineSeparator);
        StringBuilder colSql = new StringBuilder("(");
        StringBuilder valSql = new StringBuilder(" VALUES (");
        int idType = 1;
        SQLSource source = new SQLSource();
        Iterator<String> cols = classDesc.getInCols().iterator();
        Iterator<String> attrs = classDesc.getAttrs().iterator();
        List<String> idCols = classDesc.getIdCols();
        while (cols.hasNext() && attrs.hasNext()) {
            String col = cols.next();
            String attr = attrs.next();
            if (idCols.size() == 1 && idCols.contains(col)) {
                idType = this.getIdType((Method)classDesc.getIdMethods().get(col));
                if (idType == 2) continue;
                if (idType == 3) {
                    colSql.append(this.appendInsertColumn(cls, table, col));
                    SeqID seqId = ((Method)classDesc.getIdMethods().get(col)).getAnnotation(SeqID.class);
                    valSql.append(seqId.name() + ".nextval,");
                    continue;
                }
                if (idType == 1) {
                    // empty if block
                }
            }
            colSql.append(this.appendInsertColumn(cls, table, col));
            valSql.append(this.appendInsertVlaue(cls, table, attr));
        }
        sql.append(this.removeComma(colSql, null).append(")").append((CharSequence)this.removeComma(valSql, null)).append(")").toString());
        source.setTemplate(sql.toString());
        source.setIdType(idType);
        source.setTableDesc(table);
        if (idType == 1) {
            HashMap<String, AssignID> map = new HashMap<String, AssignID>();
            for (String idAttr : idCols) {
                AssignID assignId = ((Method)classDesc.getIdMethods().get(idAttr)).getAnnotation(AssignID.class);
                if (assignId == null || assignId.value().length() == 0) continue;
                map.put(idAttr, assignId);
            }
            if (map.size() != 0) {
                source.setAssignIds(map);
            }
        }
        return source;
    }

    @Override
    public String genColumnList(String table) {
        Set<String> colSet = this.getCols(table);
        if (null == colSet || colSet.isEmpty()) {
            return "";
        }
        StringBuilder cols = new StringBuilder();
        for (String col : colSet) {
            cols.append(col).append(",");
        }
        return cols.deleteCharAt(cols.length() - 1).toString();
    }

    @Override
    public Set<String> getCols(String tableName) {
        TableDesc table = this.metadataManager.getTable(tableName);
        return table.getCols();
    }

    @Override
    public String genCondition(String tableName) {
        TableDesc table = this.metadataManager.getTable(tableName);
        ClassDesc classDesc = table.getClassDesc(this.nameConversion);
        Set<String> attrSet = classDesc.getAttrs();
        if (null == attrSet || attrSet.isEmpty()) {
            return "";
        }
        Iterator<String> attrIt = attrSet.iterator();
        Iterator<String> colIt = table.getCols().iterator();
        StringBuilder condition = new StringBuilder();
        Set<String> colsIds = table.getIdNames();
        while (colIt.hasNext() && attrIt.hasNext()) {
            String col = colIt.next();
            String attr = attrIt.next();
            if (colsIds.contains(col)) continue;
            condition.append(this.appendWhere(null, table, col, attr));
        }
        return "1 = 1  \n" + condition.toString();
    }

    @Override
    public String genColAssignProperty(String tableName) {
        TableDesc table = this.metadataManager.getTable(tableName);
        ClassDesc classDesc = table.getClassDesc(this.nameConversion);
        Iterator<String> cols = classDesc.getInCols().iterator();
        Iterator<String> properties = classDesc.getAttrs().iterator();
        StringBuilder sql = new StringBuilder();
        while (cols.hasNext() && properties.hasNext()) {
            String col = cols.next();
            String prop = properties.next();
            sql.append(this.appendSetColumn(null, table, col, prop));
        }
        return sql.deleteCharAt(sql.length() - 1).toString();
    }

    @Override
    public String genColAssignPropertyAbsolute(String tableName) {
        TableDesc table = this.metadataManager.getTable(tableName);
        ClassDesc classDesc = table.getClassDesc(this.nameConversion);
        Set<String> colSet = classDesc.getInCols();
        Set<String> properties = classDesc.getAttrs();
        if (null == colSet || colSet.isEmpty()) {
            return "";
        }
        StringBuilder sql = new StringBuilder();
        Iterator<String> colIt = colSet.iterator();
        Iterator<String> propertiesIt = properties.iterator();
        while (colIt.hasNext() && propertiesIt.hasNext()) {
            String col = colIt.next();
            String prop = propertiesIt.next();
            sql.append(this.appendSetColumnAbsolute(null, table, col, prop));
        }
        return sql.deleteCharAt(sql.length() - 1).toString();
    }

    @Override
    public String getEscapeForKeyWord() {
        return "\"";
    }

    protected StringBuilder removeComma(StringBuilder sql, String condition) {
        return sql.deleteCharAt(sql.lastIndexOf(",")).append(condition == null ? "" : condition);
    }

    private String appendSetColumnAbsolute(Class<?> c, TableDesc table, String colName, String fieldName) {
        return this.getEscapeForKeyWord() + colName + this.getEscapeForKeyWord() + "=" + this.HOLDER_START + fieldName + this.HOLDER_END + ",";
    }

    private String appendSetColumn(Class<?> c, TableDesc table, String colName, String fieldName) {
        String prefix = "";
        return this.STATEMENT_START + "if(!isEmpty(" + prefix + fieldName + ")){" + this.STATEMENT_END + "\t" + this.getEscapeForKeyWord() + colName + this.getEscapeForKeyWord() + "=" + this.HOLDER_START + prefix + fieldName + this.HOLDER_END + "," + this.lineSeparator + this.STATEMENT_START + "}" + this.STATEMENT_END;
    }

    private String appendWhere(Class<?> c, TableDesc table, String colName, String fieldName) {
        String prefix = "";
        String connector = " and ";
        return this.STATEMENT_START + "if(!isEmpty(" + prefix + fieldName + ")){" + this.STATEMENT_END + connector + this.getEscapeForKeyWord() + colName + this.getEscapeForKeyWord() + "=" + this.HOLDER_START + prefix + fieldName + this.HOLDER_END + this.lineSeparator + this.STATEMENT_START + "}" + this.STATEMENT_END;
    }

    protected String appendInsertColumn(Class<?> c, TableDesc table, String colName) {
        return this.getEscapeForKeyWord() + colName + this.getEscapeForKeyWord() + ",";
    }

    protected String appendInsertVlaue(Class<?> c, TableDesc table, String fieldName) {
        return this.HOLDER_START + fieldName + this.HOLDER_END + ",";
    }

    private String appendIdCondition(Class<?> cls) {
        String tableName = this.nameConversion.getTableName(cls);
        String condition = null;
        TableDesc table = this.metadataManager.getTable(tableName);
        ClassDesc classDesc = table.getClassDesc(cls, this.nameConversion);
        condition = " where 1=1";
        Set<String> colIds = table.getIdNames();
        List<String> propertieIds = classDesc.getIdAttrs();
        this.checkId(colIds, propertieIds, cls.getName());
        Iterator<String> colIt = colIds.iterator();
        Iterator<String> propertieIt = propertieIds.iterator();
        while (colIt.hasNext() && propertieIt.hasNext()) {
            String colId = colIt.next();
            String properId = propertieIt.next();
            condition = condition + " and " + this.getEscapeForKeyWord() + colId + this.getEscapeForKeyWord() + "= " + this.HOLDER_START + properId + this.HOLDER_END;
        }
        return condition;
    }

    private boolean isLegalSelectMethod(Method method) {
        return method.getDeclaringClass() != Object.class && (method.getName().startsWith("get") || method.getName().startsWith("is")) && !Date.class.isAssignableFrom(method.getReturnType()) && !Calendar.class.isAssignableFrom(method.getReturnType());
    }

    private boolean isLegalOtherMethod(Method method) {
        return method.getDeclaringClass() != Object.class && (method.getName().startsWith("get") || method.getName().startsWith("is")) && method.getParameterTypes().length == 0;
    }

    private String genDateAnnotatonSql(DateTemplate t, Class c, String col) {
        String accept = t.accept();
        String[] vars = null;
        if (accept == null || accept.length() == 0) {
            String col1 = col.substring(0, 1).toUpperCase() + col.substring(1);
            vars = new String[]{"min" + col1, "max" + col1};
        } else {
            vars = t.accept().split(",");
        }
        String[] comp = null;
        String compare = t.compare();
        comp = compare == null || compare.length() == 0 ? new String[]{">=", "<"} : t.accept().split(",");
        t.compare().split(",");
        String prefix = "";
        String connector = " and ";
        String sql = this.STATEMENT_START + "if(!isEmpty(" + prefix + vars[0] + ")){" + this.STATEMENT_END + connector + col + comp[0] + this.HOLDER_START + vars[0] + this.HOLDER_END + this.lineSeparator + this.STATEMENT_START + "}" + this.STATEMENT_END;
        sql = sql + this.STATEMENT_START + "if(!isEmpty(" + prefix + vars[1] + ")){" + this.STATEMENT_END + connector + col + comp[1] + this.HOLDER_START + vars[1] + this.HOLDER_END + this.lineSeparator + this.STATEMENT_START + "}" + this.STATEMENT_END;
        return sql;
    }

    protected String getTableName(TableDesc desc) {
        if (desc.getSchema() != null) {
            return this.getEscapeForKeyWord() + desc.getSchema() + this.getEscapeForKeyWord() + "." + this.getEscapeForKeyWord() + desc.getName() + this.getEscapeForKeyWord();
        }
        return this.getEscapeForKeyWord() + desc.getName() + this.getEscapeForKeyWord();
    }

    protected void checkId(Collection colsId, Collection attrsId, String clsName) {
        if (colsId.size() == 0 || attrsId.size() == 0) {
            throw new BeetlSQLException(7, "PRIMARY KEY NOT FOUND IN " + clsName);
        }
    }

    protected String getOrderBy() {
        return this.lineSeparator + this.HOLDER_START + "text(has(_orderBy)?' order by '+_orderBy)" + this.HOLDER_END + " ";
    }

    @Override
    public int getIdType(Method idMethod) {
        Annotation[] ans = idMethod.getAnnotations();
        int idType = 2;
        for (Annotation an : ans) {
            if (an instanceof AutoID) {
                idType = 2;
                break;
            }
            if (an instanceof SeqID || !(an instanceof AssignID)) continue;
            idType = 1;
        }
        return idType;
    }
}

