/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.beetl.core.Configuration;
import org.beetl.sql.core.BeetlSQLException;
import org.beetl.sql.core.ClasspathLoader;
import org.beetl.sql.core.ConnectionSource;
import org.beetl.sql.core.DBRunner;
import org.beetl.sql.core.DefaultNameConversion;
import org.beetl.sql.core.IDAutoGen;
import org.beetl.sql.core.Interceptor;
import org.beetl.sql.core.NameConversion;
import org.beetl.sql.core.OnConnection;
import org.beetl.sql.core.RowMapper;
import org.beetl.sql.core.SQLLoader;
import org.beetl.sql.core.SQLReady;
import org.beetl.sql.core.SQLResult;
import org.beetl.sql.core.SQLScript;
import org.beetl.sql.core.SQLSource;
import org.beetl.sql.core.db.ClassDesc;
import org.beetl.sql.core.db.DBStyle;
import org.beetl.sql.core.db.KeyHolder;
import org.beetl.sql.core.db.MetadataManager;
import org.beetl.sql.core.db.TableDesc;
import org.beetl.sql.core.engine.Beetl;
import org.beetl.sql.core.engine.PageQuery;
import org.beetl.sql.core.kit.CaseInsensitiveOrderSet;
import org.beetl.sql.core.kit.Constants;
import org.beetl.sql.core.mapper.DefaultMapperBuilder;
import org.beetl.sql.core.mapper.MapperBuilder;
import org.beetl.sql.core.mapping.handler.ScalarHandler;
import org.beetl.sql.ext.SnowflakeIDAutoGen;
import org.beetl.sql.ext.gen.GenConfig;
import org.beetl.sql.ext.gen.GenFilter;
import org.beetl.sql.ext.gen.SourceGen;

public class SQLManager {
    private DBStyle dbStyle;
    private SQLLoader sqlLoader;
    private ConnectionSource ds = null;
    private NameConversion nc = null;
    private MetadataManager metaDataManager;
    Interceptor[] inters = new Interceptor[0];
    Beetl beetl = null;
    private String defaultSchema = null;
    MapperBuilder mapperBuilder = new DefaultMapperBuilder(this);
    boolean offsetStartZero = false;
    Map<String, IDAutoGen> idAutonGenMap = new HashMap<String, IDAutoGen>();

    public SQLManager(DBStyle dbStyle, ConnectionSource ds) {
        this(dbStyle, new ClasspathLoader("/sql"), ds);
    }

    public SQLManager(DBStyle dbStyle, SQLLoader sqlLoader, ConnectionSource ds) {
        this(dbStyle, sqlLoader, ds, new DefaultNameConversion(), new Interceptor[0], null);
    }

    public SQLManager(DBStyle dbStyle, SQLLoader sqlLoader, ConnectionSource ds, NameConversion nc) {
        this(dbStyle, sqlLoader, ds, nc, new Interceptor[0], null);
    }

    public SQLManager(DBStyle dbStyle, SQLLoader sqlLoader, ConnectionSource ds, NameConversion nc, Interceptor[] inters) {
        this(dbStyle, sqlLoader, ds, nc, inters, null);
    }

    public SQLManager(DBStyle dbStyle, SQLLoader sqlLoader, ConnectionSource ds, NameConversion nc, Interceptor[] inters, String defaultSchema) {
        this(dbStyle, sqlLoader, ds, nc, inters, defaultSchema, new Properties());
    }

    public SQLManager(DBStyle dbStyle, SQLLoader sqlLoader, ConnectionSource ds, NameConversion nc, Interceptor[] inters, String defaultSchema, Properties ps) {
        this.idAutonGenMap.put("simple", new SnowflakeIDAutoGen());
        this.defaultSchema = defaultSchema;
        this.beetl = new Beetl(sqlLoader, ps);
        this.dbStyle = dbStyle;
        this.sqlLoader = sqlLoader;
        this.ds = ds;
        this.nc = nc;
        this.inters = inters;
        this.dbStyle.setNameConversion(this.nc);
        this.dbStyle.setMetadataManager(this.initMetadataManager());
        this.dbStyle.init(this.beetl);
        this.offsetStartZero = Boolean.parseBoolean(this.beetl.getPs().getProperty("OFFSET_START_ZERO").trim());
    }

    private MetadataManager initMetadataManager() {
        if (this.metaDataManager == null) {
            this.metaDataManager = new MetadataManager(this.ds, this);
        }
        return this.metaDataManager;
    }

    public boolean isProductMode() {
        return !this.sqlLoader.isAutoCheck();
    }

    public SQLResult getSQLResult(String id, Map<String, Object> paras) {
        SQLScript script = this.getScript(id);
        return script.run(paras);
    }

    public SQLResult getSQLResult(String id, Object paras) {
        SQLScript script = this.getScript(id);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("_root", paras);
        return script.run(map);
    }

    public SQLResult getSQLResult(String id, Map<String, Object> paras, String parentId) {
        SQLScript script = this.getScript(id);
        return script.run(paras, parentId);
    }

    public SQLScript getScript(String id) {
        SQLSource source = this.sqlLoader.getSQL(id);
        SQLScript script = new SQLScript(source, this);
        return script;
    }

    public SQLScript getScript(Class<?> cls, int tempId) {
        String className = cls.getSimpleName().toLowerCase();
        String id = className + "." + Constants.classSQL[tempId];
        SQLSource tempSource = this.sqlLoader.getGenSQL(id);
        if (tempSource != null) {
            return new SQLScript(tempSource, this);
        }
        switch (tempId) {
            case 0: {
                tempSource = this.dbStyle.genSelectById(cls);
                break;
            }
            case 1: {
                tempSource = this.dbStyle.genSelectByTemplate(cls);
                break;
            }
            case 2: {
                tempSource = this.dbStyle.genSelectCountByTemplate(cls);
                break;
            }
            case 3: {
                tempSource = this.dbStyle.genDeleteById(cls);
                break;
            }
            case 4: {
                tempSource = this.dbStyle.genSelectAll(cls);
                break;
            }
            case 5: {
                tempSource = this.dbStyle.genUpdateAll(cls);
                break;
            }
            case 6: {
                tempSource = this.dbStyle.genUpdateById(cls);
                break;
            }
            case 7: {
                tempSource = this.dbStyle.genUpdateTemplate(cls);
                break;
            }
            case 8: {
                tempSource = this.dbStyle.genInsert(cls);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        tempSource.setId(id);
        this.sqlLoader.addGenSQL(id, tempSource);
        return new SQLScript(tempSource, this);
    }

    public SQLScript getPageSqlScript(String selectId) {
        String pageId = selectId + "_page";
        SQLSource source = this.sqlLoader.getGenSQL(pageId);
        if (source != null) {
            return new SQLScript(source, this);
        }
        SQLSource script = this.sqlLoader.getGenSQL(selectId);
        if (script == null) {
            script = this.sqlLoader.getSQL(selectId);
        }
        String template = script.getTemplate();
        String pageTemplate = this.dbStyle.getPageSQL(template);
        source = new SQLSource(pageId, pageTemplate);
        this.sqlLoader.addGenSQL(pageId, source);
        return new SQLScript(source, this);
    }

    public <T> List<T> select(String sqlId, Class<T> clazz, Map<String, Object> paras) {
        return this.select(sqlId, clazz, paras, null);
    }

    public <T> List<T> select(String sqlId, Class<T> clazz, Map<String, Object> paras, RowMapper<T> mapper) {
        SQLScript script = this.getScript(sqlId);
        return script.select(clazz, paras, mapper);
    }

    public <T> List<T> select(String sqlId, Class<T> clazz, Object paras) {
        return this.select(sqlId, clazz, paras, null);
    }

    public <T> List<T> select(String sqlId, Class<T> clazz, Object paras, RowMapper<T> mapper) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("_root", paras);
        SQLScript script = this.getScript(sqlId);
        return script.select(clazz, param, mapper);
    }

    public <T> List<T> select(String sqlId, Class<T> clazz, Object paras, long start, long size) {
        return this.select(sqlId, clazz, paras, null, start, size);
    }

    public <T> List<T> select(String sqlId, Class<T> clazz, Object paras, RowMapper<T> mapper, long start, long size) {
        SQLScript script = this.getScript(sqlId);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("_root", paras);
        return script.select(map, clazz, mapper, start, size);
    }

    public <T> List<T> select(String sqlId, Class<T> clazz, Map<String, Object> paras, long start, long size) {
        SQLScript script = this.getScript(sqlId);
        return script.select(paras, clazz, null, start, size);
    }

    public <T> List<T> select(String sqlId, Class<T> clazz, Map<String, Object> paras, RowMapper<T> mapper, long start, long size) {
        SQLScript script = this.getScript(sqlId);
        return script.select(paras, clazz, mapper, start, size);
    }

    public <T> void pageQuery(String sqlId, Class<T> clazz, PageQuery query) {
        this.pageQuery(sqlId, clazz, query, null);
    }

    public <T> void pageQuery(String sqlId, Class<T> clazz, PageQuery query, RowMapper<T> mapper) {
        Object paras = query.getParas();
        Map<String, Object> root = null;
        Long totalRow = query.getTotalRow();
        List<T> list = null;
        if (paras == null) {
            root = new HashMap();
        } else if (paras instanceof Map) {
            root = (Map)paras;
        } else {
            root = new HashMap();
            root.put("_root", paras);
        }
        if (query.getOrderBy() != null) {
            root.put("_orderBy", query.getOrderBy());
        }
        String sqlCountId = sqlId.concat("$count");
        boolean hasCountSQL = this.sqlLoader.exist(sqlCountId);
        if (query.getTotalRow() == -1L) {
            if (hasCountSQL) {
                totalRow = this.selectSingle(sqlCountId, root, Long.class);
            } else {
                root.put(PageQuery.pageFlag, PageQuery.pageObj);
                totalRow = this.selectSingle(sqlId, root, Long.class);
            }
            if (totalRow == null) {
                totalRow = 0L;
            }
            query.setTotalRow(totalRow);
        }
        if (!hasCountSQL) {
            root.remove(PageQuery.pageFlag);
        }
        if (totalRow != 0L) {
            long start = (long)(this.offsetStartZero ? 0 : 1) + (query.getPageNumber() - 1L) * query.getPageSize();
            long size = query.getPageSize();
            list = this.select(sqlId, clazz, root, mapper, start, size);
        } else {
            list = Collections.EMPTY_LIST;
        }
        query.setList(list);
    }

    public <T> T unique(Class<T> clazz, Object pk) {
        SQLScript script = this.getScript(clazz, 0);
        return script.unique(clazz, null, pk);
    }

    public <T> T unique(Class<T> clazz, RowMapper<T> mapper, Object pk) {
        SQLScript script = this.getScript(clazz, 0);
        return script.unique(clazz, mapper, pk);
    }

    public <T> T single(Class<T> clazz, Object pk) {
        SQLScript script = this.getScript(clazz, 0);
        return script.single(clazz, null, pk);
    }

    public <T> List<T> all(Class<T> clazz) {
        SQLScript script = this.getScript(clazz, 4);
        return script.select(clazz, null);
    }

    public <T> List<T> all(Class<T> clazz, long start, long size) {
        SQLScript script = this.getScript(clazz, 4);
        return script.select(null, clazz, null, start, size);
    }

    public long allCount(Class<?> clazz) {
        SQLScript script = this.getScript(clazz, 2);
        return script.selectSingle(null, Long.class);
    }

    public <T> List<T> all(Class<T> clazz, RowMapper<T> mapper, long start, int end) {
        SQLScript script = this.getScript(clazz, 4);
        return script.select(null, clazz, mapper, start, (long)end);
    }

    public <T> List<T> all(Class<T> clazz, RowMapper<T> mapper) {
        SQLScript script = this.getScript(clazz, 4);
        return script.select(clazz, null, mapper);
    }

    public <T> List<T> template(T t) {
        SQLScript script = this.getScript(t.getClass(), 1);
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("_root", t);
        return script.select(t.getClass(), param, null);
    }

    public <T> List<T> template(T t, RowMapper mapper) {
        SQLScript script = this.getScript(t.getClass(), 1);
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("_root", t);
        return script.select(t.getClass(), param, mapper);
    }

    public <T> List<T> template(T t, long start, long size) {
        return this.template(t, null, start, size);
    }

    public <T> List<T> template(T t, RowMapper mapper, long start, long size) {
        SQLScript script = this.getScript(t.getClass(), 1);
        SQLScript pageScript = this.getPageSqlScript(script.id);
        HashMap<String, Object> param = new HashMap<String, Object>();
        this.dbStyle.initPagePara(param, start, size);
        param.put("_root", t);
        return pageScript.select(t.getClass(), param, mapper);
    }

    public <T> long templateCount(T t) {
        SQLScript script = this.getScript(t.getClass(), 2);
        Long l = script.singleSelect(t, Long.class);
        return l;
    }

    public Long longValue(String id, Map<String, Object> paras) {
        return this.selectSingle(id, paras, Long.class);
    }

    public Long longValue(String id, Object paras) {
        return this.selectSingle(id, paras, Long.class);
    }

    public Integer intValue(String id, Object paras) {
        return this.selectSingle(id, paras, Integer.class);
    }

    public Integer intValue(String id, Map<String, Object> paras) {
        return this.selectSingle(id, paras, Integer.class);
    }

    public BigDecimal bigDecimalValue(String id, Object paras) {
        return this.selectSingle(id, paras, BigDecimal.class);
    }

    public BigDecimal bigDecimalValue(String id, Map<String, Object> paras) {
        return this.selectSingle(id, paras, BigDecimal.class);
    }

    public <T> T selectSingle(String id, Object paras, Class<T> target) {
        SQLScript script = this.getScript(id);
        return script.singleSelect(paras, target);
    }

    public <T> T selectSingle(String id, Map<String, Object> paras, Class<T> target) {
        SQLScript script = this.getScript(id);
        return script.selectSingle(paras, target);
    }

    public <T> T selectUnique(String id, Object paras, Class<T> target) {
        SQLScript script = this.getScript(id);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("_root", paras);
        return script.selectUnique(map, target);
    }

    public <T> T selectUnique(String id, Map<String, Object> paras, Class<T> target) {
        SQLScript script = this.getScript(id);
        return script.selectUnique(paras, target);
    }

    public int deleteById(Class<?> clazz, Object pkValue) {
        SQLScript script = this.getScript(clazz, 3);
        return script.deleteById(clazz, pkValue);
    }

    public int insert(Class<?> clazz, Object paras) {
        return this.insert(clazz, paras, false);
    }

    public int insert(Object paras) {
        return this.insert(paras.getClass(), paras, false);
    }

    public int insert(Object paras, boolean autoAssignKey) {
        return this.insert(paras.getClass(), paras, autoAssignKey);
    }

    public int insert(Class clazz, Object paras, boolean autoAssignKey) {
        if (autoAssignKey) {
            KeyHolder holder = new KeyHolder();
            Class target = clazz;
            int result = this.insert(target, paras, holder);
            String table = this.nc.getTableName(target);
            ClassDesc desc = this.metaDataManager.getTable(table).getClassDesc(target, this.nc);
            Method getterMethod = (Method)desc.getIdMethods().get(desc.getIdCols().get(0));
            String name = getterMethod.getName();
            String setterName = name.replaceFirst("get", "set");
            try {
                Method setterMethod = target.getMethod(setterName, getterMethod.getReturnType());
                Object value = holder.getKey();
                value = ScalarHandler.convertValueToRequiredType(value, getterMethod.getReturnType());
                setterMethod.invoke(paras, value);
                return result;
            }
            catch (Exception ex) {
                throw new UnsupportedOperationException("autoAssignKey failure " + ex.getMessage());
            }
        }
        SQLScript script = this.getScript(clazz, 8);
        return script.insert(paras);
    }

    public void insertBatch(Class clazz, List<?> list) {
        SQLScript script = this.getScript(clazz, 8);
        script.updateBatch(list);
    }

    public int insert(Class<?> clazz, Object paras, KeyHolder holder) {
        SQLScript script = this.getScript(clazz, 8);
        return script.insert(paras, holder);
    }

    public int insert(String sqlId, Object paras, KeyHolder holder, String keyName) {
        SQLScript script = this.getScript(sqlId);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("_root", paras);
        return script.insertBySqlId(map, holder, keyName);
    }

    public int insert(String sqlId, Object paras, KeyHolder holder) {
        SQLScript script = this.getScript(sqlId);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("_root", paras);
        if (holder != null) {
            String tableName = this.nc.getTableName(paras.getClass());
            TableDesc table = this.metaDataManager.getTable(tableName);
            Set<String> idCols = table.getIdNames();
            if (idCols.size() != 1) {
                throw new BeetlSQLException(4, "\u6709\u591a\u4e2a\u4e3b\u952e\uff0c\u4e0d\u80fd\u81ea\u52a8\u8bbe\u7f6e");
            }
            return script.insertBySqlId(map, holder, ((CaseInsensitiveOrderSet)idCols).getFirst());
        }
        return script.insertBySqlId(map, null, null);
    }

    public int insert(String sqlId, Class<?> clazz, Map paras, KeyHolder holder) {
        SQLScript script = this.getScript(sqlId);
        if (holder != null) {
            String tableName = this.nc.getTableName(clazz);
            TableDesc table = this.metaDataManager.getTable(tableName);
            ClassDesc clsDesc = table.getClassDesc(this.nc);
            Set<String> idCols = table.getIdNames();
            if (idCols.size() != 1) {
                throw new BeetlSQLException(4, "\u6709\u591a\u4e2a\u4e3b\u952e\uff0c\u4e0d\u80fd\u81ea\u52a8\u8bbe\u7f6e");
            }
            return script.insertBySqlId(paras, holder, ((CaseInsensitiveOrderSet)idCols).getFirst());
        }
        return script.insertBySqlId(paras, holder, null);
    }

    public int insert(String sqlId, Map paras, KeyHolder holder, String keyName) {
        SQLScript script = this.getScript(sqlId);
        return script.insertBySqlId(paras, holder, keyName);
    }

    public int updateById(Object obj) {
        SQLScript script = this.getScript(obj.getClass(), 6);
        return script.update(obj);
    }

    public int updateTemplateById(Object obj) {
        SQLScript script = this.getScript(obj.getClass(), 7);
        return script.update(obj);
    }

    public int updateTemplateById(Class c, Map paras) {
        SQLScript script = this.getScript(c, 7);
        return script.update(paras);
    }

    public int[] updateByIdBatch(List<?> list) {
        if (list == null || list.isEmpty()) {
            return new int[0];
        }
        SQLScript script = this.getScript(list.get(0).getClass(), 6);
        return script.updateBatch(list);
    }

    public int update(String sqlId, Object obj) {
        SQLScript script = this.getScript(sqlId);
        return script.update(obj);
    }

    public int update(String sqlId, Map<String, Object> paras) {
        SQLScript script = this.getScript(sqlId);
        return script.update(paras);
    }

    public int[] updateBatch(String sqlId, List<?> list) {
        SQLScript script = this.getScript(sqlId);
        return script.updateBatch(list);
    }

    public int[] updateBatch(String sqlId, Map<String, Object>[] maps) {
        SQLScript script = this.getScript(sqlId);
        return script.updateBatch(maps);
    }

    public int updateAll(Class<?> clazz, Object param) {
        SQLScript script = this.getScript(clazz, 5);
        return script.update(param);
    }

    public void useMaster(DBRunner f) {
        f.start(this, true);
    }

    public void useSlave(DBRunner f) {
        f.start(this, false);
    }

    public <T> List<T> execute(String sqlTemplate, Class<T> clazz, Object paras) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("_root", paras);
        return this.execute(sqlTemplate, clazz, map);
    }

    public <T> List<T> execute(String sqlTemplate, Class<T> clazz, Map paras) {
        String key = "auto._gen_" + sqlTemplate;
        SQLSource source = this.sqlLoader.getGenSQL(key);
        if (source == null) {
            source = new SQLSource(key, sqlTemplate);
            this.sqlLoader.addGenSQL(key, source);
        }
        SQLScript script = new SQLScript(source, this);
        return script.select(clazz, paras);
    }

    public <T> List<T> execute(String sqlTemplate, Class<T> clazz, Map paras, long start, long size) {
        String key = "auto._gen_" + sqlTemplate;
        SQLSource source = this.sqlLoader.getGenSQL(key);
        if (source == null) {
            String pageSql = this.dbStyle.getPageSQL(sqlTemplate);
            source = new SQLSource(key, pageSql);
            this.sqlLoader.addGenSQL(key, source);
        }
        this.dbStyle.initPagePara(paras, start, size);
        SQLScript script = new SQLScript(source, this);
        return script.select(clazz, paras);
    }

    public <T> List<T> execute(String sqlTemplate, Class<T> clazz, Object paras, long start, long size) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("_root", paras);
        return this.execute(sqlTemplate, clazz, map, start, size);
    }

    public int executeUpdate(String sqlTemplate, Object paras) {
        String key = "auto._gen_" + sqlTemplate;
        SQLSource source = this.sqlLoader.getGenSQL(key);
        if (source == null) {
            source = new SQLSource(key, sqlTemplate);
            this.sqlLoader.addGenSQL(key, source);
        }
        SQLScript script = new SQLScript(source, this);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("_root", paras);
        return script.update(map);
    }

    public int executeUpdate(String sqlTemplate, Map paras) {
        String key = "auto._gen_" + sqlTemplate;
        SQLSource source = this.sqlLoader.getGenSQL(key);
        if (source == null) {
            source = new SQLSource(key, sqlTemplate);
            this.sqlLoader.addGenSQL(key, source);
        }
        SQLScript script = new SQLScript(source, this);
        return script.update(paras);
    }

    public <T> List<T> execute(SQLReady p, Class<T> clazz) {
        SQLSource source = new SQLSource(p.getSql(), p.getSql());
        SQLScript script = new SQLScript(source, this);
        return script.sqlReadySelect(clazz, p);
    }

    public int executeUpdate(SQLReady p) {
        SQLSource source = new SQLSource(p.getSql(), p.getSql());
        SQLScript script = new SQLScript(source, this);
        return script.sqlReadyExecuteUpdate(p);
    }

    public <T> T executeOnConnection(OnConnection<T> onConnection) {
        Connection conn = null;
        try {
            conn = onConnection.getConn(this.getDs());
            T t = onConnection.call(conn);
            return t;
        }
        catch (SQLException e) {
            throw new BeetlSQLException(1, e);
        }
        finally {
            if (!this.getDs().isTransaction()) {
                try {
                    if (!conn.getAutoCommit()) {
                        conn.commit();
                    }
                    conn.close();
                }
                catch (SQLException e) {
                    throw new BeetlSQLException(1, e);
                }
            }
        }
    }

    public void genPojoCode(String table, String pkg, String srcPath, GenConfig config) throws Exception {
        SourceGen gen = new SourceGen(this, table, pkg, srcPath, config);
        gen.gen();
    }

    public void genPojoCode(String table, String pkg, GenConfig config) throws Exception {
        String srcPath = this.getJavaSRCPath();
        SourceGen gen = new SourceGen(this, table, pkg, srcPath, config);
        gen.gen();
    }

    public void genPojoCode(String table, String pkg) throws Exception {
        String srcPath = this.getJavaSRCPath();
        SourceGen gen = new SourceGen(this, table, pkg, srcPath, new GenConfig());
        gen.gen();
    }

    public void genPojoCodeToConsole(String table) throws Exception {
        String pkg = SourceGen.defaultPkg;
        String srcPath = System.getProperty("user.dir");
        SourceGen gen = new SourceGen(this, table, pkg, srcPath, new GenConfig().setDisplay(true));
        gen.gen();
    }

    public void genPojoCodeToConsole(String table, GenConfig config) throws Exception {
        String pkg = SourceGen.defaultPkg;
        String srcPath = System.getProperty("user.dir");
        config.setDisplay(true);
        SourceGen gen = new SourceGen(this, table, pkg, srcPath, config);
        gen.gen();
    }

    public void genSQLFile(String table) throws Exception {
        String path = "/sql";
        if (this.sqlLoader instanceof ClasspathLoader) {
            path = ((ClasspathLoader)this.sqlLoader).sqlRoot;
        }
        String target = this.getJavaResourcePath() + "/" + path + "/" + this.nc.getClassName(table) + ".md";
        FileWriter writer = new FileWriter(new File(target));
        this.genSQLTemplate(table, writer);
        writer.close();
        System.out.println("gen \"" + table + "\" success at " + target);
    }

    public void genSQLTemplateToConsole(String table) throws Exception {
        this.genSQLTemplate(table, new OutputStreamWriter(System.out));
    }

    private void genSQLTemplate(String table, Writer w) throws IOException {
        Object template = null;
        Configuration cf = this.beetl.getGroupTemplate().getConf();
        String hs = cf.getPlaceholderStart();
        String he = cf.getPlaceholderEnd();
        StringBuilder cols = new StringBuilder();
        String sql = "select " + hs + "use(\"cols\")" + he + " from " + table + " where " + hs + "use(\"condition\")" + he;
        cols.append("sample").append("\n===\n").append("* \u6ce8\u91ca").append("\n\n\t").append(sql);
        cols.append("\n");
        cols.append("\ncols").append("\n===\n").append("").append("\n\t").append(this.dbStyle.genColumnList(table));
        cols.append("\n");
        cols.append("\nupdateSample").append("\n===\n").append("").append("\n\t").append(this.dbStyle.genColAssignPropertyAbsolute(table));
        cols.append("\n");
        String condition = this.dbStyle.genCondition(table);
        condition = condition.replaceAll("\\n", "\n\t");
        cols.append("\ncondition").append("\n===\n").append("").append("\n\t").append(condition);
        cols.append("\n");
        w.write(cols.toString());
        w.flush();
    }

    public void genALL(String pkg, GenConfig config, GenFilter filter) throws Exception {
        Set<String> tables = this.metaDataManager.allTable();
        for (String table : tables) {
            table = this.metaDataManager.getTable(table).getName();
            if (filter != null && !filter.accept(table)) continue;
            try {
                this.genPojoCode(table, pkg, config);
                this.genSQLFile(table);
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
    }

    public <T> T getMapper(Class<T> mapperInterface) {
        return this.mapperBuilder.getMapper(mapperInterface);
    }

    public SQLLoader getSqlLoader() {
        return this.sqlLoader;
    }

    public void setSqlLoader(SQLLoader sqlLoader) {
        this.sqlLoader = sqlLoader;
    }

    public ConnectionSource getDs() {
        return this.ds;
    }

    public void setDs(ConnectionSource ds) {
        this.ds = ds;
    }

    public NameConversion getNc() {
        return this.nc;
    }

    public void setNc(NameConversion nc) {
        this.nc = nc;
        this.dbStyle.setNameConversion(nc);
    }

    public DBStyle getDbStyle() {
        return this.dbStyle;
    }

    public Beetl getBeetl() {
        return this.beetl;
    }

    public MetadataManager getMetaDataManager() {
        return this.metaDataManager;
    }

    private String getJavaSRCPath() {
        String srcPath = null;
        String userDir = System.getProperty("user.dir");
        if (userDir == null) {
            throw new NullPointerException("\u7528\u6237\u76ee\u5f55\u672a\u627e\u5230");
        }
        File src = new File(userDir, "src");
        File javaSrc = new File(src.toString(), "/main/java");
        srcPath = javaSrc.exists() ? javaSrc.toString() : src.toString();
        return srcPath;
    }

    private String getJavaResourcePath() {
        String srcPath = null;
        String userDir = System.getProperty("user.dir");
        if (userDir == null) {
            throw new NullPointerException("\u7528\u6237\u76ee\u5f55\u672a\u627e\u5230");
        }
        File src = new File(userDir, "src");
        File resSrc = new File(src.toString(), "/main/resources");
        srcPath = resSrc.exists() ? resSrc.toString() : src.toString();
        return srcPath;
    }

    public String getDefaultSchema() {
        return this.defaultSchema;
    }

    public void setDefaultSchema(String defaultSchema) {
        this.defaultSchema = defaultSchema;
    }

    public MapperBuilder getMapperBuilder() {
        return this.mapperBuilder;
    }

    public void setMapperBuilder(MapperBuilder mapperBuilder) {
        this.mapperBuilder = mapperBuilder;
    }

    public Interceptor[] getInters() {
        return this.inters;
    }

    public void setInters(Interceptor[] inters) {
        this.inters = inters;
    }

    public void addIdAutonGen(String name, IDAutoGen alorithm) {
        this.idAutonGenMap.put(name, alorithm);
    }

    protected Object getAssignIdByIdAutonGen(String name, String param, String table) {
        IDAutoGen idGen = this.idAutonGenMap.get(name);
        if (idGen == null) {
            throw new BeetlSQLException(15, "\u672a\u53d1\u73b0\u81ea\u52a8id\u751f\u6210\u5668:" + name + " in " + table);
        }
        return idGen.nextID(param);
    }
}

