/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.beetl.sql.core.BeetlSQLException;
import org.beetl.sql.core.SQLLoader;
import org.beetl.sql.core.SQLSource;
import org.beetl.sql.core.db.DBStyle;
import org.beetl.sql.core.db.MySqlStyle;

public class ClasspathLoader
implements SQLLoader {
    String sqlRoot = null;
    private String lineSeparator = System.getProperty("line.separator", "\n");
    private Map<String, SQLSource> sqlSourceMap = new ConcurrentHashMap<String, SQLSource>();
    private Map<String, Integer> sqlSourceVersion = new ConcurrentHashMap<String, Integer>();
    private DBStyle dbs = null;
    private boolean autoCheck = true;
    private String charset = null;

    public ClasspathLoader() {
        this("/sql");
    }

    public ClasspathLoader(String root) {
        this(root, new MySqlStyle());
    }

    public ClasspathLoader(String root, DBStyle dbs) {
        this.sqlRoot = root;
        this.dbs = dbs;
    }

    @Override
    public SQLSource getSQL(String id) {
        SQLSource ss = this.tryLoadSQL(id);
        if (ss == null) {
            throw new BeetlSQLException(2, "\u672a\u80fd\u627e\u5230" + id + "\u5bf9\u5e94\u7684sql");
        }
        return ss;
    }

    private SQLSource tryLoadSQL(String id) {
        SQLSource ss = this.sqlSourceMap.get(id);
        boolean hasLoad = false;
        if (ss == null) {
            this.loadSql(id);
            hasLoad = true;
        }
        if (!hasLoad && this.autoCheck && this.isModified(id)) {
            this.loadSql(id);
        }
        ss = this.sqlSourceMap.get(id);
        return ss;
    }

    @Override
    public boolean isModified(String id) {
        String sqlName;
        int index = id.indexOf(46);
        if (index != -1 && (sqlName = id.substring(index)).startsWith("._gen")) {
            return false;
        }
        InputStream is = this.getDBRootFile(id);
        if (is == null) {
            is = this.getRootFile(id);
        }
        if (is != null) {
            Integer lastModify = is.hashCode();
            Integer oldVersion = this.sqlSourceVersion.get(id);
            if (oldVersion != null && oldVersion.equals(lastModify)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean exist(String id) {
        return this.tryLoadSQL(id) != null;
    }

    @Override
    public void addGenSQL(String id, SQLSource source) {
        this.sqlSourceVersion.put(id, 0);
        this.sqlSourceMap.put(id, source);
    }

    private boolean loadSql(String id) {
        InputStream ins = this.getRootFile(id);
        boolean rootResult = this.readSqlFile(id, ins);
        ins = this.getDBRootFile(id);
        boolean dbResult = this.readSqlFile(id, ins);
        if (rootResult || dbResult) {
            return true;
        }
        String modelName = id.substring(0, id.lastIndexOf("."));
        String path = modelName.replace('.', '/');
        String filePath0 = this.sqlRoot + "/" + this.dbs.getName() + "/" + path + ".sql";
        String filePath1 = this.sqlRoot + "/" + this.dbs.getName() + "/" + path + ".md";
        String filePath2 = this.sqlRoot + "/" + path + ".sql";
        String filePath3 = this.sqlRoot + "/" + path + ".md";
        throw new BeetlSQLException(2, "\u5728 " + filePath0 + " \u548c " + filePath1 + " \u548c " + filePath2 + " \u548c " + filePath3 + " \u548c " + " \u672a\u627e\u5230[id=" + id + "]\u76f8\u5173\u7684SQL");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean readSqlFile(String id, InputStream ins) {
        String modelName = id.substring(0, id.lastIndexOf(".") + 1);
        if (ins == null) {
            return false;
        }
        Integer lastModified = ins.hashCode();
        this.sqlSourceVersion.put(id, lastModified);
        LinkedList<String> list = new LinkedList<String>();
        BufferedReader bf = null;
        try {
            bf = new BufferedReader(new InputStreamReader(ins, this.charset));
            String temp = null;
            StringBuilder sql = null;
            String key = null;
            int lineNum = 0;
            int findLineNum = 0;
            block11: while ((temp = bf.readLine()) != null) {
                temp = temp.trim();
                ++lineNum;
                if (temp.startsWith("===")) {
                    if (!list.isEmpty() && list.size() > 1) {
                        String tempKey = (String)list.pollLast();
                        sql = new StringBuilder();
                        key = (String)list.pollFirst();
                        while (!list.isEmpty()) {
                            sql.append((String)list.pollFirst() + this.lineSeparator);
                        }
                        SQLSource source = new SQLSource(modelName + key, sql.toString().trim());
                        source.setLine(findLineNum);
                        this.sqlSourceMap.put(modelName + key, source);
                        list.addLast(tempKey);
                        findLineNum = lineNum;
                    }
                    boolean sqlStart = false;
                    String tempNext = null;
                    while ((tempNext = bf.readLine()) != null) {
                        tempNext = tempNext.trim();
                        ++lineNum;
                        if (tempNext.startsWith("*") || !sqlStart && tempNext.trim().length() == 0) continue;
                        sqlStart = true;
                        list.addLast(tempNext);
                        continue block11;
                    }
                    continue;
                }
                list.addLast(temp);
            }
            sql = new StringBuilder();
            key = (String)list.pollFirst();
            while (!list.isEmpty()) {
                sql.append((String)list.pollFirst() + this.lineSeparator);
            }
            SQLSource source = new SQLSource(modelName + key, sql.toString().trim());
            source.setLine(findLineNum);
            this.sqlSourceMap.put(modelName + key, source);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (bf != null) {
                try {
                    bf.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return true;
    }

    public Map<String, SQLSource> getSqlSourceMap() {
        return this.sqlSourceMap;
    }

    public String getSqlRoot() {
        return this.sqlRoot;
    }

    public void setSqlRoot(String sqlRoot) {
        this.sqlRoot = sqlRoot;
    }

    private InputStream getRootFile(String id) {
        String modelName = id.substring(0, id.lastIndexOf("."));
        String path = modelName.replace('.', '/');
        String filePath0 = this.sqlRoot + "/" + path + ".sql";
        String filePath1 = this.sqlRoot + "/" + path + ".md";
        InputStream is = this.getFile(filePath0, id);
        if (is == null && (is = this.getFile(filePath1, id)) == null) {
            return null;
        }
        return is;
    }

    private InputStream getDBRootFile(String id) {
        String modelName = id.substring(0, id.lastIndexOf("."));
        String path = modelName.replace('.', '/');
        String filePath0 = this.sqlRoot + "/" + this.dbs.getName() + "/" + path + ".sql";
        String filePath1 = this.sqlRoot + "/" + this.dbs.getName() + "/" + path + ".md";
        InputStream is = this.getFile(filePath0, id);
        if (is == null && (is = this.getFile(filePath1, id)) == null) {
            return null;
        }
        return is;
    }

    private InputStream getFile(String filePath, String id) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        InputStream is = null;
        if (loader != null) {
            is = loader.getResourceAsStream(filePath);
            if (is != null) {
                return is;
            }
            is = this.getClass().getResourceAsStream(filePath);
            return is;
        }
        is = this.getClass().getResourceAsStream(filePath);
        return is;
    }

    @Override
    public boolean isAutoCheck() {
        return this.autoCheck;
    }

    @Override
    public void setAutoCheck(boolean check) {
        this.autoCheck = check;
    }

    @Override
    public SQLSource getGenSQL(String id) {
        return this.sqlSourceMap.get(id);
    }

    public DBStyle getDbs() {
        return this.dbs;
    }

    public void setDbs(DBStyle dbs) {
        this.dbs = dbs;
    }

    @Override
    public String getCharset() {
        return this.charset;
    }

    @Override
    public void setCharset(String charset) {
        this.charset = charset;
    }
}

