/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core.engine;

import java.io.IOException;
import java.util.Map;
import org.beetl.core.tag.Tag;
import org.beetl.sql.core.kit.StringKit;

public class TrimTag
extends Tag {
    public static final String SPACE = " ";
    public static final char SEPARATOR_CHAR = '|';
    public static final String SUFFIX_OVERRIDES = "suffixOverrides";
    public static final String PREFIX_OVERRIDES = "prefixOverrides";
    public static final String SUFFIX = "suffix";
    public static final String PREFIX = "prefix";
    protected String prefix = "";
    protected String[] prefixOverrides;
    private String[] suffixOverrides;
    private String suffix = "";

    public void render() {
        try {
            Object[] args = this.args;
            if (args != null && args.length != 0) {
                this.initTrimArgs(args);
                StringBuilder sb = this.buildTrimContent();
                this.ctx.byteWriter.writeString(sb.toString());
            } else {
                String sql = this.getBodyContent().getBody().trim();
                if (sql.endsWith(",")) {
                    this.ctx.byteWriter.writeString(sql.substring(0, sql.length() - 1));
                } else {
                    this.ctx.byteWriter.writeString(sql);
                }
            }
        }
        catch (IOException ie) {
            throw new RuntimeException(ie);
        }
    }

    protected StringBuilder buildTrimContent() {
        StringBuilder sb = new StringBuilder();
        String sql = this.getBodyContent().getBody();
        boolean isSqlBlank = this.isSqlBlank(sql);
        if (!isSqlBlank) {
            if (StringKit.isNotBlank(this.prefix)) {
                this.appendSql(sb, this.prefix);
            }
            String trimSql = StringKit.trim(sql);
            if (this.prefixOverrides != null && this.prefixOverrides.length > 0) {
                for (String prefixOverride : this.prefixOverrides) {
                    if (!StringKit.startsWith(trimSql, prefixOverride, true)) continue;
                    trimSql = trimSql.substring(prefixOverride.length());
                }
            }
            if (this.suffixOverrides != null && this.suffixOverrides.length > 0) {
                for (String suffixOverride : this.suffixOverrides) {
                    if (!StringKit.endsWith(trimSql, suffixOverride, true)) continue;
                    trimSql = trimSql.substring(0, trimSql.length() - suffixOverride.length());
                }
            }
            this.appendSql(sb, trimSql);
            if (StringKit.isNotBlank(this.suffix)) {
                this.appendSql(sb, this.suffix);
            }
        }
        return sb;
    }

    protected void initTrimArgs(Object[] args) {
        for (Object arg : args) {
            if (!(arg instanceof Map)) continue;
            Map params = (Map)arg;
            if (params.containsKey(PREFIX)) {
                this.prefix = (String)params.get(PREFIX);
            }
            if (params.containsKey(SUFFIX)) {
                this.suffix = (String)params.get(SUFFIX);
            }
            if (params.containsKey(PREFIX_OVERRIDES)) {
                this.prefixOverrides = StringKit.split((String)params.get(PREFIX_OVERRIDES), '|');
            }
            if (!params.containsKey(SUFFIX_OVERRIDES)) continue;
            this.suffixOverrides = StringKit.split((String)params.get(SUFFIX_OVERRIDES), '|');
        }
    }

    protected void appendSql(StringBuilder sb, String sql) {
        if (StringKit.isNotBlank(sql)) {
            sb.append(SPACE).append(sql).append(SPACE);
        }
    }

    protected boolean isSqlBlank(String sql) {
        if (StringKit.isBlank(sql)) {
            return true;
        }
        return StringKit.trim(sql).isEmpty();
    }
}

