/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core.db;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import org.beetl.sql.core.annotatoin.AssignID;
import org.beetl.sql.core.annotatoin.AutoID;
import org.beetl.sql.core.annotatoin.SeqID;
import org.beetl.sql.core.db.AbstractDBStyle;
import org.beetl.sql.core.db.PageParamKit;
import org.beetl.sql.core.kit.BeanKit;

public class PostgresStyle
extends AbstractDBStyle {
    @Override
    public int getIdType(Class c, String idProperty) {
        List<Annotation> ans = BeanKit.getAllAnnoation(c, idProperty);
        int idType = 2;
        for (Annotation an : ans) {
            if (an instanceof SeqID) {
                idType = 3;
                break;
            }
            if (an instanceof AutoID) {
                idType = 2;
                break;
            }
            if (!(an instanceof AssignID)) continue;
            idType = 1;
        }
        return idType;
    }

    @Override
    public String getPageSQL(String sql) {
        String pageSql = "select _a.* from ( \n" + sql + this.getOrderBy() + " \n) _a  limit " + this.HOLDER_START + "_pageSize" + this.HOLDER_END + " offset " + this.HOLDER_START + "_pageOffset" + this.HOLDER_END;
        return pageSql;
    }

    @Override
    public String getPageSQLStatement(String sql, long offset, long pageSize) {
        offset = PageParamKit.postgresOffset(this.offsetStartZero, offset);
        int capacity = sql.length() + 50;
        StringBuilder builder = new StringBuilder(capacity);
        builder.append("select _a.* from ( ").append(sql).append(" ) _a ");
        builder.append("limit ").append(pageSize).append(" offset ").append(offset);
        return builder.toString();
    }

    @Override
    public void initPagePara(Map<String, Object> paras, long start, long size) {
        paras.put("_pageOffset", start - (long)(this.offsetStartZero ? 0 : 1));
        paras.put("_pageSize", size);
    }

    @Override
    public String getName() {
        return "postgres";
    }

    @Override
    public int getDBType() {
        return 3;
    }

    @Override
    public String getSeqValue(String seqName) {
        return "nextval('" + seqName + "')";
    }
}

