/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.beetl.core.Context;
import org.beetl.core.GroupTemplate;
import org.beetl.core.Template;
import org.beetl.sql.core.BatchUpdateInterceptorContext;
import org.beetl.sql.core.BeetlSQLException;
import org.beetl.sql.core.Interceptor;
import org.beetl.sql.core.InterceptorContext;
import org.beetl.sql.core.RowMapper;
import org.beetl.sql.core.SQLBatchReady;
import org.beetl.sql.core.SQLManager;
import org.beetl.sql.core.SQLReady;
import org.beetl.sql.core.SQLResult;
import org.beetl.sql.core.SQLResultListener;
import org.beetl.sql.core.SQLSource;
import org.beetl.sql.core.SQLTableSource;
import org.beetl.sql.core.annotatoin.AssignID;
import org.beetl.sql.core.annotatoin.builder.ObjectBuilderHolder;
import org.beetl.sql.core.annotatoin.builder.ObjectSelectBuilder;
import org.beetl.sql.core.db.ClassAnnotation;
import org.beetl.sql.core.db.ClassDesc;
import org.beetl.sql.core.db.KeyHolder;
import org.beetl.sql.core.db.MetadataManager;
import org.beetl.sql.core.db.TableDesc;
import org.beetl.sql.core.engine.SQLParameter;
import org.beetl.sql.core.kit.BeanKit;
import org.beetl.sql.core.kit.CaseInsensitiveOrderSet;
import org.beetl.sql.core.kit.StringKit;
import org.beetl.sql.core.mapping.BeanProcessor;
import org.beetl.sql.core.mapping.RowMapperResultSetExt;

public class SQLScript {
    final SQLManager sm;
    final String id;
    final String sql;
    final SQLSource sqlSource;
    final String dbName;
    private List<SQLResultListener> listener;

    public SQLScript(SQLSource sqlSource, SQLManager sm) {
        this.sqlSource = sqlSource;
        this.sql = sqlSource.getTemplate();
        this.sm = sm;
        this.id = sqlSource.getId();
        this.dbName = sm.getDbStyle().getName();
    }

    private static boolean isBaseDataType(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            return true;
        }
        if (clazz.getName().startsWith("java")) {
            return clazz == String.class || clazz == Integer.class || clazz == Byte.class || clazz == Long.class || clazz == Double.class || clazz == Float.class || clazz == Character.class || clazz == Short.class || clazz == BigDecimal.class || clazz == BigInteger.class || clazz == Boolean.class || clazz == java.util.Date.class || clazz == Date.class || clazz == Timestamp.class || clazz == LocalDateTime.class || clazz == LocalDate.class;
        }
        return false;
    }

    protected SQLResult run(Map<String, Object> paras) {
        return this.run(paras, null);
    }

    protected SQLResult run(Map<String, Object> paras, Context ctx) {
        GroupTemplate gt = this.sm.beetl.getGroupTemplate();
        Template t = null;
        String parentId = ctx == null ? null : (String)ctx.getGlobal("_id");
        t = parentId != null ? gt.getTemplate(this.sqlSource.getId(), ctx) : gt.getTemplate(this.sqlSource.getId());
        LinkedList<SQLParameter> jdbcPara = new LinkedList<SQLParameter>();
        if (paras != null) {
            for (Map.Entry<String, Object> entry : paras.entrySet()) {
                t.binding(entry.getKey(), entry.getValue());
            }
        }
        t.binding("_paras", jdbcPara);
        t.binding("_manager", (Object)this.sm);
        t.binding("_id", (Object)this.id);
        String jdbcSql = t.render();
        SQLResult result = new SQLResult();
        result.jdbcSql = jdbcSql;
        result.jdbcPara = jdbcPara;
        List scriptListeners = (List)t.getCtx().getGlobal("_listener");
        if (scriptListeners == null) {
            return result;
        }
        if (this.listener == null) {
            this.listener = scriptListeners;
            return result;
        }
        this.listener.addAll(scriptListeners);
        return result;
    }

    protected void checkAnnotatonBeforeSelect(Class target, Map<String, Object> paras) {
        ClassAnnotation an = ClassAnnotation.getClassAnnotation(target);
        if (an.getObjectBuilders().isEmpty()) {
            return;
        }
        for (ObjectBuilderHolder holder : an.getObjectBuilders()) {
            Object builder = holder.getInstance();
            if (!(builder instanceof ObjectSelectBuilder)) continue;
            ((ObjectSelectBuilder)builder).beforeSelect(target, this, holder.getBeanAnnotaton(), paras);
        }
    }

    protected List checkAnnotatonAfterSelect(Class target, List entitys, SQLResult sqlResult) {
        ClassAnnotation an = ClassAnnotation.getClassAnnotation(target);
        if (an.getObjectBuilders().isEmpty()) {
            return entitys;
        }
        List<Object> newList = entitys;
        for (ObjectBuilderHolder holder : an.getObjectBuilders()) {
            Object builder = holder.getInstance();
            if (!(builder instanceof ObjectSelectBuilder)) continue;
            newList = ((ObjectSelectBuilder)builder).afterSelect(target, newList, this, holder.getBeanAnnotaton(), sqlResult);
        }
        return newList;
    }

    public int insert(Object paras) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("_root", paras);
        this.addParaIfAssignId(paras);
        PreparedStatement ps = null;
        Connection conn = null;
        SQLResult result = this.run(map);
        String sql = result.jdbcSql;
        List<SQLParameter> objs = result.jdbcPara;
        InterceptorContext ctx = this.callInterceptorAsBefore(this.id, sql, true, objs, map);
        sql = ctx.getSql();
        objs = ctx.getParas();
        try {
            conn = this.sm.getDs().getConn(this.id, true, sql, objs);
            ps = conn.prepareStatement(sql);
            this.setPreparedStatementPara(ps, objs);
            int ret = ps.executeUpdate();
            this.callInterceptorAsAfter(ctx, ret);
            int n = ret;
            this.clean(true, conn, ps);
            return n;
        }
        catch (SQLException e) {
            try {
                this.callInterceptorAsException(ctx, e);
                throw new BeetlSQLException(1, e);
            }
            catch (Throwable throwable) {
                this.clean(true, conn, ps);
                throw throwable;
            }
        }
    }

    public int insert(Object paras, KeyHolder holder) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("_root", paras);
        this.addParaIfAssignId(paras);
        PreparedStatement ps = null;
        Connection conn = null;
        InterceptorContext ctx = null;
        try {
            int idType;
            SQLResult result = this.run(map);
            String sql = result.jdbcSql;
            List<SQLParameter> objs = result.jdbcPara;
            ctx = this.callInterceptorAsBefore(this.id, sql, true, objs, map);
            sql = ctx.getSql();
            objs = ctx.getParas();
            if (conn == null) {
                conn = this.sm.getDs().getConn(this.id, true, sql, objs);
            }
            if ((idType = ((SQLTableSource)this.sqlSource).getIdType()) == 1) {
                ps = conn.prepareStatement(sql);
            } else if (idType == 2) {
                ps = conn.prepareStatement(sql, 1);
            } else if (idType == 3) {
                CaseInsensitiveOrderSet idCols = (CaseInsensitiveOrderSet)((SQLTableSource)this.sqlSource).getTableDesc().getIdNames();
                if (idCols.size() != 1) {
                    throw new BeetlSQLException(4);
                }
                ps = conn.prepareStatement(sql, new String[]{idCols.getFirst()});
            } else {
                ps = conn.prepareStatement(sql);
            }
            this.setPreparedStatementPara(ps, objs);
            int ret = ps.executeUpdate();
            if (idType == 2 || idType == 3) {
                ResultSet seqRs = ps.getGeneratedKeys();
                seqRs.next();
                Object key = seqRs.getObject(1);
                holder.setKey(key);
                seqRs.close();
            }
            this.callInterceptorAsAfter(ctx, ret);
            int n = ret;
            this.clean(true, conn, ps);
            return n;
        }
        catch (SQLException e) {
            try {
                this.callInterceptorAsException(ctx, e);
                throw new BeetlSQLException(1, e);
            }
            catch (Throwable throwable) {
                this.clean(true, conn, ps);
                throw throwable;
            }
        }
    }

    public int insertBySqlId(Map map, KeyHolder holder, String keyName) {
        boolean getKey = holder != null;
        PreparedStatement ps = null;
        Connection conn = null;
        InterceptorContext ctx = null;
        try {
            SQLResult result = this.run(map);
            String sql = result.jdbcSql;
            List<SQLParameter> objs = result.jdbcPara;
            ctx = this.callInterceptorAsBefore(this.id, sql, true, objs, map);
            sql = ctx.getSql();
            objs = ctx.getParas();
            if (conn == null) {
                conn = this.sm.getDs().getConn(this.id, true, sql, objs);
            }
            ps = getKey ? conn.prepareStatement(sql, new String[]{keyName}) : conn.prepareStatement(sql);
            this.setPreparedStatementPara(ps, objs);
            int ret = ps.executeUpdate();
            if (getKey) {
                ResultSet seqRs = ps.getGeneratedKeys();
                seqRs.next();
                Object key = seqRs.getObject(1);
                holder.setKey(key);
                seqRs.close();
            }
            this.callInterceptorAsAfter(ctx, ret);
            int n = ret;
            this.clean(true, conn, ps);
            return n;
        }
        catch (SQLException e) {
            try {
                this.callInterceptorAsException(ctx, e);
                throw new BeetlSQLException(1, e);
            }
            catch (Throwable throwable) {
                this.clean(true, conn, ps);
                throw throwable;
            }
        }
    }

    public <T> T singleSelect(Object paras, Class<T> target) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("_root", paras);
        return this.selectSingle(map, target);
    }

    public <T> T selectSingle(Map<String, Object> map, Class<T> target) {
        List<T> result = this.select(target, map);
        if (result.size() > 0) {
            return result.get(0);
        }
        return null;
    }

    public <T> T selectUnique(Map<String, Object> map, Class<T> target) {
        List<T> result = this.select(target, map);
        int size = result.size();
        if (size == 1) {
            return result.get(0);
        }
        if (size == 0) {
            throw new BeetlSQLException(12, "unique\u67e5\u8be2\uff0c\u4f46\u6570\u636e\u5e93\u672a\u627e\u5230\u7ed3\u679c\u96c6:\u53c2\u6570\u662f" + map);
        }
        throw new BeetlSQLException(12, "unique\u67e5\u8be2\uff0c\u627e\u5230\u591a\u6761\u8bb0\u5f55:\u53c2\u6570\u662f" + map);
    }

    public <T> List<T> select(Class<T> clazz, Object paras) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("_root", paras);
        return this.select(clazz, map);
    }

    public <T> List<T> select(Class<T> clazz, Map<String, Object> paras, RowMapper<T> mapper) {
        this.checkAnnotatonBeforeSelect(clazz, paras);
        SQLResult result = this.run(paras);
        String sql = result.jdbcSql;
        List<SQLParameter> objs = result.jdbcPara;
        ResultSet rs = null;
        PreparedStatement ps = null;
        Object resultList = null;
        InterceptorContext ctx = this.callInterceptorAsBefore(this.id, sql, false, objs, paras);
        if (ctx.getResult() != null) {
            this.callInterceptorAsAfter(ctx, ctx.getResult());
            return (List)ctx.getResult();
        }
        sql = ctx.getSql();
        objs = ctx.getParas();
        Connection conn = null;
        try {
            Iterator<SQLResultListener> beanProcessor;
            conn = this.sm.getDs().getConn(this.id, false, sql, objs);
            ps = conn.prepareStatement(sql);
            this.setPreparedStatementPara(ps, objs);
            rs = ps.executeQuery();
            if (mapper != null) {
                beanProcessor = this.getBeanProcessor();
                resultList = new RowMapperResultSetExt<T>(mapper, (BeanProcessor)((Object)beanProcessor)).handleResultSet(this.id, rs, (Class)clazz);
            } else {
                resultList = this.mappingSelect(rs, clazz);
            }
            this.callInterceptorAsAfter(ctx, resultList);
            resultList = this.checkAnnotatonAfterSelect(clazz, (List)resultList, result);
            if (this.getListener() != null) {
                for (SQLResultListener listener : this.getListener()) {
                    listener.dataSelectd((List)resultList, paras, this.sm, result);
                }
            }
            beanProcessor = resultList;
            this.clean(false, conn, ps, rs);
            return beanProcessor;
        }
        catch (SQLException e) {
            try {
                this.callInterceptorAsException(ctx, e);
                throw new BeetlSQLException(1, e);
            }
            catch (Throwable throwable) {
                this.clean(false, conn, ps, rs);
                throw throwable;
            }
        }
    }

    public <T> List<T> select(Class<T> clazz, Map<String, Object> paras) {
        return this.select(clazz, paras, null);
    }

    public <T> List<T> mappingSelect(ResultSet rs, Class<T> clazz) throws SQLException {
        List<Object> resultList = null;
        BeanProcessor beanProcessor = this.getBeanProcessor();
        if (Map.class.isAssignableFrom(clazz)) {
            resultList = new ArrayList();
            while (rs.next()) {
                Map<String, Object> map = beanProcessor.toMap(this.sqlSource.getId(), clazz, rs);
                resultList.add(map);
            }
            return resultList;
        }
        if (SQLScript.isBaseDataType(clazz)) {
            resultList = new ArrayList(1);
            while (rs.next()) {
                Object result = beanProcessor.toBaseType(this.sqlSource.getId(), clazz, rs);
                resultList.add(result);
            }
        } else {
            resultList = beanProcessor.toBeanList(this.sqlSource.getId(), rs, clazz);
            return resultList;
        }
        return resultList;
    }

    private BeanProcessor getBeanProcessor() {
        String sqlId = this.sqlSource.getId();
        BeanProcessor bp = this.sm.getProcessors().get(sqlId);
        if (bp != null) {
            return bp;
        }
        String ns = sqlId.substring(0, sqlId.indexOf("."));
        bp = this.sm.getProcessors().get(ns);
        if (bp != null) {
            return bp;
        }
        return this.sm.getDefaultBeanProcessors();
    }

    public <T> List<T> select(Map<String, Object> paras, Class<T> mapping, RowMapper<T> mapper, long start, long size) {
        SQLScript pageScript = this.sm.getPageSqlScript(this.id);
        if (paras == null) {
            paras = new HashMap<String, Object>();
        }
        this.sm.getDbStyle().initPagePara(paras, start, size);
        return pageScript.select(mapping, paras, mapper);
    }

    public <T> List<T> select(Object paras, Class<T> mapping, RowMapper<T> mapper, long start, long end) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("_root", paras);
        return this.select(map, mapping, mapper, start, end);
    }

    public long selectCount(Object paras) {
        return this.singleSelect(paras, Long.class);
    }

    public long selectCount(Map<String, Object> paras) {
        return this.selectSingle(paras, Long.class);
    }

    public int update(Map<String, Object> paras) {
        SQLResult result = this.run(paras);
        String sql = result.jdbcSql;
        List<SQLParameter> objs = result.jdbcPara;
        InterceptorContext ctx = this.callInterceptorAsBefore(this.id, sql, true, objs, paras);
        sql = ctx.getSql();
        objs = ctx.getParas();
        int rs = 0;
        PreparedStatement ps = null;
        Connection conn = null;
        try {
            conn = this.sm.getDs().getConn(this.id, true, sql, objs);
            ps = conn.prepareStatement(sql);
            this.setPreparedStatementPara(ps, objs);
            rs = ps.executeUpdate();
            this.callInterceptorAsAfter(ctx, rs);
            this.clean(true, conn, ps);
        }
        catch (SQLException e) {
            try {
                this.callInterceptorAsException(ctx, e);
                throw new BeetlSQLException(1, e);
            }
            catch (Throwable throwable) {
                this.clean(true, conn, ps);
                throw throwable;
            }
        }
        return rs;
    }

    public int update(Object obj) {
        HashMap<String, Object> paras = new HashMap<String, Object>();
        paras.put("_root", obj);
        return this.update(paras);
    }

    public int[] updateBatch(Map<String, Object>[] maps) {
        int[] rs = null;
        Statement ps = null;
        Connection conn = null;
        InterceptorContext ctx = null;
        try {
            conn = this.sm.getDs().getMaster();
            for (int k = 0; k < maps.length; ++k) {
                Map<String, Object> paras = maps[k];
                SQLResult result = this.run(paras);
                List<SQLParameter> objs = result.jdbcPara;
                if (ps == null) {
                    ps = conn.prepareStatement(result.jdbcSql);
                    ctx = this.callInterceptorAsBefore(this.id, this.sql, true, Collections.EMPTY_LIST, paras);
                }
                this.setPreparedStatementPara((PreparedStatement)ps, objs);
                ps.addBatch();
            }
            rs = ps.executeBatch();
            this.callInterceptorAsAfter(ctx, rs);
            this.clean(true, conn, (PreparedStatement)ps);
        }
        catch (SQLException e) {
            try {
                this.callInterceptorAsException(ctx, e);
                throw new BeetlSQLException(1, e);
            }
            catch (Throwable throwable) {
                this.clean(true, conn, (PreparedStatement)ps);
                throw throwable;
            }
        }
        return rs;
    }

    public int[] insertBatch(List<?> list, LinkedList keys, boolean autoDbAssignKey) {
        if (list.size() == 0) {
            return new int[0];
        }
        int[] rs = null;
        Statement ps = null;
        Connection conn = null;
        InterceptorContext ctx = null;
        try {
            for (int k = 0; k < list.size(); ++k) {
                HashMap<String, Object> paras = new HashMap<String, Object>();
                Object entity = list.get(k);
                this.addParaIfAssignId(entity);
                paras.put("_root", entity);
                SQLResult result = this.run(paras);
                List<SQLParameter> objs = result.jdbcPara;
                if (ps == null) {
                    conn = this.sm.getDs().getConn(this.id, true, result.jdbcSql, objs);
                    ps = autoDbAssignKey ? conn.prepareStatement(result.jdbcSql, 1) : conn.prepareStatement(result.jdbcSql);
                    ctx = this.callInterceptorAsBefore(this.id, result.jdbcSql, true, new ArrayList<SQLParameter>(0), paras);
                }
                this.setPreparedStatementPara((PreparedStatement)ps, objs);
                ps.addBatch();
            }
            rs = ps.executeBatch();
            if (autoDbAssignKey) {
                ResultSet primaryKeys = ps.getGeneratedKeys();
                while (primaryKeys.next()) {
                    keys.add(primaryKeys.getObject(1));
                }
            }
            this.callInterceptorAsAfter(ctx, rs);
            this.clean(true, conn, (PreparedStatement)ps);
        }
        catch (SQLException e) {
            try {
                this.callInterceptorAsException(ctx, e);
                throw new BeetlSQLException(1, e);
            }
            catch (Throwable throwable) {
                this.clean(true, conn, (PreparedStatement)ps);
                throw throwable;
            }
        }
        return rs;
    }

    public int[] updateBatch(List<?> list) {
        if (list.size() == 0) {
            return new int[0];
        }
        Connection conn = null;
        InterceptorContext lastCtx = null;
        int[] jdbcRets = new int[list.size()];
        try {
            HashMap<String, Object> batchPs = new HashMap<String, Object>();
            HashMap<String, BatchUpdateInterceptorContext> batchCtx = new HashMap<String, BatchUpdateInterceptorContext>();
            HashMap<String, ArrayList<Integer>> batchRet = new HashMap<String, ArrayList<Integer>>();
            conn = this.sm.getDs().getMaster();
            for (int k = 0; k < list.size(); ++k) {
                HashMap<String, Object> paras = new HashMap<String, Object>();
                paras.put("_root", list.get(k));
                SQLResult result = this.run(paras);
                List<SQLParameter> objs = result.jdbcPara;
                Object ps = (Interceptor[])batchPs.get(result.jdbcSql);
                ArrayList<Integer> rets = (ArrayList<Integer>)batchRet.get(result.jdbcSql);
                BatchUpdateInterceptorContext ctx = (BatchUpdateInterceptorContext)batchCtx.get(result.jdbcSql);
                if (ps == null) {
                    ps = conn.prepareStatement(result.jdbcSql);
                    ctx = new BatchUpdateInterceptorContext(this.id, result.jdbcSql, new ArrayList<List<SQLParameter>>());
                    rets = new ArrayList<Integer>();
                    batchCtx.put(result.jdbcSql, ctx);
                    batchPs.put(result.jdbcSql, ps);
                    batchRet.put(result.jdbcSql, rets);
                }
                this.setPreparedStatementPara((PreparedStatement)ps, objs);
                ps.addBatch();
                rets.add(k);
                ctx.getBatchParas().add(objs);
            }
            for (Map.Entry entry : batchPs.entrySet()) {
                PreparedStatement ps = (PreparedStatement)entry.getValue();
                lastCtx = (InterceptorContext)batchCtx.get(entry.getKey());
                List rets = (List)batchRet.get(entry.getKey());
                for (Interceptor in : this.sm.inters) {
                    in.before(lastCtx);
                }
                int[] rs = ps.executeBatch();
                for (int i = 0; i < rs.length; ++i) {
                    int realIndex = (Integer)rets.get(i);
                    jdbcRets[realIndex] = rs[i];
                }
                this.callInterceptorAsAfter(lastCtx, rs);
            }
            this.clean(conn);
        }
        catch (SQLException e) {
            try {
                this.callInterceptorAsException(lastCtx, e);
                throw new BeetlSQLException(1, e);
            }
            catch (Throwable throwable) {
                this.clean(conn);
                throw throwable;
            }
        }
        return jdbcRets;
    }

    public <T> T unique(Class<T> clazz, RowMapper<T> mapper, Object objId) {
        return this.single(clazz, mapper, objId, true);
    }

    public <T> T single(Class<T> clazz, RowMapper<T> mapper, Object objId) {
        return this.single(clazz, mapper, objId, false);
    }

    public boolean existById(Class clazz, Object objId) {
        MetadataManager mm = this.sm.getDbStyle().getMetadataManager();
        TableDesc table = mm.getTable(this.sm.getNc().getTableName(clazz));
        ClassDesc classDesc = table.getClassDesc(clazz, this.sm.getNc());
        HashMap<String, Object> paras = new HashMap<String, Object>();
        this.setIdsParas(classDesc, objId, paras);
        SQLResult result = this.run(paras);
        String sql = result.jdbcSql;
        List<SQLParameter> objs = result.jdbcPara;
        ResultSet rs = null;
        PreparedStatement ps = null;
        InterceptorContext ctx = this.callInterceptorAsBefore(this.id, sql, false, objs, paras);
        if (ctx.getResult() != null) {
            this.callInterceptorAsAfter(ctx, ctx.getResult());
            return (Boolean)ctx.getResult();
        }
        sql = ctx.getSql();
        objs = ctx.getParas();
        Connection conn = null;
        boolean hasResult = false;
        try {
            conn = this.sm.getDs().getConn(this.id, false, sql, objs);
            ps = conn.prepareStatement(sql);
            this.setPreparedStatementPara(ps, objs);
            rs = ps.executeQuery();
            try {
                BeanProcessor beanProcessor = this.getBeanProcessor();
                rs.next();
                int count = rs.getInt(1);
                hasResult = count != 0;
            }
            catch (BeetlSQLException ex) {
                if (ex.code == 12) {
                    throw new BeetlSQLException(12, "exsit" + table.getName() + ",\u4f46\u6570\u636e\u5e93\u672a\u627e\u5230\u7ed3\u679c\u96c6:\u4e3b\u952e\u662f" + objId);
                }
                throw ex;
            }
            this.callInterceptorAsAfter(ctx, hasResult);
            this.clean(false, conn, ps, rs);
        }
        catch (SQLException e) {
            try {
                this.callInterceptorAsException(ctx, e);
                throw new BeetlSQLException(1, e);
            }
            catch (Throwable throwable) {
                this.clean(false, conn, ps, rs);
                throw throwable;
            }
        }
        return hasResult;
    }

    /*
     * Loose catch block
     */
    public <T> T single(Class<T> clazz, RowMapper<T> mapper, Object objId, boolean throwException) {
        Connection conn;
        InterceptorContext ctx;
        T model;
        PreparedStatement ps;
        ResultSet rs;
        SQLResult result;
        HashMap<String, Object> paras;
        TableDesc table;
        block15: {
            MetadataManager mm = this.sm.getDbStyle().getMetadataManager();
            table = mm.getTable(this.sm.getNc().getTableName(clazz));
            ClassDesc classDesc = table.getClassDesc(clazz, this.sm.getNc());
            paras = new HashMap<String, Object>();
            this.setIdsParas(classDesc, objId, paras);
            this.checkAnnotatonBeforeSelect(clazz, paras);
            result = this.run(paras);
            String sql = result.jdbcSql;
            List<SQLParameter> objs = result.jdbcPara;
            rs = null;
            ps = null;
            model = null;
            ctx = this.callInterceptorAsBefore(this.id, sql, false, objs, paras);
            if (ctx.getResult() != null) {
                this.callInterceptorAsAfter(ctx, ctx.getResult());
                return (T)ctx.getResult();
            }
            sql = ctx.getSql();
            objs = ctx.getParas();
            conn = null;
            conn = this.sm.getDs().getConn(this.id, false, sql, objs);
            ps = conn.prepareStatement(sql);
            this.setPreparedStatementPara(ps, objs);
            rs = ps.executeQuery();
            BeanProcessor beanProcessor = this.getBeanProcessor();
            if (rs.next()) {
                model = beanProcessor.toBean(rs, clazz);
                break block15;
            }
            if (throwException) {
                throw new BeetlSQLException(12, "unique\u67e5\u8be2\uff0c\u4f46\u6570\u636e\u5e93\u672a\u627e\u5230\u7ed3\u679c\u96c6");
            }
            this.callInterceptorAsAfter(ctx, ctx.getResult());
            T t = null;
            this.clean(false, conn, ps, rs);
            return t;
        }
        try {
            if (mapper != null) {
                model = mapper.mapRow(model, rs, 1);
            }
            if (model != null && this.getListener() != null) {
                for (SQLResultListener listener : this.getListener()) {
                    listener.dataSelectd(Arrays.asList(model), paras, this.sm, result);
                }
            }
            {
                catch (BeetlSQLException ex) {
                    if (ex.code == 12) {
                        throw new BeetlSQLException(12, "unique\u67e5\u8be2" + table.getName() + ",\u4f46\u6570\u636e\u5e93\u672a\u627e\u5230\u7ed3\u679c\u96c6:\u4e3b\u952e\u662f" + objId);
                    }
                    throw ex;
                }
            }
            this.callInterceptorAsAfter(ctx, model);
            this.clean(false, conn, ps, rs);
        }
        catch (SQLException e) {
            try {
                this.callInterceptorAsException(ctx, e);
                throw new BeetlSQLException(1, e);
            }
            catch (Throwable throwable) {
                this.clean(false, conn, ps, rs);
                throw throwable;
            }
        }
        return model;
    }

    public int deleteById(Class<?> clazz, Object objId) {
        MetadataManager mm = this.sm.getDbStyle().getMetadataManager();
        TableDesc table = mm.getTable(this.sm.getNc().getTableName(clazz));
        ClassDesc classDesc = table.getClassDesc(clazz, this.sm.getNc());
        HashMap<String, Object> paras = new HashMap<String, Object>();
        this.setIdsParas(classDesc, objId, paras);
        SQLResult result = this.run(paras);
        String sql = result.jdbcSql;
        List<SQLParameter> objs = result.jdbcPara;
        InterceptorContext ctx = this.callInterceptorAsBefore(this.id, sql, true, objs, paras);
        sql = ctx.getSql();
        objs = ctx.getParas();
        int rs = 0;
        PreparedStatement ps = null;
        Connection conn = null;
        try {
            conn = this.sm.getDs().getConn(this.id, true, sql, objs);
            ps = conn.prepareStatement(sql);
            this.setPreparedStatementPara(ps, objs);
            rs = ps.executeUpdate();
            this.callInterceptorAsAfter(ctx, rs);
            this.clean(true, conn, ps);
        }
        catch (SQLException e) {
            try {
                this.callInterceptorAsException(ctx, e);
                throw new BeetlSQLException(1, e);
            }
            catch (Throwable throwable) {
                this.clean(true, conn, ps);
                throw throwable;
            }
        }
        return rs;
    }

    public <T> List<T> sqlReadySelect(Class<T> clazz, SQLReady p) {
        String sql = this.sql;
        List<SQLParameter> objs = this.toSQLParameters(p.getArgs());
        ResultSet rs = null;
        PreparedStatement ps = null;
        List<T> resultList = null;
        InterceptorContext ctx = this.callInterceptorAsBefore(this.id, sql, false, objs, this.getSQLReadyParas(Arrays.asList(p.getArgs())));
        sql = ctx.getSql();
        objs = ctx.getParas();
        Connection conn = null;
        try {
            conn = this.sm.getDs().getConn(this.id, false, sql, objs);
            ps = conn.prepareStatement(sql);
            this.setPreparedStatementPara(ps, objs);
            rs = ps.executeQuery();
            resultList = this.mappingSelect(rs, clazz);
            this.callInterceptorAsAfter(ctx, resultList);
            List<T> list = resultList;
            this.clean(false, conn, ps, rs);
            return list;
        }
        catch (SQLException e) {
            try {
                this.callInterceptorAsException(ctx, e);
                throw new BeetlSQLException(1, e);
            }
            catch (Throwable throwable) {
                this.clean(false, conn, ps, rs);
                throw throwable;
            }
        }
    }

    public int sqlReadyExecuteUpdate(SQLReady p) {
        String sql = this.sql;
        List<SQLParameter> objs = this.toSQLParameters(p.getArgs());
        InterceptorContext ctx = this.callInterceptorAsBefore(this.id, sql, true, objs, this.getSQLReadyParas(Arrays.asList(p.getArgs())));
        sql = ctx.getSql();
        objs = ctx.getParas();
        int rs = 0;
        PreparedStatement ps = null;
        Connection conn = null;
        try {
            conn = this.sm.getDs().getConn(this.id, true, sql, objs);
            ps = conn.prepareStatement(sql);
            this.setPreparedStatementPara(ps, objs);
            rs = ps.executeUpdate();
            this.callInterceptorAsAfter(ctx, rs);
            this.clean(true, conn, ps);
        }
        catch (SQLException e) {
            try {
                this.callInterceptorAsException(ctx, e);
                throw new BeetlSQLException(1, e);
            }
            catch (Throwable throwable) {
                this.clean(true, conn, ps);
                throw throwable;
            }
        }
        return rs;
    }

    public int[] sqlReadyBatchExecuteUpdate(SQLBatchReady batch) {
        String sql = this.sql;
        List<Object[]> args = batch.getArgs();
        if (args.isEmpty()) {
            return new int[0];
        }
        InterceptorContext ctx = null;
        Connection conn = null;
        Statement ps = null;
        int[] rs = null;
        try {
            for (int i = 0; i < args.size(); ++i) {
                Object[] jdbcArgs = args.get(i);
                List<SQLParameter> objs = this.toSQLParameters(jdbcArgs);
                if (i == 0) {
                    conn = this.sm.getDs().getConn(this.id, true, sql, objs);
                    ctx = this.callInterceptorAsBefore(this.id, sql, true, objs, this.getSQLReadyParas(Arrays.asList(jdbcArgs)));
                    ps = conn.prepareStatement(sql);
                }
                this.setPreparedStatementPara((PreparedStatement)ps, objs);
                ps.addBatch();
            }
            rs = ps.executeBatch();
            this.callInterceptorAsAfter(ctx, rs);
            this.clean(true, conn, (PreparedStatement)ps);
        }
        catch (SQLException e) {
            try {
                this.callInterceptorAsException(ctx, e);
                throw new BeetlSQLException(1, e);
            }
            catch (Throwable throwable) {
                this.clean(true, conn, (PreparedStatement)ps);
                throw throwable;
            }
        }
        return rs;
    }

    private void setPreparedStatementPara(PreparedStatement ps, List<SQLParameter> objs) throws SQLException {
        if (objs.isEmpty()) {
            return;
        }
        BeanProcessor beanProcessor = this.getBeanProcessor();
        beanProcessor.setPreparedStatementPara(this.sqlSource.getId(), ps, objs);
    }

    protected void clean(boolean isUpdate, Connection conn, PreparedStatement ps, ResultSet rs) {
        block8: {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (ps != null) {
                    ps.close();
                }
                if (this.sm.getDs().isTransaction()) break block8;
                try {
                    if (conn != null) {
                        if (isUpdate && !conn.getAutoCommit()) {
                            conn.commit();
                        }
                        conn.close();
                    }
                }
                catch (SQLException e) {
                    throw new BeetlSQLException(1, e);
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    protected void clean(boolean isUpdate, Connection conn, PreparedStatement ps) {
        this.clean(isUpdate, conn, ps, null);
    }

    protected void clean(Connection conn) {
        this.clean(true, conn, null, null);
    }

    private InterceptorContext callInterceptorAsBefore(String sqlId, String sql, boolean isUpdate, List<SQLParameter> jdbcParas, Map<String, Object> inputParas) {
        InterceptorContext ctx = new InterceptorContext(sqlId, sql, jdbcParas, inputParas, isUpdate);
        for (Interceptor in : this.sm.inters) {
            in.before(ctx);
        }
        return ctx;
    }

    private void callInterceptorAsAfter(InterceptorContext ctx, Object result) {
        if (this.sm.inters == null) {
            return;
        }
        if (!ctx.isUpdate()) {
            ctx.setResult(result);
        } else {
            ctx.setResult(result);
        }
        for (Interceptor in : this.sm.inters) {
            in.after(ctx);
        }
    }

    private void callInterceptorAsException(InterceptorContext ctx, Exception ex) {
        if (ctx == null) {
            return;
        }
        if (this.sm.inters == null) {
            return;
        }
        for (Interceptor in : this.sm.inters) {
            in.exception(ctx, ex);
        }
    }

    private Map<String, Object> getSQLReadyParas(List<Object> paras) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("_root", paras);
        return map;
    }

    public String getId() {
        return this.id;
    }

    private void setIdsParas(ClassDesc desc, Object obj, Map<String, Object> paras) {
        List<String> idAttrs = desc.getIdAttrs();
        if (idAttrs.size() == 1) {
            paras.put(idAttrs.get(0), obj);
        } else {
            Map<String, Object> map = desc.getIdMethods();
            for (int i = 0; i < idAttrs.size(); ++i) {
                String idCol = idAttrs.get(i);
                String idAttr = idAttrs.get(i);
                Method m = (Method)map.get(idAttr);
                try {
                    Object os = m.invoke(obj, new Object[0]);
                    paras.put(idAttr, os);
                    continue;
                }
                catch (Exception ex) {
                    throw new BeetlSQLException(14, "\u65e0\u6cd5\u8bbe\u7f6e\u590d\u5408\u4e3b\u952e:" + idCol, ex);
                }
            }
        }
    }

    private void addParaIfAssignId(Object obj) {
        if (obj instanceof Map) {
            return;
        }
        if (obj == null) {
            return;
        }
        SQLTableSource tableSource = (SQLTableSource)this.sqlSource;
        Class<?> clz = obj.getClass();
        if (tableSource.getIdType() == 1 && tableSource.getAssignIds() != null) {
            Map<String, AssignID> ids = tableSource.getAssignIds();
            for (Map.Entry<String, AssignID> entry : ids.entrySet()) {
                String attrName = entry.getKey();
                Object value = BeanKit.getBeanProperty(obj, attrName);
                if (!StringKit.isNullOrEmpty(value)) continue;
                AssignID assignId = entry.getValue();
                String algorithm = assignId.value();
                String param = assignId.param();
                Object o = this.sm.getAssignIdByIdAutonGen(algorithm, param, tableSource.getTableDesc().getName());
                BeanKit.setBeanProperty(obj, o, attrName);
            }
        }
    }

    private List<SQLParameter> toSQLParameters(Object[] args) {
        ArrayList<SQLParameter> paras = new ArrayList<SQLParameter>(args.length);
        for (Object arg : args) {
            paras.add(new SQLParameter(arg));
        }
        return paras;
    }

    public String getSql() {
        return this.sql;
    }

    public List<SQLResultListener> getListener() {
        return this.listener;
    }

    public void setListener(List<SQLResultListener> listener) {
        this.listener = listener;
    }
}

