/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core.kit;

import java.util.Map;
import org.beetl.sql.core.kit.SqlFormatter;

public final class PageKit {
    static String pageNumberName = "pageNumber";
    static String pageSizeName = "pageSize";
    static int pageSizeValue = 20;

    public static String formatSql(String sql) {
        return SqlFormatter.format(sql);
    }

    public static int getPageNumber(Map<String, Object> paras) {
        Integer pageNumber = (Integer)paras.get(pageNumberName);
        return pageNumber == null ? 1 : pageNumber;
    }

    public static int getPageSize(Map<String, Object> paras) {
        Integer pageSize = (Integer)paras.get(pageSizeName);
        return pageSize == null ? pageSizeValue : pageSize;
    }

    public static String getCountSql(String selectSql) {
        selectSql = PageKit.formatSql(selectSql);
        String sql = selectSql.toLowerCase();
        int orderByIndex = sql.indexOf("\n    order by");
        int fromIndex = sql.indexOf("\n    from");
        if (orderByIndex != -1) {
            return "select count(1) \n" + selectSql.substring(fromIndex, orderByIndex);
        }
        return "select count(1) \n" + selectSql.substring(fromIndex);
    }

    public static void main(String[] args) {
        String sql = "select * from xxx where a=1 group a  order by a desc";
        sql = PageKit.getCountSql(sql);
        System.out.println(sql);
    }
}

