package org.beetl.sql.core;

import org.beetl.sql.core.db.ClassAnnotation;

import java.util.ArrayList;
import java.util.List;


public abstract class NameConversion {
	/****
	 * 根据实体class获取表名
	 * @param c
	 * @returnNameConversion
	 */
	public abstract String getTableName(Class<?> c);
	
	
	/**  不一定要实现，主要用于根据表生成java代码
	 * @param tableName
	 * @return
	 */
	public  String getClassName(String tableName){
		return tableName;
	}
	
	public  String getColName(String attrName){
		return getColName(null,attrName);
	}
	/****
	 * 根据class和属性名，获取字段名，此字段必须存在表中，否则返回空
	 * @param c
	 * @param attrName
	 * @return
	 */
	public abstract String getColName(Class<?> c,String attrName);
		/****
	 * 根据class和colName获取属性名
	 * @param c
	 * @param colName
	 * @return
	 */
	public abstract String getPropertyName(Class<?> c,String colName);
	
	public  String getPropertyName(String colName){
		return getPropertyName(null,colName);
	}
	/***
	 *  根据class获取表中所有的id
	 * @return
	 */
	public List<String> getId(){
		List<String> list = new ArrayList<String>();
		list.add("id");
		return list;
	}


	protected  String getAnnotationColName(Class c,String attrName){
		if(c==null){
			return null;
		}
		ClassAnnotation classAnnotation = ClassAnnotation.getClassAnnotation(c);
		String col = classAnnotation.getAttrAnnotationName().get(attrName);
		return col;
	}

	protected  String getAnnotationAttrName(Class c,String colName){
		if(c==null){
			return null;
		}
		ClassAnnotation classAnnotation = ClassAnnotation.getClassAnnotation(c);
		String attr = (String)classAnnotation.getColAnnotationName().get(colName);
		return attr;
	}


}
