/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core.misc;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.beetl.android.util.Log;
import org.beetl.core.GroupTemplate;
import org.beetl.core.config.BeetlConfig;

public class ClassSearch {
    private static final boolean DEBUG = BeetlConfig.DEBUG;
    private static final String TAG = "ClassSearch";
    final Map<String, Class> nameClassCache = new ConcurrentHashMap<String, Class>();
    final Set<String> pkgList;
    final GroupTemplate gt;

    public ClassSearch(Set<String> pkgList, GroupTemplate gt) {
        this.pkgList = pkgList;
        this.gt = gt;
    }

    public Class getClassByName(String name) {
        ClassLoader classLoader = this.gt.getClassLoader();
        if (name.contains(".")) {
            try {
                return Class.forName(name, true, classLoader);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }
        Class<?> cls = this.nameClassCache.get(name);
        if (cls != null) {
            return cls;
        }
        for (String pkg : this.pkgList) {
            try {
                String clsName = pkg.concat(name);
                cls = Class.forName(clsName, true, classLoader);
                this.nameClassCache.put(name, cls);
                return cls;
            }
            catch (Exception ex) {
                if (!DEBUG) continue;
                Log.d(TAG, ex.toString());
            }
        }
        return null;
    }
}

