/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core.runtime.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.beetl.android.util.SparseArray;
import org.beetl.core.runtime.IBeetlMemoryManager;

public class DefaultBeetlMemoryManager
implements IBeetlMemoryManager {
    private static IBeetlMemoryManager sInstance;
    private static final int MAP_POOL_MAX_SIZE = 200;
    private static final int LIST_POOL_MAX_SIZE = 200;
    private static final int SET_POOL_MAX_SIZE = 200;
    private static final int OBJECT_POOL_MAX_SIZE = 100;
    private LinkedList<Map> mMapPool;
    private LinkedList<List> mListPool;
    private LinkedList<Set> mSetPool;
    private SparseArray<LinkedList<IBeetlMemoryManager.Clearable>> mTypeObjectPoolMap;

    private DefaultBeetlMemoryManager() {
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IBeetlMemoryManager get() {
        if (sInstance != null) return sInstance;
        Class<DefaultBeetlMemoryManager> clazz = DefaultBeetlMemoryManager.class;
        synchronized (DefaultBeetlMemoryManager.class) {
            if (sInstance != null) return sInstance;
            sInstance = new DefaultBeetlMemoryManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    private void init() {
        this.mMapPool = new LinkedList();
        this.mListPool = new LinkedList();
        this.mSetPool = new LinkedList();
        this.mTypeObjectPoolMap = new SparseArray();
    }

    @Override
    public Map takeMap() {
        return this.mMapPool.isEmpty() ? new HashMap() : this.mMapPool.removeLast();
    }

    @Override
    public boolean recoveryMap(Map garbage) {
        if (garbage == null) {
            return false;
        }
        if (this.mMapPool.size() > 200) {
            return false;
        }
        garbage.clear();
        this.mMapPool.addLast(garbage);
        return true;
    }

    @Override
    public int sizeOfMapPool() {
        return this.mMapPool.size();
    }

    @Override
    public Set takeSet() {
        return this.mSetPool.isEmpty() ? new HashSet() : this.mSetPool.removeLast();
    }

    @Override
    public boolean recoverySet(Set garbage) {
        if (garbage == null) {
            return false;
        }
        if (this.mSetPool.size() > 200) {
            return false;
        }
        garbage.clear();
        this.mSetPool.addLast(garbage);
        return true;
    }

    @Override
    public int sizeOfSetPool() {
        return 0;
    }

    @Override
    public List takeList() {
        return this.mListPool.isEmpty() ? new ArrayList() : this.mListPool.removeLast();
    }

    @Override
    public boolean recoveryList(List garbage) {
        if (garbage == null) {
            return false;
        }
        if (this.mListPool.size() > 200) {
            return false;
        }
        garbage.clear();
        this.mListPool.addLast(garbage);
        return true;
    }

    @Override
    public int sizeOfListPool() {
        return this.mListPool.size();
    }

    @Override
    public boolean recoveryObject(Class<IBeetlMemoryManager.Clearable> type, IBeetlMemoryManager.Clearable garbage) {
        if (garbage == null) {
            return false;
        }
        int key = type.hashCode();
        LinkedList<IBeetlMemoryManager.Clearable> pool = this.mTypeObjectPoolMap.get(key, new LinkedList());
        if (pool.size() > 100) {
            return false;
        }
        garbage.clear();
        pool.addLast(garbage);
        this.mTypeObjectPoolMap.put(key, pool);
        return true;
    }

    @Override
    public IBeetlMemoryManager.Clearable takeObject(Class<IBeetlMemoryManager.Clearable> type) {
        int key = type.hashCode();
        LinkedList pool = this.mTypeObjectPoolMap.get(key, new LinkedList());
        if (!pool.isEmpty()) {
            IBeetlMemoryManager.Clearable result = (IBeetlMemoryManager.Clearable)pool.removeLast();
            this.mTypeObjectPoolMap.put(key, pool);
            return result;
        }
        try {
            return type.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            return null;
        }
    }

    @Override
    public int sizeOfObjectType() {
        return this.mTypeObjectPoolMap.size();
    }

    @Override
    public int sizeOfObjectPool() {
        int length = 0;
        for (int i = 0; i < this.mTypeObjectPoolMap.size(); ++i) {
            LinkedList<IBeetlMemoryManager.Clearable> pool = this.mTypeObjectPoolMap.get(i);
            length += pool.size();
        }
        return length;
    }

    @Override
    public void clearMemory() {
        for (Map map : this.mMapPool) {
            map.clear();
        }
        for (List list : this.mListPool) {
            list.clear();
        }
        for (Set set : this.mSetPool) {
            set.clear();
        }
        for (int i = 0; i < this.mTypeObjectPoolMap.size(); ++i) {
            LinkedList<IBeetlMemoryManager.Clearable> objectPool = this.mTypeObjectPoolMap.get(i);
            while (!objectPool.isEmpty()) {
                IBeetlMemoryManager.Clearable object = objectPool.pollLast();
                object.clear();
            }
        }
        this.init();
    }

    public String toString() {
        return "DefaultBeetlMemoryManager{mapPool=" + this.mMapPool + ", listPool=" + this.mListPool + ", setPool=" + this.mSetPool + ", typeObjectPoolMap=" + this.mTypeObjectPoolMap + '}';
    }
}

