/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core.log;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.net.UnknownHostException;

public final class Log {
    public static final int VERBOSE = 2;
    public static final int DEBUG = 3;
    public static final int INFO = 4;
    public static final int WARN = 5;
    public static final int ERROR = 6;
    public static final String VERBOSE_TEXT = "V";
    public static final String DEBUG_TEXT = "D";
    public static final String INFO_TEXT = "I";
    public static final String WARN_TEXT = "W";
    public static final String ERROR_TEXT = "E";

    private Log() {
    }

    public static int v(String tag, String msg) {
        return Log.println(2, tag, msg);
    }

    public static int v(String tag, String msg, Throwable tr) {
        return Log.println(2, tag, msg + '\n' + Log.getStackTraceString(tr));
    }

    public static int d(String tag, String msg) {
        return Log.println(3, tag, msg);
    }

    public static int d(String tag, String msg, Throwable tr) {
        return Log.println(3, tag, msg + '\n' + Log.getStackTraceString(tr));
    }

    public static int i(String tag, String msg) {
        return Log.println(4, tag, msg);
    }

    public static int i(String tag, String msg, Throwable tr) {
        return Log.println(4, tag, msg + '\n' + Log.getStackTraceString(tr));
    }

    public static int w(String tag, String msg) {
        return Log.println(5, tag, msg);
    }

    public static int w(String tag, String msg, Throwable tr) {
        return Log.println(5, tag, msg + '\n' + Log.getStackTraceString(tr));
    }

    public static int w(String tag, Throwable tr) {
        return Log.println(5, tag, Log.getStackTraceString(tr));
    }

    public static int e(String tag, String msg) {
        return Log.println(6, tag, msg);
    }

    public static int e(String tag, String msg, Throwable tr) {
        return Log.println(6, tag, msg + '\n' + Log.getStackTraceString(tr));
    }

    public static String getStackTraceString(Throwable tr) {
        if (tr == null) {
            return "";
        }
        for (Throwable t = tr; t != null; t = t.getCause()) {
            if (!(t instanceof UnknownHostException)) continue;
            return "";
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        tr.printStackTrace(pw);
        pw.flush();
        return sw.toString();
    }

    public static int println(int priority, String tag, String msg) {
        String priorityText;
        switch (priority) {
            case 3: {
                priorityText = DEBUG_TEXT;
                break;
            }
            case 4: {
                priorityText = INFO_TEXT;
                break;
            }
            case 5: {
                priorityText = WARN_TEXT;
                break;
            }
            case 6: {
                priorityText = ERROR_TEXT;
                break;
            }
            default: {
                priorityText = VERBOSE_TEXT;
            }
        }
        System.out.println(priorityText + "/" + tag + ": " + msg);
        return 0;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface LogLevelId {
    }
}

