/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core.resource;

import org.beetl.core.log.Log;
import org.beetl.core.resource.Matcher;

public class StartsWithMatcher
implements Matcher {
    private static final String TAG = "org.beetl.core.lab.StartsWithMatcher";
    private String prefix;
    private int prefixLen = 0;
    private boolean withPrefix = false;

    public StartsWithMatcher() {
    }

    public StartsWithMatcher(String prefix) {
        this.prefix = prefix;
        this.prefixLen = prefix.length();
    }

    public StartsWithMatcher withPrefix() {
        this.withPrefix = true;
        return this;
    }

    public StartsWithMatcher withoutPrefix() {
        this.withPrefix = false;
        return this;
    }

    @Override
    public String match(String key) {
        return !key.startsWith(this.prefix) ? null : (this.withPrefix ? key : key.substring(this.prefixLen));
    }

    public final boolean isWithPrefix() {
        return this.withPrefix;
    }

    public final void setWithPrefix(boolean withPrefix) {
        this.withPrefix = withPrefix;
    }

    public final String getPrefix() {
        return this.prefix;
    }

    public final void setPrefix(String prefix) {
        this.prefix = prefix;
        this.prefixLen = prefix.length();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.prefix == null ? 0 : this.prefix.hashCode());
        result = 31 * result + this.prefixLen;
        result = 31 * result + (this.withPrefix ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof StartsWithMatcher)) {
            return false;
        }
        StartsWithMatcher other = (StartsWithMatcher)obj;
        if (this.prefix == null ? other.prefix != null : !this.prefix.equals(other.prefix)) {
            return false;
        }
        return this.prefixLen == other.prefixLen && this.withPrefix == other.withPrefix;
    }

    public String toString() {
        return "StartsWithMatcher " + this.prefix;
    }

    public static void main(String[] args) {
        StartsWithMatcher swm = new StartsWithMatcher("/com/wellbole").withoutPrefix();
        Log.i(TAG, swm.match("/com/wellbole/app/pg/index.html"));
        swm = new StartsWithMatcher("/com/wellbole").withPrefix();
        Log.i(TAG, swm.match("/com/wellbole/app/pg/index.html"));
    }
}

