/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core.engine;

import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import org.beetl.core.Context;
import org.beetl.core.GroupTemplate;
import org.beetl.core.Resource;
import org.beetl.core.engine.DefaultTemplateEngine;
import org.beetl.core.engine.GrammarCreator;
import org.beetl.core.exception.BeetlException;
import org.beetl.core.statement.Expression;
import org.beetl.core.statement.GeneralForStatement;
import org.beetl.core.statement.GrammarToken;
import org.beetl.core.statement.Program;
import org.beetl.core.statement.Statement;
import org.beetl.core.statement.VarAssignSeqStatement;
import org.beetl.core.statement.WhileStatement;

public class OnlineTemplateEngine
extends DefaultTemplateEngine {
    public static int MAX_NUM_LOOP = 5;
    public static String MAX_NUM_LOOP_ERROR = "\u9519\u8bef:\u5728\u7ebf\u5f15\u64ce\u4e0d\u5141\u8bb8\u5faa\u73af\u6b21\u6570\u8d85\u8fc7  " + MAX_NUM_LOOP;

    @Override
    public Program createProgram(Resource rs, Reader reader, Map<Integer, String> textMap, String cr, GroupTemplate gt) {
        return super.createProgram(rs, reader, textMap, cr, gt);
    }

    @Override
    protected GrammarCreator getGrammarCreator(GroupTemplate groupTemplate) {
        OnlineGrammarCreator result = new OnlineGrammarCreator();
        super.setStrictDisableGrammars(result, groupTemplate);
        return result;
    }

    private static class RestrictWhileStatement
    extends WhileStatement {
        public RestrictWhileStatement(Expression exp, Statement whileBody, GrammarToken token) {
            super(exp, whileBody, token);
        }

        @Override
        public void execute(Context ctx) {
            int i;
            for (i = 0; i < MAX_NUM_LOOP; ++i) {
                Object result = this.exp.evaluate(ctx);
                if (result instanceof Boolean) {
                    if (!((Boolean)result).booleanValue()) break;
                } else {
                    BeetlException be = new BeetlException("BOOLEAN_EXPECTED_ERROR");
                    be.token = this.exp.token;
                    throw be;
                }
                this.whileBody.execute(ctx);
            }
            if (i >= MAX_NUM_LOOP) {
                try {
                    ctx.byteWriter.writeString(MAX_NUM_LOOP_ERROR);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    private static class RestrictForStatement
    extends GeneralForStatement {
        public RestrictForStatement(VarAssignSeqStatement varAssignSeq, Expression[] expInit, Expression condition, Expression[] expUpdate, Statement forPart, Statement elseforPart, GrammarToken token) {
            super(varAssignSeq, expInit, condition, expUpdate, forPart, elseforPart, token);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void execute(Context ctx) {
            boolean bool;
            int i;
            if (this.expInit != null) {
                for (Expression exp : this.expInit) {
                    exp.evaluate(ctx);
                }
            }
            if (this.varAssignSeq != null) {
                this.varAssignSeq.execute(ctx);
            }
            block9: for (i = 0; i < MAX_NUM_LOOP && (bool = ((Boolean)this.condition.evaluate(ctx)).booleanValue()); ++i) {
                this.forPart.execute(ctx);
                switch (ctx.gotoFlag) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        ctx.gotoFlag = 0;
                        continue block9;
                    }
                    case 3: {
                        return;
                    }
                    case 2: {
                        ctx.gotoFlag = 0;
                        return;
                    }
                }
                if (this.expUpdate == null) continue;
                for (Expression exp : this.expUpdate) {
                    exp.evaluate(ctx);
                }
            }
            if (i < MAX_NUM_LOOP) return;
            try {
                ctx.byteWriter.writeString(MAX_NUM_LOOP_ERROR);
                ctx.byteWriter.flush();
                return;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static class OnlineGrammarCreator
    extends GrammarCreator {
        private OnlineGrammarCreator() {
        }

        @Override
        public GeneralForStatement createFor(VarAssignSeqStatement varAssignSeq, Expression[] expInit, Expression condition, Expression[] expUpdate, Statement forPart, Statement elseforPart, GrammarToken token) {
            return new RestrictForStatement(varAssignSeq, expInit, condition, expUpdate, forPart, elseforPart, token);
        }

        @Override
        public WhileStatement createWhile(Expression exp, Statement whileBody, GrammarToken token) {
            return new RestrictWhileStatement(exp, whileBody, token);
        }
    }
}

