/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core.statement;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import org.beetl.core.Context;
import org.beetl.core.exception.BeetlException;
import org.beetl.core.fun.ObjectUtil;
import org.beetl.core.misc.BeetlUtil;
import org.beetl.core.om.ObjectMethodMatchConf;
import org.beetl.core.statement.Expression;
import org.beetl.core.statement.GrammarToken;
import org.beetl.core.statement.nat.ClassNode;
import org.beetl.core.statement.nat.InstanceNode;
import org.beetl.core.statement.nat.NativeArrayNode;
import org.beetl.core.statement.nat.NativeAtrributeNode;
import org.beetl.core.statement.nat.NativeMethodNode;
import org.beetl.core.statement.nat.NativeNode;

public class NativeCallExpression
extends Expression {
    InstanceNode insNode;
    ClassNode clsNode;
    NativeNode[] chain;

    public NativeCallExpression(InstanceNode insNode, NativeNode[] chain, GrammarToken token) {
        super(token);
        this.insNode = insNode;
        this.chain = chain;
    }

    public NativeCallExpression(ClassNode clsNode, NativeNode[] chain, GrammarToken token) {
        super(token);
        this.clsNode = clsNode;
        this.chain = chain;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object evaluate(Context ctx) {
        Object var2_2 = null;
        Object targetObj = null;
        Object var4_16 = null;
        if (this.insNode != null) {
            targetObj = this.insNode.ref.evaluate(ctx);
            if (targetObj != null) {
                Class<?> clazz = targetObj.getClass();
            }
            InstanceNode instanceNode = this.insNode;
        } else {
            Class clazz = ctx.gt.loadClassBySimpleName(this.clsNode.cls);
            if (clazz == null) {
                BeetlException be = new BeetlException("NATIVE_CALL_EXCEPTION", "\u8be5\u7c7b\u4e0d\u5b58\u5728");
                be.pushToken(GrammarToken.createToken(this.clsNode.cls, this.token.line));
                throw be;
            }
            ClassNode classNode = this.clsNode;
        }
        NativeNode[] nativeNodeArray = this.chain;
        int n = nativeNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            void var4_20;
            void var2_7;
            NativeNode node = nativeNodeArray[n2];
            if (node instanceof NativeAtrributeNode) {
                String attr = ((NativeAtrributeNode)node).attribute;
                try {
                    this.checkNull(var2_7, (NativeNode)var4_20);
                    Field f = var2_7.getField(attr);
                    if (!Modifier.isStatic(f.getModifiers())) {
                        this.checkNull(targetObj, (NativeNode)var4_20);
                    }
                    targetObj = f.get(targetObj);
                    Class<?> clazz = f.getType();
                }
                catch (SecurityException e) {
                    BeetlException be = new BeetlException("NATIVE_CALL_EXCEPTION", "\u4e0d\u80fd\u8c03\u7528\u5c5e\u6027", e);
                    be.pushToken(GrammarToken.createToken(attr, this.token.line));
                    throw be;
                }
                catch (NoSuchFieldException e) {
                    BeetlException be = new BeetlException("NATIVE_CALL_EXCEPTION", "\u65e0\u6b64\u5c5e\u6027", e);
                    be.pushToken(GrammarToken.createToken(attr, this.token.line));
                    throw be;
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    BeetlException be = new BeetlException("NATIVE_CALL_EXCEPTION", "\u8bbf\u95ee\u5c5e\u6027\u51fa\u9519", e);
                    be.pushToken(GrammarToken.createToken(attr, this.token.line));
                    throw be;
                }
            }
            if (node instanceof NativeArrayNode) {
                this.checkNull(var2_7, (NativeNode)var4_20);
                if (!var2_7.isArray()) {
                    BeetlException be = new BeetlException("ARRAY_TYPE_ERROR");
                    be.pushToken(GrammarToken.createToken("[]", this.token.line));
                    throw be;
                }
                Expression exp = ((NativeArrayNode)node).exp;
                Object value = exp.evaluate(ctx);
                if (!(value instanceof Number)) {
                    BeetlException be = new BeetlException("ARRAY_INDEX_ERROR", "\u6570\u7ec4\u6307\u9488\u5fc5\u987b\u662fNumber\u7c7b\u578b");
                    be.pushToken(GrammarToken.createToken("[]", this.token.line));
                    throw be;
                }
                int index = ((Number)value).intValue();
                if ((targetObj = ((Object[])targetObj)[index]) != null) {
                    Class<?> clazz = targetObj.getClass();
                } else {
                    Object var2_10 = null;
                }
            } else if (node instanceof NativeMethodNode) {
                NativeMethodNode methodNode = (NativeMethodNode)node;
                String method = methodNode.method;
                Expression[] expList = methodNode.paras;
                this.checkPermit(ctx, (Class)var2_7, targetObj, method);
                Object[] args = expList.length == 0 ? ObjectUtil.EMPTY_OBJECT_ARRAY : new Object[expList.length];
                Class[] parameterType = new Class[args.length];
                for (int i = 0; i < expList.length; ++i) {
                    args[i] = expList[i].evaluate(ctx);
                    parameterType[i] = args[i] == null ? null : args[i].getClass();
                }
                this.checkNull(var2_7, (NativeNode)var4_20);
                ObjectMethodMatchConf mf = ObjectUtil.findMethod((Class)var2_7, method, parameterType);
                if (mf == null) {
                    BeetlException ex = new BeetlException("NATIVE_CALL_INVALID", "\u6839\u636e\u53c2\u6570\u672a\u627e\u5230\u5339\u914d\u7684\u65b9\u6cd5" + method + BeetlUtil.getParameterDescription(parameterType));
                    ex.pushToken(GrammarToken.createToken(this.token.text, this.token.line));
                    throw ex;
                }
                if (targetObj == null && !Modifier.isStatic(mf.method.getModifiers())) {
                    BeetlException ex = new BeetlException("NULL");
                    ex.pushToken(GrammarToken.createToken(this.token.text, this.token.line));
                    throw ex;
                }
                try {
                    targetObj = ObjectUtil.invoke(targetObj, mf, args);
                    if (targetObj != null) {
                        Class<?> clazz = targetObj.getClass();
                    } else {
                        Object var2_13 = null;
                    }
                }
                catch (SecurityException e) {
                    BeetlException be = new BeetlException("NATIVE_CALL_EXCEPTION", "\u4e0d\u80fd\u8c03\u7528\u65b9\u6cd5", e);
                    be.pushToken(GrammarToken.createToken(method, this.token.line));
                    throw be;
                }
                catch (IllegalArgumentException e) {
                    BeetlException be = new BeetlException("NATIVE_CALL_EXCEPTION", "\u9519\u8bef\u7684\u53c2\u6570", e);
                    be.pushToken(GrammarToken.createToken(method, this.token.line));
                    throw be;
                }
                catch (IllegalAccessException e) {
                    BeetlException be = new BeetlException("NATIVE_CALL_EXCEPTION", "\u65e0\u6cd5\u8bbf\u95ee\u65b9\u6cd5", e);
                    be.pushToken(GrammarToken.createToken(method, this.token.line));
                    throw be;
                }
                catch (InvocationTargetException e) {
                    BeetlException be = new BeetlException("NATIVE_CALL_EXCEPTION", "\u5185\u90e8\u8c03\u7528\u62a5\u9519", e.getTargetException());
                    be.pushToken(GrammarToken.createToken(method, this.token.line));
                    throw be;
                }
            }
            NativeNode nativeNode = node;
            ++n2;
        }
        return targetObj;
    }

    private void checkNull(Object o, NativeNode node) {
        if (o == null) {
            BeetlException be = new BeetlException("NULL");
            be.pushToken(GrammarToken.createToken(node.getName(), this.token.line));
            throw be;
        }
    }

    private void checkPermit(Context ctx, Class targetCls, Object targetObj, String method) {
        if (targetCls == null) {
            return;
        }
        if (!ctx.gt.getNativeSecurity().permit(ctx.template.program.res.getId(), targetCls, targetObj, method)) {
            BeetlException be = new BeetlException("NATIVE_SECUARITY_EXCEPTION");
            be.pushToken(GrammarToken.createToken(method, this.token.line));
            throw be;
        }
    }
}

