/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.beetl.core.Configuration;
import org.beetl.core.Context;
import org.beetl.core.ContextBuffer;
import org.beetl.core.ContextLocalBuffers;
import org.beetl.core.DefaultTagFactory;
import org.beetl.core.ErrorHandler;
import org.beetl.core.Event;
import org.beetl.core.Format;
import org.beetl.core.Function;
import org.beetl.core.Listener;
import org.beetl.core.NativeSecurityManager;
import org.beetl.core.Resource;
import org.beetl.core.ResourceLoader;
import org.beetl.core.Script;
import org.beetl.core.Template;
import org.beetl.core.TemplateEngine;
import org.beetl.core.TemplateEngineFactory;
import org.beetl.core.TemplateProxy;
import org.beetl.core.VirtualAttributeEval;
import org.beetl.core.VirtualClassAttribute;
import org.beetl.core.cache.Cache;
import org.beetl.core.cache.ProgramCacheFactory;
import org.beetl.core.exception.BeetlException;
import org.beetl.core.exception.HTMLTagParserException;
import org.beetl.core.fun.FunctionWrapper;
import org.beetl.core.fun.ObjectUtil;
import org.beetl.core.misc.BeetlUtil;
import org.beetl.core.misc.ClassSearch;
import org.beetl.core.misc.PrimitiveArrayUtil;
import org.beetl.core.om.AABuilder;
import org.beetl.core.statement.ErrorGrammarProgram;
import org.beetl.core.statement.Program;
import org.beetl.core.tag.TagFactory;
import org.beetl.core.text.AttributeNameConvert;
import org.beetl.core.text.TextParser;

public class GroupTemplate {
    ClassLoader classLoader = Thread.currentThread().getContextClassLoader() != null ? Thread.currentThread().getContextClassLoader() : GroupTemplate.class.getClassLoader();
    AABuilder attributeAccessFactory = new AABuilder();
    ResourceLoader resourceLoader = null;
    Configuration conf = null;
    TemplateEngine engine = null;
    Cache programCache = ProgramCacheFactory.defaultCache();
    List<Listener> ls = new ArrayList<Listener>();
    Map<String, Function> fnMap = new HashMap<String, Function>();
    Map<String, Format> formatMap = new HashMap<String, Format>();
    Map<Class, Format> defaultFormatMap = new HashMap<Class, Format>(0);
    List<VirtualAttributeEval> virtualAttributeList = new ArrayList<VirtualAttributeEval>();
    Map<Class, VirtualClassAttribute> virtualClass = new HashMap<Class, VirtualClassAttribute>();
    Map<String, TagFactory> tagFactoryMap = new HashMap<String, TagFactory>();
    ClassSearch classSearch = null;
    NativeSecurityManager nativeSecurity = null;
    ErrorHandler errorHandler = null;
    Map<String, Object> sharedVars = null;
    ContextLocalBuffers buffers = null;
    AttributeNameConvert htmlTagAttrNameConvert = null;

    public GroupTemplate() {
        try {
            this.conf = Configuration.defaultConfiguration();
            this.init();
            this.initResourceLoader();
        }
        catch (Exception ex) {
            throw new RuntimeException("\u521d\u59cb\u5316\u5931\u8d25", ex);
        }
    }

    public GroupTemplate(Configuration conf) {
        try {
            this.conf = conf;
            this.init();
            this.initResourceLoader();
        }
        catch (Exception ex) {
            throw new RuntimeException("\u521d\u59cb\u5316\u5931\u8d25", ex);
        }
    }

    public GroupTemplate(ResourceLoader loader, Configuration conf) {
        this(loader, conf, null);
    }

    public GroupTemplate(ResourceLoader loader, Configuration conf, ClassLoader classLoader) {
        try {
            this.resourceLoader = loader;
            this.classLoader = classLoader == null ? this.classLoader : classLoader;
            this.conf = conf;
            this.init();
            this.initResourceLoader();
        }
        catch (Exception ex) {
            throw new IllegalStateException("\u521d\u59cb\u5316\u5931\u8d25 " + ex.getMessage(), ex);
        }
    }

    protected void initResourceLoader() {
        if (this.resourceLoader == null) {
            this.resourceLoader = (ResourceLoader)ObjectUtil.instance(this.conf.resourceLoader, this.classLoader);
        }
        this.resourceLoader.init(this);
    }

    protected void init() {
        this.conf.build();
        this.engine = TemplateEngineFactory.getEngine(this.conf.getEngine());
        this.initFunction();
        this.initFormatter();
        this.initTag();
        this.initVirtual();
        this.initBuffers();
        this.classSearch = new ClassSearch(this.conf.getPkgList(), this);
        this.nativeSecurity = (NativeSecurityManager)ObjectUtil.instance(this.conf.getNativeSecurity(), this.classLoader);
        this.errorHandler = this.conf.errorHandlerClass == null ? null : (ErrorHandler)ObjectUtil.instance(this.conf.errorHandlerClass, this.classLoader);
        this.htmlTagAttrNameConvert = (AttributeNameConvert)ObjectUtil.instance(this.conf.htmlTagAttributeConvert, this.classLoader);
    }

    protected void initFunction() {
        Map<String, String> fnMap = this.conf.fnMap;
        for (Map.Entry<String, String> entry : fnMap.entrySet()) {
            String name = entry.getKey();
            String clsName = entry.getValue();
            this.registerFunction(name, (Function)ObjectUtil.instance(clsName, this.classLoader));
        }
        Map<String, String> fnpMap = this.conf.fnPkgMap;
        for (Map.Entry<String, String> entry : fnpMap.entrySet()) {
            String name = entry.getKey();
            String clsName = entry.getValue();
            this.registerFunctionPackage(name, ObjectUtil.getClassByName(clsName, this.classLoader), ObjectUtil.tryInstance(clsName, this.classLoader));
        }
    }

    protected void initFormatter() {
        Map<String, String> formatMap = this.conf.formatMap;
        for (Map.Entry<String, String> entry : formatMap.entrySet()) {
            String name = entry.getKey();
            String string = entry.getValue();
            this.registerFormat(name, (Format)ObjectUtil.instance(string, this.classLoader));
        }
        Map<String, String> defaultFormatMap = this.conf.defaultFormatMap;
        HashMap<String, Format> temp = new HashMap<String, Format>();
        for (Map.Entry entry : defaultFormatMap.entrySet()) {
            String defaultType = (String)entry.getKey();
            String formatClass = (String)entry.getValue();
            Format format = (Format)temp.get(formatClass);
            if (format == null) {
                format = (Format)ObjectUtil.instance(formatClass, this.classLoader);
                temp.put(formatClass, format);
            }
            this.registerDefaultFormat(ObjectUtil.getClassByName(defaultType, this.classLoader), format);
        }
        Format numberFormat = (Format)temp.get("org.beetl.ext.format.NumberFormat");
        this.registerDefaultFormat(Short.TYPE, numberFormat);
        this.registerDefaultFormat(Long.TYPE, numberFormat);
        this.registerDefaultFormat(Integer.TYPE, numberFormat);
        this.registerDefaultFormat(Float.TYPE, numberFormat);
        this.registerDefaultFormat(Double.TYPE, numberFormat);
    }

    protected void initTag() {
        Map<String, String> tagMap = this.conf.tagMap;
        for (Map.Entry<String, String> entry : tagMap.entrySet()) {
            String name = entry.getKey();
            String clsName = entry.getValue();
            this.registerTag(name, ObjectUtil.getClassByName(clsName, this.classLoader));
        }
        Map<String, String> tagFactoryMap = this.conf.tagFactoryMap;
        for (Map.Entry<String, String> entry : tagFactoryMap.entrySet()) {
            String name = entry.getKey();
            String clsName = entry.getValue();
            this.registerTagFactory(name, (TagFactory)ObjectUtil.instance(clsName, this.classLoader));
        }
    }

    protected void initVirtual() {
        Map<String, String> map = this.conf.getVirtualClass();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String attr = entry.getKey();
            Class clz = ObjectUtil.getClassByName(entry.getValue(), this.classLoader);
            VirtualAttributeEval virtualAttributeEval = (VirtualAttributeEval)ObjectUtil.instance(entry.getValue(), this.classLoader);
            this.registerVirtualAttributeEval(virtualAttributeEval);
        }
    }

    protected void initBuffers() {
        this.buffers = new ContextLocalBuffers(this.conf.bufferNum, this.conf.bufferSize);
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public Script getScript(Object key) {
        return this.loadScriptTemplate(key, this.resourceLoader);
    }

    public Script getScript(Object key, ResourceLoader loader) {
        return this.loadScriptTemplate(key, loader);
    }

    public Map runScript(Object key, Map<String, Object> paras) throws BeetlException {
        return this.runScript(key, paras, new StringWriter());
    }

    public Map runScript(Object key, Map<String, Object> paras, Writer w) throws BeetlException {
        return this.runScript(key, paras, w, this.resourceLoader);
    }

    public Map runScript(Object key, Map<String, Object> paras, Writer w, ResourceLoader loader) throws BeetlException {
        Script t = this.loadScriptTemplate(key, loader);
        t.fastBinding(paras);
        t.renderTo(w);
        if (t.isSuccess()) {
            Map map = t.getResult();
            return map;
        }
        throw t.ex;
    }

    public BeetlException validateTemplate(Object key, ResourceLoader loader) {
        Template t = this.getTemplate(key, loader);
        return t.validate();
    }

    public BeetlException validateTemplate(Object key) {
        Template t = this.getTemplate(key, this.resourceLoader);
        return t.validate();
    }

    public BeetlException validateScript(Object key, ResourceLoader loader) {
        return this.loadScriptTemplate(key, loader).validate();
    }

    public BeetlException validateScript(Object key) {
        return this.loadScriptTemplate(key, this.resourceLoader).validate();
    }

    private Map getSrirptTopScopeVars(Template t) {
        Map<String, Integer> idnexMap = t.program.metaData.getTemplateRootScopeIndexMap();
        Object[] values = t.ctx.vars;
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<String, Integer> entry : idnexMap.entrySet()) {
            String name = entry.getKey();
            int index = entry.getValue();
            Object value = values[index];
            result.put(name, value);
        }
        if (values == null) {
            return null;
        }
        Object ret = t.ctx.vars[t.ctx.vars.length - 1];
        if (ret != Context.NOT_EXIST_OBJECT) {
            result.put("return", ret);
        }
        return result;
    }

    private Script loadScriptTemplate(Object key, ResourceLoader loader) {
        Program program = (Program)this.programCache.get(key, k -> this.loadScript(loader.getResource(key)));
        if (this.resourceLoader.isModified(program.res)) {
            Resource resource = loader.getResource(key);
            program = this.loadScript(resource);
            this.programCache.set(key, program);
        }
        return new Script(this, program, this.conf);
    }

    public Template getTemplate(Object key, ResourceLoader loader) {
        return this.getTemplateByLoader(key, loader, null);
    }

    public Template getAjaxTemplate(Object key, String ajaxId, ResourceLoader loader) {
        Template template = this.getTemplateByLoader(key, loader, null);
        template.ajaxId = ajaxId;
        return template;
    }

    public Template getTemplate(Object key, String parent, ResourceLoader loader) {
        Template template = this.getTemplate(key, loader);
        template.isRoot = false;
        return template;
    }

    public Template getTemplate(Object key, Context parent) {
        Template template = this.getTemplateByLoader(key, this.resourceLoader, parent.localBuffer);
        template.isRoot = false;
        return template;
    }

    public Template getTemplate(Object key) {
        return this.getTemplateByLoader(key, this.resourceLoader, null);
    }

    public Template getAjaxTemplate(Object key, String ajaxId) {
        Template t = this.getTemplateByLoader(key, this.resourceLoader, null);
        t.ajaxId = ajaxId;
        return t;
    }

    public Template getTemplateProxy(Template t) {
        return new TemplateProxy(t);
    }

    private Template getTemplateByLoader(Object key, ResourceLoader loader, ContextBuffer buffers) {
        Program program = (Program)this.programCache.get(key, k -> this.loadTemplate(loader.getResource(key)));
        if (this.resourceLoader.isModified(program.res)) {
            Resource resource = loader.getResource(key);
            program = this.loadTemplate(resource);
            this.programCache.set(key, program);
        }
        return buffers == null ? new Template(this, program, this.conf) : new Template(this, program, this.conf, buffers);
    }

    public Program getProgram(String key) {
        return (Program)this.programCache.get(key);
    }

    public boolean hasTemplate(String key) {
        Program program = (Program)this.programCache.get(key);
        return program != null;
    }

    public void removeTemplate(String key) {
        this.programCache.remove(key);
    }

    private Program loadTemplate(Resource res) {
        TextParser text = null;
        try {
            Reader reader = res.openReader();
            text = new TextParser(this, this.conf.getPlaceHolderDelimeter(), this.conf.getScriptDelimeter(), this.conf.getTagConf());
            text.doParse(reader);
            StringReader scriptReader = new StringReader(text.getScript().toString());
            return this.engine.createProgram(res, scriptReader, text.getTextVars(), text.getTextCr(), this);
        }
        catch (HTMLTagParserException e) {
            ErrorGrammarProgram ep = new ErrorGrammarProgram(res, this, TextParser.systemCrStr);
            ep.setException(e);
            e.pushResource(res);
            return ep;
        }
        catch (IOException e) {
            ErrorGrammarProgram ep = new ErrorGrammarProgram(res, this, String.valueOf('\n'));
            BeetlException ex = new BeetlException("TEMPLATE_LOAD_ERROR");
            ex.pushResource(res);
            ep.setException(ex);
            return ep;
        }
        catch (BeetlException ex) {
            ErrorGrammarProgram ep = new ErrorGrammarProgram(res, this, TextParser.systemCrStr);
            ex.pushResource(res);
            ep.setException(ex);
            return ep;
        }
    }

    private Program loadScript(Resource res) {
        try {
            Reader scriptReader = res.openReader();
            return this.engine.createProgram(res, scriptReader, Collections.EMPTY_MAP, System.getProperty("line.separator"), this);
        }
        catch (BeetlException ex) {
            ErrorGrammarProgram ep = new ErrorGrammarProgram(res, this, System.getProperty("line.separator"));
            ex.pushResource(res);
            ep.setException(ex);
            return ep;
        }
    }

    public void close() {
        this.resourceLoader.close();
    }

    public ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void fireEvent(Event event) {
        for (Listener l : this.ls) {
            l.onEvent(event);
        }
    }

    public void addListener(Listener listener) {
        this.ls.add(listener);
    }

    public Cache getProgramCache() {
        return this.programCache;
    }

    public void registerFunction(String name, Function fn) {
        this.checkFunctionName(name);
        this.fnMap.put(name, fn);
    }

    public void registerFunctionPackage(String packageName, Object o) {
        this.checkFunctionName(packageName);
        this.registerFunctionPackage(packageName, o.getClass(), o);
    }

    public void registerFunctionPackage(String packageName, Class cls) {
        this.checkFunctionName(packageName);
        Object o = ObjectUtil.tryInstance(cls.getName(), this.classLoader);
        this.registerFunctionPackage(packageName, cls, o);
    }

    public void registerFunctionPackageAsRoot(Class cls) {
        Object o = ObjectUtil.tryInstance(cls.getName(), this.classLoader);
        this.registerFunctionPackageAsRoot(cls, o);
    }

    private void checkFunctionName(String name) {
        if (!BeetlUtil.checkNameing(name)) {
            int[] log = BeetlUtil.getLog();
            throw new RuntimeException("\u6ce8\u518c\u65b9\u6cd5\u540d\u4e0d\u5408\u6cd5:" + name + ",\u9519\u8bef\u4f4d\u7f6e:" + log[0] + ",\u51fa\u73b0\u9519\u8bef\u7684\u5b57\u7b26:" + (char)log[1]);
        }
    }

    protected void registerFunctionPackage(String packageName, Class target, Object o) {
        if (packageName.equals("_root")) {
            this.registerFunctionPackageAsRoot(target, o);
        } else {
            List<FunctionWrapper> list = FunctionWrapper.getFunctionWrapper(packageName, target, o);
            for (FunctionWrapper fw : list) {
                this.registerFunction(fw.functionName, fw);
            }
        }
    }

    protected void registerFunctionPackageAsRoot(Class target, Object o) {
        String packageName = "_root";
        List<FunctionWrapper> list = FunctionWrapper.getFunctionWrapper(packageName, target, o);
        for (FunctionWrapper fw : list) {
            String functionName = fw.functionName.replace("_root.", "");
            this.registerFunction(functionName, fw);
        }
    }

    public void registerFormat(String name, Format format) {
        this.formatMap.put(name, format);
    }

    public void registerDefaultFormat(Class type, Format format) {
        this.defaultFormatMap.put(type, format);
    }

    public void registerTag(String name, Class tagCls) {
        this.checkTagName(name);
        this.tagFactoryMap.put(name, new DefaultTagFactory(tagCls));
    }

    public void registerTagFactory(String name, TagFactory tagFactory) {
        this.checkTagName(name);
        this.tagFactoryMap.put(name, tagFactory);
    }

    private void checkTagName(String name) {
        if (!BeetlUtil.checkNameing(name)) {
            int[] log = BeetlUtil.getLog();
            if (log[1] == 58) {
                throw new RuntimeException("\u6ce8\u518cTag\u540d\u79f0\u4e0d\u5408\u6cd5:" + name + ",\u9519\u8bef\u4f4d\u7f6e:" + log[0] + ",\u51fa\u73b0\u9519\u8bef\u7684\u5b57\u7b26:" + (char)log[1] + ",\u8bf7\u4f7f\u7528'.'");
            }
            throw new RuntimeException("\u6ce8\u518cTag\u540d\u79f0\u4e0d\u5408\u6cd5:" + name + ",\u9519\u8bef\u4f4d\u7f6e:" + log[0] + ",\u51fa\u73b0\u9519\u8bef\u7684\u5b57\u7b26:" + (char)log[1]);
        }
    }

    public TagFactory getTagFactory(String name) {
        return this.tagFactoryMap.get(name);
    }

    public Function getFunction(String name) {
        return this.fnMap.get(name);
    }

    public Format getFormat(String name) {
        return this.formatMap.get(name);
    }

    public Format getDefaultFormat(Class type) {
        return this.defaultFormatMap.get(type);
    }

    public void registerVirtualAttributeEval(VirtualAttributeEval e) {
        this.virtualAttributeList.add(e);
    }

    public void registerVirtualAttributeClass(Class cls, VirtualClassAttribute virtual) {
        this.virtualClass.put(cls, virtual);
    }

    public VirtualClassAttribute getVirtualAttributeEval(Class c, String attributeName) {
        VirtualClassAttribute attr = this.virtualClass.get(c);
        if (attr != null) {
            return attr;
        }
        for (VirtualAttributeEval eval : this.virtualAttributeList) {
            if (!eval.isSupport(c, attributeName)) continue;
            return eval;
        }
        return null;
    }

    public Class loadClassBySimpleName(String simpleName) {
        return this.classSearch.getClassByName(simpleName);
    }

    public NativeSecurityManager getNativeSecurity() {
        return this.nativeSecurity;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public Map<String, Object> getSharedVars() {
        if (this.sharedVars == null) {
            this.sharedVars = new HashMap<String, Object>();
        }
        return this.sharedVars;
    }

    public void setSharedVars(Map<String, Object> vars) {
        if (this.sharedVars != null) {
            this.sharedVars.putAll(vars);
        } else {
            this.sharedVars = vars;
        }
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public ClassSearch getClassSearch() {
        return this.classSearch;
    }

    public AABuilder getAttributeAccessFactory() {
        return this.attributeAccessFactory;
    }

    public void enableStrict() {
        this.conf.setStrict(true);
    }

    public TemplateEngine getEngine() {
        return this.engine;
    }

    public void setEngine(TemplateEngine engine) {
        this.engine = engine;
    }

    public AttributeNameConvert getHtmlTagAttrNameConvert() {
        return this.htmlTagAttrNameConvert;
    }

    public static class SizeVirtualAttributeEval
    implements VirtualAttributeEval {
        @Override
        public Integer eval(Object o, String attributeName, Context ctx) {
            if (attributeName.equals("size")) {
                if (o instanceof Collection) {
                    return ((Collection)o).size();
                }
                if (o instanceof Map) {
                    return ((Map)o).size();
                }
                if (o.getClass().isArray()) {
                    if (o.getClass().getComponentType().isPrimitive()) {
                        return PrimitiveArrayUtil.getSize(o);
                    }
                    return ((Object[])o).length;
                }
                throw new IllegalArgumentException();
            }
            throw new IllegalArgumentException();
        }

        @Override
        public boolean isSupport(Class c, String attributeName) {
            return (Map.class.isAssignableFrom(c) || Collection.class.isAssignableFrom(c) || c.isArray()) && attributeName.equals("size");
        }
    }
}

