/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core;

import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.beetl.core.Configuration;
import org.beetl.core.GroupTemplate;
import org.beetl.core.ReThrowConsoleErrorHandler;
import org.beetl.core.Template;
import org.beetl.core.exception.BeetlException;
import org.beetl.core.exception.ErrorInfo;
import org.beetl.core.resource.StringTemplateResourceLoader;

public class BeetlKit {
    public static GroupTemplate gt;
    private static Map<String, Object> emptyMap;

    public static String render(String template, Map<String, Object> paras) {
        Template t = gt.getTemplate(template);
        t.binding(paras);
        return t.render();
    }

    public static void renderTo(String template, Writer writer, Map<String, Object> paras) {
        Template t = gt.getTemplate(template);
        t.binding(paras);
        t.renderTo(writer);
    }

    public static Map execute(String script, Map<String, Object> paras) throws BeetlException {
        return gt.runScript(script, emptyMap);
    }

    public static Map execute(String script) throws BeetlException {
        return gt.runScript(script, new HashMap<String, Object>());
    }

    public static String testTemplate(String template, String initValue) throws BeetlException {
        Map map = BeetlKit.execute(initValue);
        String result = BeetlKit.render(template, map);
        return result;
    }

    public static void main(String[] args) throws BeetlException {
        gt.getConf().setStatementStart("@");
        gt.getConf().setStatementEnd(null);
        String json = "var a=".concat("[1,2,c+1 ]").concat(";");
        try {
            Map map = BeetlKit.execute(json);
        }
        catch (BeetlException e) {
            ErrorInfo info = new ErrorInfo(e);
            System.out.println(info.toString());
        }
    }

    static {
        Configuration cfg;
        gt = null;
        StringTemplateResourceLoader resourceLoader = new StringTemplateResourceLoader();
        try {
            cfg = Configuration.defaultConfiguration();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        gt = new GroupTemplate(resourceLoader, cfg);
        gt.setErrorHandler(new ReThrowConsoleErrorHandler());
        emptyMap = new HashMap<String, Object>();
    }
}

