/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import java.util.Stack;
import java.util.TreeMap;
import org.beetl.core.HTMLTagParser;
import org.beetl.core.LineStatus;
import org.beetl.core.exception.HTMLTagParserException;
import org.beetl.core.exception.TextParserException;
import org.beetl.core.statement.GrammarToken;

public class Transformator {
    String htmlTagStart = "<#";
    String htmlTagEnd = "</#";
    String htmlTagBindingAttribute = "var";
    Stack htmlTagStack = new Stack();
    boolean isSupportHtmlTag = false;
    String placeholderStart = "$";
    String placeholderEnd = "$";
    String startStatement = "#:";
    String endStatement = null;
    boolean appendCR = false;
    String vname = "";
    int vnamesuffix = 0;
    Map<Integer, String> textMap = new TreeMap<Integer, String>();
    int status = 1;
    StringBuilder sb = new StringBuilder();
    char[] cs = null;
    int index = 0;
    LineStatus lineStatus = new LineStatus();
    int lineCount = 0;
    int totalLineCount = 0;
    String VCR = "<$__VCR>>";
    String lineSeparator = System.getProperty("line.separator");
    static int MAX_LINE = 78;
    static char ESCAPE = (char)92;

    public Transformator() {
    }

    public Map<Integer, String> getTextMap() {
        return this.textMap;
    }

    public Transformator(String placeholderStart, String placeholderEnd, String startStatement, String endStatement) {
        this.placeholderStart = placeholderStart;
        this.placeholderEnd = placeholderEnd;
        this.startStatement = startStatement;
        this.endStatement = endStatement;
    }

    public String getPlaceholderStart() {
        return this.placeholderStart;
    }

    public void setPlaceholderStart(String placeholderStart) {
        this.placeholderStart = placeholderStart;
    }

    public String getPlaceholderEnd() {
        return this.placeholderEnd;
    }

    public void setPlaceholderEnd(String placeholderEnd) {
        this.placeholderEnd = placeholderEnd;
    }

    public String getStartStatement() {
        return this.startStatement;
    }

    public void setStartStatement(String startStatement) {
        this.startStatement = startStatement;
    }

    public String getEndStatement() {
        return this.endStatement;
    }

    public void setEndStatement(String endStatement) {
        this.endStatement = endStatement;
    }

    public void enableHtmlTagSupport(String tagStart, String tagEnd, String htmlTagBindingAttribute) {
        this.htmlTagStart = tagStart;
        this.htmlTagEnd = tagEnd;
        this.htmlTagBindingAttribute = htmlTagBindingAttribute;
        this.isSupportHtmlTag = true;
    }

    public Reader transform(Reader orginal) throws IOException, HTMLTagParserException {
        StringBuilder temp = new StringBuilder();
        int bufSzie = 1024;
        this.cs = new char[bufSzie];
        int len = -1;
        while ((len = orginal.read(this.cs)) != -1) {
            temp.append(this.cs, 0, len);
        }
        this.cs = temp.toString().toCharArray();
        this.findCR();
        this.checkAppendCR();
        this.parser();
        if (this.isSupportHtmlTag && this.htmlTagStack.size() != 0) {
            String tagName = (String)this.htmlTagStack.peek();
            GrammarToken token = GrammarToken.createToken(tagName, this.totalLineCount + 1);
            HTMLTagParserException ex = new HTMLTagParserException("\u89e3\u6790html tag \u6807\u7b7e\u51fa\u9519,\u672a\u627e\u5230\u5339\u914d\u7ed3\u675f\u6807\u7b7e " + tagName);
            ex.pushToken(token);
            ex.line = this.totalLineCount + 1;
            this.clear();
            throw ex;
        }
        orginal.close();
        return new StringReader(this.sb.toString());
    }

    private void findCR() {
        StringBuilder cr = new StringBuilder(2);
        for (int i = 0; i < this.cs.length; ++i) {
            if (this.cs[i] != '\n' && this.cs[i] != '\r') continue;
            cr.append(this.cs[i]);
            if (this.cs.length != i + 1) {
                char next;
                char c = next = this.cs[i] == '\r' ? (char)'\n' : '\r';
                if (this.cs[i + 1] == next) {
                    cr.append(next);
                }
            }
            this.lineSeparator = cr.toString();
            return;
        }
    }

    public Reader transform(String str) throws IOException, HTMLTagParserException {
        this.cs = str.toCharArray();
        this.findCR();
        this.checkAppendCR();
        this.parser();
        if (this.isSupportHtmlTag && this.htmlTagStack.size() != 0) {
            String tagName = (String)this.htmlTagStack.peek();
            GrammarToken token = GrammarToken.createToken(tagName, this.totalLineCount + 1);
            HTMLTagParserException ex = new HTMLTagParserException("\u89e3\u6790html tag \u6807\u7b7e\u51fa\u9519,\u672a\u627e\u5230\u5339\u914d\u7ed3\u675f\u6807\u7b7e " + tagName);
            ex.pushToken(token);
            ex.line = this.totalLineCount + 1;
            this.clear();
            throw ex;
        }
        return new StringReader(this.sb.toString());
    }

    public void parser() throws HTMLTagParserException {
        while (true) {
            switch (this.status) {
                case 1: {
                    this.readCommonString();
                    break;
                }
                case 2: {
                    this.readStatement();
                    break;
                }
                case 3: {
                    this.readPlaceHolder();
                    break;
                }
                case 5: {
                    this.readHTMLTagBegin();
                    break;
                }
                case 6: {
                    this.readHTMLTagEnd();
                    break;
                }
                case 4: {
                    return;
                }
            }
        }
    }

    public void readHTMLTagBegin() throws HTMLTagParserException {
        String tagName = null;
        try {
            StringBuilder script = new StringBuilder();
            HTMLTagParser html = new HTMLTagParser(this.cs, this.index, this.htmlTagBindingAttribute, true);
            html.parser();
            if (html.hasVarBinding) {
                script.append("htmltagvar");
            } else {
                script.append("htmltag");
            }
            tagName = html.getTagName();
            script.append("('").append(tagName).append("',");
            Map<String, String> map = html.getExpMap();
            Map<String, Character> quat = html.getQuatMap();
            if (map.size() != 0) {
                script.append("{");
            }
            for (Map.Entry<String, String> entry : map.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                if (html.crKey.contains(key)) {
                    script.append(this.lineSeparator);
                }
                script.append(key).append(":");
                String attrValue = this.parseAttr(quat.get(key).charValue(), value);
                script.append(attrValue);
                script.append(",");
            }
            script.setLength(script.length() - 1);
            if (map.size() != 0) {
                script.append("}");
            }
            if (html.hasVarBinding) {
                if (map.size() == 0) {
                    script.append(",{}");
                }
                if (html.varBidingStr.trim().length() == 0) {
                    String defaultVarName = null;
                    int index = tagName.lastIndexOf(":");
                    defaultVarName = index == -1 ? tagName : tagName.substring(index + 1);
                    script.append(",").append("'").append(defaultVarName).append("'");
                } else {
                    script.append(",").append("'").append(html.varBidingStr).append("'");
                }
            }
            script.append("){");
            if (html.isEmptyTag()) {
                script.append("}");
            } else {
                this.htmlTagStack.push(tagName);
            }
            this.sb.append((CharSequence)script);
            this.index = html.getIndex();
            this.status = 1;
            this.lineStatus.setStatment();
        }
        catch (RuntimeException re) {
            if (tagName == null) {
                tagName = "\u672a\u77e5\u6807\u7b7e";
            }
            GrammarToken token = GrammarToken.createToken(tagName, this.totalLineCount + 1);
            HTMLTagParserException ex = new HTMLTagParserException(re.getMessage());
            ex.pushToken(token);
            ex.line = this.totalLineCount + 1;
            throw ex;
        }
    }

    public void readHTMLTagEnd() throws HTMLTagParserException {
        String tagName = null;
        try {
            HTMLTagParser html = new HTMLTagParser(this.cs, this.index, this.htmlTagBindingAttribute, false);
            html.parser();
            tagName = html.getTagName();
            if (this.htmlTagStack.empty()) {
                throw new RuntimeException("\u89e3\u6790html tag\u51fa\u9519");
            }
            String lastTag = (String)this.htmlTagStack.peek();
            if (!tagName.equals(lastTag)) {
                throw new RuntimeException("\u89e3\u6790html tag\u51fa\u9519,\u671f\u671b\u5339\u914d\u6807\u7b7e" + lastTag);
            }
            this.htmlTagStack.pop();
            this.sb.append("}");
            this.index = html.getIndex();
            this.status = 1;
            this.lineStatus.setStatment();
        }
        catch (RuntimeException re) {
            if (tagName == null) {
                tagName = "\u672a\u77e5\u6807\u7b7e";
            }
            GrammarToken token = GrammarToken.createToken(tagName, this.totalLineCount + 1);
            HTMLTagParserException ex = new HTMLTagParserException(re.getMessage());
            ex.pushToken(token);
            ex.line = this.totalLineCount + 1;
            throw ex;
        }
    }

    public void readPlaceHolder() {
        this.index += this.placeholderStart.length();
        this.lineStatus.addHolderCount();
        this.sb.append("<<");
        while (this.index <= this.cs.length) {
            if (this.match(this.placeholderEnd)) {
                if (this.isEscape(this.sb, this.index)) {
                    this.sb.append(this.cs[this.index++]);
                    continue;
                }
                this.index += this.placeholderEnd.length();
                this.sb.append(">>");
                this.status = 1;
                return;
            }
            if (this.status == 4) break;
            this.sb.append(this.cs[this.index]);
            ++this.index;
        }
        this.status = 4;
    }

    public void readStatement() {
        this.index += this.startStatement.length();
        this.lineStatus.setStatment();
        boolean findEndStatement = false;
        int startLine = this.totalLineCount;
        while (this.index < this.cs.length) {
            char ch;
            if (this.endStatement != null && this.match(this.endStatement)) {
                findEndStatement = true;
                if (this.isEscape(this.sb, this.index)) {
                    this.sb.append(this.cs[this.index++]);
                    continue;
                }
                this.index += this.endStatement.length();
                this.status = 1;
                if (this.appendCR) {
                    this.lineStatus.setStatment();
                    if (this.lineStatus.onlyStatment()) {
                        this.reforamtStatmentLine();
                        this.lineStatus.reset();
                        this.sb.append(this.endStatement);
                    }
                } else {
                    this.lineStatus.setStatment();
                }
                return;
            }
            if (this.status == 4) break;
            if ((ch = this.cs[this.index++]) == '\r' || ch == '\n') {
                ++this.totalLineCount;
                this.sb.append(this.lineSeparator);
                this.skipCR(ch);
                if (this.lineStatus.onlyStatment()) {
                    this.reforamtStatmentLine();
                    this.lineStatus.reset();
                }
                if (this.endStatement != null) continue;
                this.status = 1;
                return;
            }
            this.sb.append(ch);
        }
        this.status = 4;
        if (!findEndStatement) {
            GrammarToken token = GrammarToken.createToken(this.endStatement, this.totalLineCount + 1);
            TextParserException ex = new TextParserException("\u8d77\u59cb\u7684\u7b2c" + (startLine + 1) + "\u884c\u7684\u5b9a\u754c\u7b26'" + this.startStatement + "'\u672a\u627e\u5230\u5339\u914d\u7684\u7ed3\u675f\u7b26'" + this.endStatement + "'");
            ex.pushToken(token);
            ex.line = this.totalLineCount + 1;
            this.clear();
            throw ex;
        }
    }

    public void readCommonString() {
        StringBuilder temp = new StringBuilder();
        boolean hasLetter = false;
        boolean hasCheck = false;
        while (this.index <= this.cs.length) {
            char ch;
            if (this.match(this.placeholderStart)) {
                if (this.isEscape(temp, this.index)) {
                    temp.append(this.cs[this.index++]);
                    continue;
                }
                if (temp.length() != 0) {
                    if (this.lineCount >= 1) {
                        this.createMutipleLineTextNode(temp);
                        this.lineCount = 0;
                    } else {
                        this.createTextNode(temp);
                    }
                }
                this.status = 3;
                return;
            }
            if (this.match(this.startStatement)) {
                if (this.isEscape(temp, this.index)) {
                    temp.append(this.cs[this.index++]);
                    continue;
                }
                if (temp.length() != 0) {
                    if (this.lineCount >= 1) {
                        this.createMutipleLineTextNode(temp);
                        this.lineCount = 0;
                    } else {
                        this.createTextNode(temp);
                    }
                }
                this.status = 2;
                return;
            }
            if (this.isSupportHtmlTag && this.match(this.htmlTagEnd)) {
                if (temp.length() != 0) {
                    if (this.lineCount >= 1) {
                        this.createMutipleLineTextNode(temp);
                        this.lineCount = 0;
                    } else {
                        this.createTextNode(temp);
                    }
                }
                this.index += this.htmlTagEnd.length();
                this.status = 6;
                return;
            }
            if (this.isSupportHtmlTag && this.match(this.htmlTagStart)) {
                if (temp.length() != 0) {
                    if (this.lineCount >= 1) {
                        this.createMutipleLineTextNode(temp);
                        this.lineCount = 0;
                    } else {
                        this.createTextNode(temp);
                    }
                }
                this.status = 5;
                this.index += this.htmlTagStart.length();
                return;
            }
            if (this.status == 4) break;
            if ((ch = this.cs[this.index++]) == '\r' || ch == '\n') {
                ++this.totalLineCount;
                this.skipCR(ch);
                if (!hasLetter && this.lineStatus.onlyText()) {
                    temp.append(this.lineSeparator);
                    ++this.lineCount;
                    this.lineStatus.reset();
                    continue;
                }
                if (this.lineStatus.onlyStatment()) {
                    if (temp.length() != 0) {
                        this.createTextNode(temp);
                    }
                    this.reforamtStatmentLine();
                    this.lineStatus.reset();
                    this.sb.append(this.lineSeparator);
                    continue;
                }
                ++this.lineCount;
                this.lineStatus.reset();
                temp.append(this.lineSeparator);
                continue;
            }
            if (!hasCheck && ch != ' ' && ch != '\t') {
                hasLetter = true;
                hasCheck = true;
            }
            temp.append(ch);
        }
        if (temp.length() != 0) {
            this.createTextNode(temp);
        }
        this.status = 4;
    }

    private void reforamtStatmentLine() {
        int count = this.lineStatus.getSpaceCount();
        for (int i = count - 1; i >= 0; --i) {
            int start = this.lineStatus.getSpaceTextStart(i);
            int end = this.lineStatus.getSpaceTextEnd(i);
            String varName = this.sb.substring(start + 2, end - 2);
            String orgText = this.textMap.get(Integer.parseInt(varName));
            this.sb.replace(start, end, orgText);
        }
        this.lineStatus.reset();
    }

    private void createTextNode(StringBuilder str) {
        if (str.length() == 0) {
            return;
        }
        String name = this.getNewVarName();
        this.textMap.put(Integer.parseInt(name), new String(str));
        String textVarName = "<$" + name + ">>";
        if (this.isSpace(str)) {
            this.lineStatus.addSpaceText(this.sb.length(), this.sb.length() + textVarName.length());
        } else {
            this.lineStatus.addTextCount();
        }
        this.sb.append(textVarName);
        str.setLength(0);
    }

    private void skipCR(char c) {
        if (this.index < this.cs.length) {
            char o = this.cs[this.index];
            if (c == '\r' && o == '\n') {
                ++this.index;
            } else if (c == '\n' && o == '\r') {
                ++this.index;
            }
        }
    }

    private void createMutipleLineTextNode(StringBuilder str) {
        int index = str.lastIndexOf(this.lineSeparator);
        String firstPart = str.substring(0, index);
        String secondPart = str.substring(index + this.lineSeparator.length());
        if (this.isSpace(new StringBuilder(secondPart))) {
            this.createTextNode(new StringBuilder(firstPart + this.lineSeparator));
            for (int i = 0; i < this.lineCount; ++i) {
                this.sb.append(this.lineSeparator);
            }
            this.createTextNode(new StringBuilder(secondPart));
        } else {
            this.createTextNode(str);
            for (int i = 0; i < this.lineCount; ++i) {
                this.sb.append(this.lineSeparator);
            }
        }
        str.setLength(0);
    }

    private boolean isSpace(StringBuilder str) {
        for (char c : str.toString().toCharArray()) {
            if (c == ' ' || c == '\t') continue;
            return false;
        }
        return true;
    }

    public boolean match(String expectedStr) {
        for (int i = 0; i < expectedStr.length(); ++i) {
            if (this.cs.length == this.index + i) {
                this.status = 4;
                return false;
            }
            if (this.cs[this.index + i] == expectedStr.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public boolean isEscape(StringBuilder temp, int index) {
        if (index != 0) {
            if (this.cs[index - 1] == ESCAPE) {
                if (index >= 2) {
                    if (this.cs[index - 2] == ESCAPE) {
                        if (temp.length() != 0) {
                            temp.setLength(temp.length() - 1);
                        }
                        return false;
                    }
                }
                if (temp.length() != 0) {
                    temp.setLength(temp.length() - 1);
                }
                return true;
            }
        }
        return false;
    }

    public String getNewVarName() {
        return this.vname + this.vnamesuffix++;
    }

    private void checkAppendCR() {
        this.appendCR = this.endStatement == null ? true : (this.endStatement.indexOf("\n") != -1 ? true : this.endStatement.indexOf("\r") != -1);
    }

    public String parseAttr(char q, String attr) {
        StringBuilder sb = new StringBuilder(attr.length() + 10);
        int start = 0;
        int end = 0;
        int index = -1;
        while ((index = attr.indexOf(this.placeholderStart, start)) != -1) {
            int holdStart = index;
            while ((end = attr.indexOf(this.placeholderEnd, holdStart)) != -1 && attr.charAt(end - 1) == '\\') {
                holdStart = end + 1;
            }
            if (end == -1) {
                throw new RuntimeException(attr + "\u6807\u7b7e\u5c5e\u6027\u9519\u8bef\uff0c\u6709\u7ad9\u4f4d\u7b26\u53f7\uff0c\u4f46\u627e\u4e0d\u5230\u5230\u7ed3\u675f\u7b26\u53f7");
            }
            if (index != 0) {
                sb.append(q).append(attr.substring(start, index)).append(q).append("+");
            }
            String value = attr.substring(index + this.placeholderStart.length(), end);
            value = value.replace("\\}", "}");
            sb.append("(").append(value).append(")").append("+");
            start = end + this.placeholderEnd.length();
        }
        if (start == 0) {
            return sb.append(q).append(attr).append(q).toString();
        }
        if (start != attr.length()) {
            sb.append(q).append(attr.substring(start, attr.length())).append(q);
        } else {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        int c = 92;
        Transformator p = new Transformator("${", "}", "<%", "%>");
        p.enableHtmlTagSupport("<#", "/#>", "var");
        try {
            String str = "<%/*a*/a=1; */ %>";
            BufferedReader reader = new BufferedReader(p.transform(str));
            String line = null;
            System.out.println(p.getTextMap());
            String v = p.getTextMap().get(0);
            System.out.println("==============================");
            while ((line = reader.readLine()) != null) {
                System.out.println(line);
            }
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
            ex.printStackTrace();
        }
    }

    public void clear() {
        this.cs = null;
        this.sb = null;
    }
}

