/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core.resource;

import org.beetl.core.resource.Matcher;

public class StartsWithMatcher
implements Matcher {
    private String prefix;
    private int prefixLen = 0;
    private boolean withPrefix = false;

    public StartsWithMatcher() {
    }

    public StartsWithMatcher(String prefix) {
        this.prefix = prefix;
        this.prefixLen = prefix.length();
    }

    public StartsWithMatcher withPrefix() {
        this.withPrefix = true;
        return this;
    }

    public StartsWithMatcher withoutPrefix() {
        this.withPrefix = false;
        return this;
    }

    @Override
    public String match(String key) {
        if (key.startsWith(this.prefix)) {
            if (this.withPrefix) {
                return key;
            }
            return key.substring(this.prefixLen);
        }
        return null;
    }

    public final boolean isWithPrefix() {
        return this.withPrefix;
    }

    public final void setWithPrefix(boolean withPrefix) {
        this.withPrefix = withPrefix;
    }

    public final String getPrefix() {
        return this.prefix;
    }

    public final void setPrefix(String prefix) {
        this.prefix = prefix;
        this.prefixLen = prefix.length();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.prefix == null ? 0 : this.prefix.hashCode());
        result = 31 * result + this.prefixLen;
        result = 31 * result + (this.withPrefix ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartsWithMatcher)) {
            return false;
        }
        StartsWithMatcher other = (StartsWithMatcher)obj;
        if (this.prefix == null ? other.prefix != null : !this.prefix.equals(other.prefix)) {
            return false;
        }
        if (this.prefixLen != other.prefixLen) {
            return false;
        }
        return this.withPrefix == other.withPrefix;
    }

    public static void main(String[] args) {
        StartsWithMatcher swm = new StartsWithMatcher("/com/wellbole").withoutPrefix();
        System.out.println(swm.match("/com/wellbole/app/pg/index.html"));
        swm = new StartsWithMatcher("/com/wellbole").withPrefix();
        System.out.println(swm.match("/com/wellbole/app/pg/index.html"));
    }
}

