/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core;

import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import java.util.Set;
import org.beetl.core.ByteWriter;
import org.beetl.core.Configuration;
import org.beetl.core.Context;
import org.beetl.core.ErrorHandler;
import org.beetl.core.GroupTemplate;
import org.beetl.core.exception.BeetlException;
import org.beetl.core.io.ByteWriter_Byte;
import org.beetl.core.io.ByteWriter_Char;
import org.beetl.core.misc.BeetlUtil;
import org.beetl.core.statement.AjaxStatement;
import org.beetl.core.statement.ErrorGrammarProgram;
import org.beetl.core.statement.GrammarToken;
import org.beetl.core.statement.Program;

public class Template {
    public Program program;
    public Configuration cf;
    public GroupTemplate gt;
    public boolean isRoot = true;
    public String ajaxId = null;
    Context ctx = new Context();

    protected Template(GroupTemplate gt, Program program, Configuration cf) {
        this.program = program;
        this.cf = cf;
        this.gt = gt;
    }

    public String render() throws BeetlException {
        StringWriter sw = new StringWriter();
        this.renderTo(sw);
        return sw.toString();
    }

    public void renderTo(Writer writer) throws BeetlException {
        ByteWriter_Char byteWriter = new ByteWriter_Char(writer, this.cf.charset, this.ctx);
        this.renderTo(byteWriter);
    }

    public void renderTo(OutputStream os) throws BeetlException {
        ByteWriter_Byte byteWriter = new ByteWriter_Byte(os, this.cf.charset, this.ctx);
        this.renderTo(byteWriter);
    }

    public void renderTo(ByteWriter byteWriter) {
        block17: {
            try {
                this.ctx.byteWriter = byteWriter;
                this.ctx.byteOutputMode = this.cf.directByteOutput;
                this.ctx.gt = this.gt;
                this.ctx.template = this;
                if (this.gt.sharedVars != null) {
                    for (Map.Entry<String, Object> entry : this.gt.sharedVars.entrySet()) {
                        this.ctx.set(entry.getKey(), entry.getValue());
                    }
                }
                this.program.metaData.initContext(this.ctx);
                if (this.ajaxId != null) {
                    AjaxStatement ajax = this.program.metaData.getAjax(this.ajaxId);
                    if (ajax == null) {
                        BeetlException be = new BeetlException("AJAX_NOT_FOUND");
                        be.pushToken(new GrammarToken(this.ajaxId, 0, 0));
                        throw be;
                    }
                    ajax.execute(this.ctx);
                } else {
                    this.program.execute(this.ctx);
                }
                byteWriter.flush();
            }
            catch (BeetlException e) {
                if (!(this.program instanceof ErrorGrammarProgram)) {
                    e.pushResource(this.program.res.id);
                }
                if (!this.isRoot) {
                    throw e;
                }
                if (e.detailCode == "CLIENT_IO_ERROR_ERROR" && this.ctx.gt.conf.isIgnoreClientIOError) {
                    return;
                }
                Writer w = BeetlUtil.getWriterByByteWriter(this.ctx.byteWriter);
                e.gt = this.program.gt;
                e.cr = this.program.metaData.lineSeparator;
                ErrorHandler errorHandler = this.gt.getErrorHandler();
                if (errorHandler == null) {
                    throw e;
                }
                errorHandler.processExcption(e, w);
                try {
                    this.ctx.byteWriter.flush();
                }
                catch (IOException iOException) {}
            }
            catch (IOException e) {
                if (this.ctx.gt.conf.isIgnoreClientIOError) break block17;
                BeetlException be = new BeetlException("CLIENT_IO_ERROR_ERROR", e.getMessage(), e);
                be.pushResource(this.program.res.id);
                be.pushToken(new GrammarToken(this.program.res.id, 0, 0));
                ErrorHandler errorHandler = this.gt.getErrorHandler();
                if (errorHandler == null) {
                    throw be;
                }
                Writer w = BeetlUtil.getWriterByByteWriter(this.ctx.byteWriter);
                errorHandler.processExcption(be, w);
                try {
                    this.ctx.byteWriter.flush();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    public void binding(String varName, Object o, boolean dynamic) {
        this.ctx.set(varName, o, dynamic);
        if (dynamic) {
            this.ctx.objectKeys.add(varName);
        }
    }

    public void binding(String varName, Object o) {
        this.binding(varName, o, false);
    }

    public void dynamic(Set<String> objectKeys) {
        this.ctx.objectKeys = objectKeys;
    }

    public void dynamic(String key) {
        this.ctx.objectKeys.add(key);
    }

    public void binding(Map map) {
        Map values = map;
        if (values == null) {
            return;
        }
        for (Map.Entry entry : values.entrySet()) {
            this.binding((String)entry.getKey(), entry.getValue());
        }
    }

    public void fastBinding(Map map) {
        this.ctx.globalVar = map;
    }

    public Context getCtx() {
        return this.ctx;
    }
}

