/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core.statement;

import org.beetl.core.Context;
import org.beetl.core.ContextFormat;
import org.beetl.core.Format;
import org.beetl.core.InferContext;
import org.beetl.core.exception.BeetlException;
import org.beetl.core.statement.Expression;
import org.beetl.core.statement.GrammarToken;

public class FormatExpression
extends Expression {
    String name;
    String pattern;

    public FormatExpression(String name, String pattern, GrammarToken token) {
        super(token);
        this.name = name;
        this.pattern = pattern;
    }

    @Override
    public Object evaluate(Context ctx) {
        throw new UnsupportedOperationException();
    }

    public Object evaluateValue(Object o, Context ctx) {
        Format format = null;
        if (this.name != null) {
            format = ctx.gt.getFormat(this.name);
        } else {
            if (o == null) {
                return null;
            }
            format = ctx.gt.getDefaultFormat(o.getClass());
        }
        if (format == null) {
            BeetlException ex = new BeetlException("FORMAT_NOT_FOUND");
            ex.pushToken(this.token);
            throw ex;
        }
        try {
            if (format instanceof ContextFormat) {
                return ((ContextFormat)format).format(o, this.pattern, ctx);
            }
            return format.format(o, this.pattern);
        }
        catch (Exception e) {
            BeetlException ex = new BeetlException("NATIVE_CALL_EXCEPTION", "\u8c03\u7528\u683c\u5f0f\u5316\u51fd\u6570\u629b\u51fa\u5f02\u5e38", e);
            ex.pushToken(this.token);
            throw ex;
        }
    }

    @Override
    public void infer(InferContext inferCtx) {
        throw new UnsupportedOperationException();
    }
}

