/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.merge;

import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.internal.namespace.NamespaceUtil;
import com.hazelcast.internal.nio.ClassLoaderUtil;
import com.hazelcast.internal.util.ConcurrencyUtil;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.merge.SplitBrainMergePolicy;
import com.hazelcast.spi.merge.SplitBrainMergePolicyProvider;
import javax.annotation.Nullable;

public final class NamespaceAwareSplitBrainMergePolicyProvider
extends SplitBrainMergePolicyProvider {
    private final NodeEngine nodeEngine;

    public NamespaceAwareSplitBrainMergePolicyProvider(NodeEngine nodeEngine) {
        super(nodeEngine.getConfigClassLoader());
        this.nodeEngine = nodeEngine;
    }

    @Override
    public SplitBrainMergePolicy getMergePolicy(String className, @Nullable String namespace) {
        if (className == null) {
            throw new InvalidConfigurationException("Class name is mandatory!");
        }
        if (this.isPredefinedMergePolicy(className)) {
            return (SplitBrainMergePolicy)this.mergePolicyMap.get(className);
        }
        namespace = this.nodeEngine.getNamespaceService().transformNamespace(namespace);
        ClassLoader classLoader = NamespaceUtil.getClassLoaderForNamespace(this.nodeEngine, namespace);
        Class<SplitBrainMergePolicy> mergePolicyClass = this.validateAndGetClass(className, classLoader);
        String key = this.getCacheKey(namespace, className);
        return ConcurrencyUtil.getOrPutIfAbsent(this.mergePolicyMap, key, n -> this.createSplitBrainMergePolicy(mergePolicyClass, classLoader));
    }

    private String getCacheKey(String namespace, String className) {
        if (namespace == null) {
            return className;
        }
        return namespace + ":" + className;
    }

    private Class<SplitBrainMergePolicy> validateAndGetClass(String className, ClassLoader classLoader) {
        try {
            return ClassLoaderUtil.tryLoadClass(className, classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new InvalidConfigurationException("Invalid SplitBrainMergePolicy: " + className, e);
        }
    }

    private SplitBrainMergePolicy createSplitBrainMergePolicy(Class clazz, ClassLoader loader) {
        try {
            return (SplitBrainMergePolicy)ClassLoaderUtil.newInstance(loader, clazz);
        }
        catch (Exception e) {
            throw new InvalidConfigurationException("Invalid SplitBrainMergePolicy: " + clazz.getName(), e);
        }
    }

    @Override
    public void clearNamespaceCache(String namespace) {
        if (namespace == null) {
            return;
        }
        String prefix = this.getCacheKey(namespace, "");
        this.mergePolicyMap.keySet().removeIf(key -> key.startsWith(prefix));
    }
}

