/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl.proxyservice.impl;

import com.hazelcast.core.DistributedObjectEvent;
import com.hazelcast.internal.util.UUIDSerializationUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.impl.SpiDataSerializerHook;
import java.io.IOException;
import java.util.UUID;

public final class DistributedObjectEventPacket
implements IdentifiedDataSerializable {
    private DistributedObjectEvent.EventType eventType;
    private String serviceName;
    private String name;
    private UUID source;

    public DistributedObjectEventPacket() {
    }

    public DistributedObjectEventPacket(DistributedObjectEvent.EventType eventType, String serviceName, String name, UUID source) {
        this.eventType = eventType;
        this.serviceName = serviceName;
        this.name = name;
        this.source = source;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public DistributedObjectEvent.EventType getEventType() {
        return this.eventType;
    }

    public String getName() {
        return this.name;
    }

    public UUID getSource() {
        return this.source;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeBoolean(this.eventType == DistributedObjectEvent.EventType.CREATED);
        out.writeString(this.serviceName);
        out.writeString(this.name);
        UUIDSerializationUtil.writeUUID(out, this.source);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.eventType = in.readBoolean() ? DistributedObjectEvent.EventType.CREATED : DistributedObjectEvent.EventType.DESTROYED;
        this.serviceName = in.readString();
        this.name = in.readString();
        this.source = UUIDSerializationUtil.readUUID(in);
    }

    public String toString() {
        return "DistributedObjectEvent{eventType=" + String.valueOf((Object)this.eventType) + ", serviceName='" + this.serviceName + "', name=" + this.name + ", source=" + String.valueOf(this.source) + "}";
    }

    @Override
    public int getFactoryId() {
        return SpiDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 25;
    }
}

