/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl.operationservice.impl;

import com.hazelcast.cluster.Address;
import com.hazelcast.spi.impl.operationservice.InvocationBuilder;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.impl.Invocation;
import com.hazelcast.spi.impl.operationservice.impl.InvocationFuture;
import com.hazelcast.spi.impl.operationservice.impl.MasterInvocation;
import com.hazelcast.spi.impl.operationservice.impl.PartitionInvocation;
import com.hazelcast.spi.impl.operationservice.impl.TargetInvocation;

final class InvocationBuilderImpl
extends InvocationBuilder {
    private final Invocation.Context context;
    private final boolean executeOnMaster;

    private InvocationBuilderImpl(Invocation.Context context, String serviceName, Operation op, int partitionId, Address target, boolean executeOnMaster) {
        super(serviceName, op, partitionId, target);
        this.context = context;
        this.executeOnMaster = executeOnMaster;
    }

    static InvocationBuilderImpl createForPartition(Invocation.Context context, String serviceName, Operation op, int partitionId) {
        return new InvocationBuilderImpl(context, serviceName, op, partitionId, null, false);
    }

    static InvocationBuilderImpl createForTarget(Invocation.Context context, String serviceName, Operation op, Address target) {
        return new InvocationBuilderImpl(context, serviceName, op, -1, target, false);
    }

    static InvocationBuilderImpl createForMaster(Invocation.Context context, String serviceName, Operation op) {
        return new InvocationBuilderImpl(context, serviceName, op, -1, null, true);
    }

    public InvocationFuture invoke() {
        Invocation invocation = this.build();
        return this.async ? invocation.invokeAsync() : invocation.invoke();
    }

    public Invocation build() {
        Invocation invocation;
        this.op.setServiceName(this.serviceName);
        if (this.executeOnMaster) {
            invocation = new MasterInvocation(this.context, this.op, this.doneCallback, this.tryCount, this.tryPauseMillis, this.callTimeout, this.resultDeserialized, this.connectionManager);
        } else if (this.target == null) {
            this.op.setPartitionId(this.partitionId).setReplicaIndex(this.replicaIndex);
            invocation = new PartitionInvocation(this.context, this.op, this.doneCallback, this.tryCount, this.tryPauseMillis, this.callTimeout, this.resultDeserialized, this.failOnIndeterminateOperationState, this.connectionManager);
        } else {
            invocation = new TargetInvocation(this.context, this.op, this.target, this.doneCallback, this.tryCount, this.tryPauseMillis, this.callTimeout, this.resultDeserialized, this.connectionManager);
        }
        return invocation;
    }
}

