/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.osgi.impl;

import com.hazelcast.cardinality.CardinalityEstimator;
import com.hazelcast.client.ClientService;
import com.hazelcast.cluster.Cluster;
import com.hazelcast.cluster.Endpoint;
import com.hazelcast.collection.IList;
import com.hazelcast.collection.IQueue;
import com.hazelcast.collection.ISet;
import com.hazelcast.config.Config;
import com.hazelcast.core.DistributedObject;
import com.hazelcast.core.DistributedObjectListener;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.ICacheManager;
import com.hazelcast.core.IExecutorService;
import com.hazelcast.core.LifecycleService;
import com.hazelcast.cp.CPSubsystem;
import com.hazelcast.crdt.pncounter.PNCounter;
import com.hazelcast.dataconnection.DataConnectionService;
import com.hazelcast.durableexecutor.DurableExecutorService;
import com.hazelcast.flakeidgen.FlakeIdGenerator;
import com.hazelcast.internal.util.StringUtil;
import com.hazelcast.jet.JetService;
import com.hazelcast.logging.LoggingService;
import com.hazelcast.map.IMap;
import com.hazelcast.multimap.MultiMap;
import com.hazelcast.osgi.HazelcastOSGiInstance;
import com.hazelcast.osgi.HazelcastOSGiService;
import com.hazelcast.partition.PartitionService;
import com.hazelcast.replicatedmap.ReplicatedMap;
import com.hazelcast.ringbuffer.Ringbuffer;
import com.hazelcast.scheduledexecutor.IScheduledExecutorService;
import com.hazelcast.splitbrainprotection.SplitBrainProtectionService;
import com.hazelcast.sql.SqlService;
import com.hazelcast.topic.ITopic;
import com.hazelcast.transaction.HazelcastXAResource;
import com.hazelcast.transaction.TransactionContext;
import com.hazelcast.transaction.TransactionException;
import com.hazelcast.transaction.TransactionOptions;
import com.hazelcast.transaction.TransactionalTask;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nonnull;

class HazelcastOSGiInstanceImpl
implements HazelcastOSGiInstance {
    private final HazelcastInstance delegatedInstance;
    private final HazelcastOSGiService ownerService;

    HazelcastOSGiInstanceImpl(HazelcastInstance delegatedInstance, HazelcastOSGiService ownerService) {
        this.delegatedInstance = delegatedInstance;
        this.ownerService = ownerService;
    }

    @Override
    @Nonnull
    public String getName() {
        return this.delegatedInstance.getName();
    }

    @Override
    @Nonnull
    public <E> IQueue<E> getQueue(@Nonnull String name) {
        return this.delegatedInstance.getQueue(name);
    }

    @Override
    @Nonnull
    public <E> ITopic<E> getTopic(@Nonnull String name) {
        return this.delegatedInstance.getTopic(name);
    }

    @Override
    @Nonnull
    public <E> ISet<E> getSet(@Nonnull String name) {
        return this.delegatedInstance.getSet(name);
    }

    @Override
    @Nonnull
    public <E> IList<E> getList(@Nonnull String name) {
        return this.delegatedInstance.getList(name);
    }

    @Override
    @Nonnull
    public <K, V> IMap<K, V> getMap(@Nonnull String name) {
        return this.delegatedInstance.getMap(name);
    }

    @Override
    @Nonnull
    public <K, V> ReplicatedMap<K, V> getReplicatedMap(@Nonnull String name) {
        return this.delegatedInstance.getReplicatedMap(name);
    }

    @Override
    @Nonnull
    public <K, V> MultiMap<K, V> getMultiMap(@Nonnull String name) {
        return this.delegatedInstance.getMultiMap(name);
    }

    @Override
    @Nonnull
    public <E> Ringbuffer<E> getRingbuffer(@Nonnull String name) {
        return this.delegatedInstance.getRingbuffer(name);
    }

    @Override
    @Nonnull
    public <E> ITopic<E> getReliableTopic(@Nonnull String name) {
        return this.delegatedInstance.getReliableTopic(name);
    }

    @Override
    public ICacheManager getCacheManager() {
        return this.delegatedInstance.getCacheManager();
    }

    @Override
    @Nonnull
    public Cluster getCluster() {
        return this.delegatedInstance.getCluster();
    }

    @Override
    @Nonnull
    public Endpoint getLocalEndpoint() {
        return this.delegatedInstance.getLocalEndpoint();
    }

    @Override
    @Nonnull
    public IExecutorService getExecutorService(@Nonnull String name) {
        return this.delegatedInstance.getExecutorService(name);
    }

    @Override
    @Nonnull
    public DurableExecutorService getDurableExecutorService(@Nonnull String name) {
        return this.delegatedInstance.getDurableExecutorService(name);
    }

    @Override
    public <T> T executeTransaction(@Nonnull TransactionalTask<T> task) throws TransactionException {
        return this.delegatedInstance.executeTransaction(task);
    }

    @Override
    public <T> T executeTransaction(@Nonnull TransactionOptions options, @Nonnull TransactionalTask<T> task) throws TransactionException {
        return this.delegatedInstance.executeTransaction(options, task);
    }

    @Override
    public TransactionContext newTransactionContext() {
        return this.delegatedInstance.newTransactionContext();
    }

    @Override
    public TransactionContext newTransactionContext(@Nonnull TransactionOptions options) {
        return this.delegatedInstance.newTransactionContext(options);
    }

    @Override
    @Nonnull
    public FlakeIdGenerator getFlakeIdGenerator(@Nonnull String name) {
        return this.delegatedInstance.getFlakeIdGenerator(name);
    }

    @Override
    public Collection<DistributedObject> getDistributedObjects() {
        return this.delegatedInstance.getDistributedObjects();
    }

    @Override
    public UUID addDistributedObjectListener(@Nonnull DistributedObjectListener distributedObjectListener) {
        return this.delegatedInstance.addDistributedObjectListener(distributedObjectListener);
    }

    @Override
    public boolean removeDistributedObjectListener(@Nonnull UUID registrationId) {
        return this.delegatedInstance.removeDistributedObjectListener(registrationId);
    }

    @Override
    @Nonnull
    public Config getConfig() {
        return this.delegatedInstance.getConfig();
    }

    @Override
    @Nonnull
    public PartitionService getPartitionService() {
        return this.delegatedInstance.getPartitionService();
    }

    @Override
    @Nonnull
    public SplitBrainProtectionService getSplitBrainProtectionService() {
        return this.delegatedInstance.getSplitBrainProtectionService();
    }

    @Override
    @Nonnull
    public ClientService getClientService() {
        return this.delegatedInstance.getClientService();
    }

    @Override
    @Nonnull
    public LoggingService getLoggingService() {
        return this.delegatedInstance.getLoggingService();
    }

    @Override
    @Nonnull
    public LifecycleService getLifecycleService() {
        return this.delegatedInstance.getLifecycleService();
    }

    @Override
    @Nonnull
    public <T extends DistributedObject> T getDistributedObject(@Nonnull String serviceName, @Nonnull String name) {
        return this.delegatedInstance.getDistributedObject(serviceName, name);
    }

    @Override
    @Nonnull
    public ConcurrentMap<String, Object> getUserContext() {
        return this.delegatedInstance.getUserContext();
    }

    @Override
    @Nonnull
    public HazelcastXAResource getXAResource() {
        return this.delegatedInstance.getXAResource();
    }

    @Override
    @Nonnull
    public CardinalityEstimator getCardinalityEstimator(@Nonnull String name) {
        return this.delegatedInstance.getCardinalityEstimator(name);
    }

    @Override
    @Nonnull
    public PNCounter getPNCounter(@Nonnull String name) {
        return this.delegatedInstance.getPNCounter(name);
    }

    @Override
    @Nonnull
    public IScheduledExecutorService getScheduledExecutorService(@Nonnull String name) {
        return this.delegatedInstance.getScheduledExecutorService(name);
    }

    @Override
    @Nonnull
    public CPSubsystem getCPSubsystem() {
        return this.delegatedInstance.getCPSubsystem();
    }

    @Override
    @Nonnull
    public SqlService getSql() {
        return this.delegatedInstance.getSql();
    }

    @Override
    @Nonnull
    public DataConnectionService getDataConnectionService() {
        return this.delegatedInstance.getDataConnectionService();
    }

    @Override
    @Nonnull
    public JetService getJet() {
        return this.delegatedInstance.getJet();
    }

    @Override
    public void shutdown() {
        this.delegatedInstance.shutdown();
    }

    @Override
    public HazelcastInstance getDelegatedInstance() {
        return this.delegatedInstance;
    }

    @Override
    public HazelcastOSGiService getOwnerService() {
        return this.ownerService;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HazelcastOSGiInstanceImpl that = (HazelcastOSGiInstanceImpl)o;
        if (!this.delegatedInstance.equals(that.delegatedInstance)) {
            return false;
        }
        return this.ownerService.equals(that.ownerService);
    }

    public int hashCode() {
        int result = this.ownerService.hashCode();
        result = 31 * result + this.delegatedInstance.hashCode();
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("HazelcastOSGiInstanceImpl");
        sb.append("{delegatedInstance='").append(this.delegatedInstance).append('\'');
        Config config = this.getConfig();
        if (!StringUtil.isNullOrEmpty(config.getClusterName())) {
            sb.append(", clusterName=").append(config.getClusterName());
        }
        sb.append(", ownerServiceId=").append(this.ownerService.getId());
        sb.append('}');
        return sb.toString();
    }
}

