/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.multimap.impl.txn;

import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.impl.SerializationUtil;
import com.hazelcast.multimap.impl.operations.AbstractBackupAwareMultiMapOperation;
import com.hazelcast.multimap.impl.txn.TxnCommitBackupOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.impl.operationexecutor.OperationRunner;
import com.hazelcast.spi.impl.operationservice.BackupAwareOperation;
import com.hazelcast.spi.impl.operationservice.Notifier;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.WaitNotifyKey;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class TxnCommitOperation
extends AbstractBackupAwareMultiMapOperation
implements Notifier {
    private List<Operation> opList;
    private transient boolean notify = true;

    public TxnCommitOperation() {
    }

    public TxnCommitOperation(int partitionId, String name, Data dataKey, long threadId, List<Operation> opList) {
        super(name, dataKey, threadId);
        this.setPartitionId(partitionId);
        this.opList = opList;
    }

    @Override
    public void run() throws Exception {
        for (Operation op : this.opList) {
            op.setNodeEngine(this.getNodeEngine()).setServiceName(this.getServiceName()).setPartitionId(this.getPartitionId());
            OperationRunner.runDirect(op);
        }
        this.getOrCreateContainer().unlock(this.dataKey, this.getCallerUuid(), this.threadId, this.getCallId());
    }

    @Override
    public boolean shouldBackup() {
        return this.notify;
    }

    @Override
    public Operation getBackupOperation() {
        ArrayList<Operation> backupOpList = new ArrayList<Operation>();
        for (Operation operation : this.opList) {
            BackupAwareOperation backupAwareOperation;
            if (!(operation instanceof BackupAwareOperation) || !(backupAwareOperation = (BackupAwareOperation)((Object)operation)).shouldBackup()) continue;
            backupOpList.add(backupAwareOperation.getBackupOperation());
        }
        return new TxnCommitBackupOperation(this.name, this.dataKey, backupOpList, this.getCallerUuid(), this.threadId);
    }

    @Override
    public boolean shouldNotify() {
        return this.notify;
    }

    @Override
    public WaitNotifyKey getNotifiedKey() {
        return this.getWaitKey();
    }

    @Override
    public int getClassId() {
        return 28;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        SerializationUtil.writeList(this.opList, out);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.opList = SerializationUtil.readList(in);
    }
}

