/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.querycache.event;

import com.hazelcast.cluster.Address;
import com.hazelcast.internal.cluster.Versions;
import com.hazelcast.internal.serialization.BinaryInterface;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.map.impl.event.EventData;
import com.hazelcast.map.impl.querycache.event.QueryCacheEventData;
import com.hazelcast.map.impl.querycache.event.QueryCacheEventDataBuilder;
import com.hazelcast.map.impl.querycache.event.sequence.Sequenced;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.impl.Versioned;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;

@BinaryInterface
public class BatchEventData
implements Sequenced,
EventData,
Versioned {
    private String source;
    private Collection<QueryCacheEventData> events;
    private transient int partitionId;
    private transient String mapName;

    public BatchEventData() {
    }

    public BatchEventData(Collection<QueryCacheEventData> events, String source, int partitionId) {
        this.events = Preconditions.checkNotNull(events, "events cannot be null");
        this.source = Preconditions.checkNotNull(source, "source cannot be null");
        this.partitionId = Preconditions.checkNotNegative(partitionId, "partitionId cannot be negative");
    }

    public void add(QueryCacheEventData entry) {
        this.events.add(entry);
    }

    public Collection<QueryCacheEventData> getEvents() {
        return this.events;
    }

    public boolean isEmpty() {
        return this.events.isEmpty();
    }

    public int size() {
        return this.events.size();
    }

    @Override
    public int getPartitionId() {
        return this.partitionId;
    }

    @Override
    public String getSource() {
        return this.source;
    }

    @Override
    public String getMapName() {
        if (this.mapName != null) {
            return this.mapName;
        }
        if (this.events.isEmpty()) {
            return null;
        }
        QueryCacheEventData next = this.events.iterator().next();
        this.mapName = next.getMapName();
        return this.mapName;
    }

    @Override
    public Address getCaller() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getEventType() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getSequence() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setSequence(long sequence) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        Collection<QueryCacheEventData> events = this.events;
        out.writeString(this.source);
        out.writeInt(events.size());
        for (QueryCacheEventData eventData : events) {
            eventData.writeData(out);
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.source = in.readString();
        int size = in.readInt();
        if (size > 0) {
            this.events = new ArrayList<QueryCacheEventData>(size);
            for (int i = 0; i < size; ++i) {
                QueryCacheEventData eventData = QueryCacheEventDataBuilder.newQueryCacheEventDataBuilder(true).build();
                eventData.readData(in);
                assert (in.getVersion().isLessThan(Versions.V5_4) || eventData.getMapName() != null) : String.format("Map name should not be null in version %s and above", Versions.V5_4);
                this.events.add(eventData);
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BatchEventData)) {
            return false;
        }
        BatchEventData that = (BatchEventData)o;
        return this.events != null ? this.events.equals(that.events) : that.events == null;
    }

    public int hashCode() {
        return this.events != null ? this.events.hashCode() : 0;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("BatchEventData{");
        for (QueryCacheEventData event : this.events) {
            stringBuilder.append(event);
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }
}

